/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.migration;

import com.atlassian.applinks.internal.common.status.oauth.OAuthConfig;
import com.atlassian.applinks.internal.status.LegacyConfig;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public final class AuthenticationConfig
implements LegacyConfig {
    private final OAuthConfig oAuthConfig;
    private final boolean basicConfigured;

    public AuthenticationConfig() {
        this(OAuthConfig.createDisabledConfig(), false);
    }

    public AuthenticationConfig(@Nonnull OAuthConfig oAuthConfig, boolean basicConfigured) {
        this.oAuthConfig = Objects.requireNonNull(oAuthConfig, "oAuthConfig");
        this.basicConfigured = basicConfigured;
    }

    public boolean isOAuthConfigured() {
        return this.oAuthConfig.isEnabled();
    }

    @Override
    public boolean isBasicConfigured() {
        return this.basicConfigured;
    }

    @Nonnull
    public OAuthConfig getOAuthConfig() {
        return this.oAuthConfig;
    }

    public AuthenticationConfig basicConfigured(boolean basicConfigured) {
        return new AuthenticationConfig(this.oAuthConfig, basicConfigured);
    }

    public AuthenticationConfig oauth(OAuthConfig oAuthConfig) {
        return new AuthenticationConfig(oAuthConfig, this.basicConfigured);
    }
}

