/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.migration.remote;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.internal.migration.remote.RemoteActionHandler;
import com.atlassian.applinks.internal.migration.remote.TryWithAuthentication;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuerySysAdminAccess
extends TryWithAuthentication {
    public static final TryWithAuthentication INSTANCE = new QuerySysAdminAccess();
    public static final String SYS_ADMIN_ACCESS_PATH = "/plugins/servlet/applinks/auth/conf/cors/";
    private static final Logger LOGGER = LoggerFactory.getLogger(QuerySysAdminAccess.class);

    private QuerySysAdminAccess() {
    }

    @Override
    public boolean execute(@Nonnull ApplicationLink applicationLink, @Nonnull ApplicationId localApplicationId, @Nonnull ApplicationLinkRequestFactory factory) throws IOException, CredentialsRequiredException, ResponseException {
        String url = SYS_ADMIN_ACCESS_PATH + String.valueOf(localApplicationId);
        ApplicationLinkRequest request = factory.createRequest(Request.MethodType.HEAD, url);
        request.setHeader("X-Atlassian-Token", "no-check");
        RemoteActionHandler handler = new RemoteActionHandler();
        request.setConnectionTimeout((int)TimeUnit.SECONDS.toMillis(TryWithAuthentication.TIME_OUT_IN_SECONDS));
        request.setSoTimeout((int)TimeUnit.SECONDS.toMillis(TryWithAuthentication.TIME_OUT_IN_SECONDS));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(Request.MethodType.HEAD.name() + " " + String.valueOf(applicationLink.getRpcUrl()) + url);
        }
        request.execute((ResponseHandler)handler);
        return handler.isSuccessful();
    }
}

