/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.feature;

import com.atlassian.applinks.core.rest.context.UriInfoFilterBinding;
import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.internal.feature.FeatureDiscoveryService;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Set;

@UnrestrictedAccess
@Path(value="feature-discovery")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@UriInfoFilterBinding
@NoCacheHeaderFilterBinding
public class FeatureDiscoveryResource {
    private static final String FEATURE_KEY_PARAM = "featureKey";
    private static final String FEATURE_KEY_URI_TEMPLATE = "{featureKey}";
    private final FeatureDiscoveryService featureDiscoveryService;

    @Inject
    public FeatureDiscoveryResource(FeatureDiscoveryService featureDiscoveryService) {
        this.featureDiscoveryService = featureDiscoveryService;
    }

    @GET
    @Path(value="{featureKey}")
    public Response isDiscovered(@PathParam(value="featureKey") String featureKey) throws ServiceException {
        return this.featureDiscoveryService.isDiscovered(featureKey) ? Response.ok(FeatureDiscoveryResource.featureKeyRestEntity(featureKey)).build() : Response.status((Response.Status)Response.Status.NOT_FOUND).entity(FeatureDiscoveryResource.featureKeyRestEntity(featureKey)).build();
    }

    @GET
    public Response getAllDiscoveredFeatures() throws ServiceException {
        return Response.ok(this.featureDiscoveryService.getAllDiscoveredFeatureKeys()).build();
    }

    @PUT
    @Path(value="{featureKey}")
    public Response discover(@PathParam(value="featureKey") String featureKey) throws ServiceException {
        this.featureDiscoveryService.discover(featureKey);
        return Response.ok(FeatureDiscoveryResource.featureKeyRestEntity(featureKey)).build();
    }

    private static Set<String> featureKeyRestEntity(String featureKey) {
        return Collections.singleton(featureKey);
    }
}

