/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.interceptor;

import com.atlassian.applinks.internal.rest.model.RestErrors;
import com.fasterxml.jackson.core.JsonParseException;
import jakarta.annotation.Priority;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=5000)
public class JsonParseExceptionMapper
implements ExceptionMapper<JsonParseException> {
    private static final Logger log = LoggerFactory.getLogger(JsonParseExceptionMapper.class);
    @Context
    UriInfo uriInfo;

    private static Response createResponse(JsonParseException exception) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RestErrors(Response.Status.BAD_REQUEST, "Invalid request body")).build();
    }

    public Response toResponse(JsonParseException exception) {
        log.debug("JsonParseException intercepted from a REST call to {}", (Object)this.uriInfo.getRequestUri(), (Object)exception);
        return JsonParseExceptionMapper.createResponse(exception);
    }
}

