/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.interceptor;

import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.internal.common.net.ServiceExceptionHttpMapper;
import com.atlassian.applinks.internal.common.rest.util.RestErrorsFactory;
import jakarta.annotation.Priority;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=5000)
public class ServiceExceptionMapper
implements ExceptionMapper<ServiceException> {
    private static final Logger log = LoggerFactory.getLogger(ServiceExceptionMapper.class);
    @Context
    UriInfo uriInfo;

    private static Response createResponse(ServiceException serviceException) {
        Response.Status status = ServiceExceptionHttpMapper.getStatus(serviceException);
        return Response.status((Response.Status)status).entity((Object)RestErrorsFactory.fromException(status, serviceException)).build();
    }

    public Response toResponse(ServiceException serviceException) {
        log.debug("ServiceException intercepted from a REST call to {}", (Object)this.uriInfo.getRequestUri(), (Object)serviceException);
        return ServiceExceptionMapper.createResponse(serviceException);
    }
}

