/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.model.uniconn.mapper;

import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionAccessEntitlementDetailDto;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionAccessEntitlementsDto;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionConsentAccessEntitlementsDto;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionConsentDto;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionDto;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionExperienceDto;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionRequestDto;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionsResponseDto;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionService;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionConsent;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionConsentAccessEntitlements;
import com.atlassian.applinks.internal.uniconn.domain.DcAccessEntitlementDetail;
import com.atlassian.applinks.internal.uniconn.domain.DcAccessEntitlements;
import com.atlassian.applinks.internal.uniconn.domain.Experience;
import com.atlassian.applinks.internal.uniconn.domain.UniconnProductConnection;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CloudProductConnectionDtoMapper {
    private final CloudProductConnectionService cloudProductConnectionService;

    @Autowired
    CloudProductConnectionDtoMapper(CloudProductConnectionService cloudProductConnectionService) {
        this.cloudProductConnectionService = cloudProductConnectionService;
    }

    public CloudProductConnectionRequestDto toDto(@Nonnull CloudProductConnection connection) {
        return new CloudProductConnectionRequestDto(connection.id(), this.cloudProductConnectionService.getApplicationName(connection), connection.cloudContainerName(), this.cloudProductConnectionService.getAvatarUri(connection).toString(), UniconnApplinkUtils.getRequiredDcScopes(connection.experience()), connection.experience().cloudScopes(), connection.deleteConfirmationMessageOverride());
    }

    public CloudProductConnectionsResponseDto toProductConnectionsResponse(@Nonnull List<CloudProductConnection> connections) {
        List<CloudProductConnectionDto> mapped = connections.stream().map(this::toProductConnectionDto).toList();
        return new CloudProductConnectionsResponseDto(mapped);
    }

    public CloudProductConnectionDto toProductConnectionDto(@Nonnull CloudProductConnection productConnection) {
        return new CloudProductConnectionDto(productConnection.id(), productConnection.name(), productConnection.description(), productConnection.cloudContainerName(), productConnection.status().name(), productConnection.credentialsExpiry(), productConnection.iconId(), productConnection.iconImageOverride(), productConnection.displayUrl(), productConnection.connectionDependencies(), this.mapExperienceToDto(productConnection.experience()), productConnection.deleteConfirmationMessageOverride(), null, null);
    }

    public CloudProductConnectionDto toMergedConnectionDto(@Nonnull UniconnProductConnection merged) {
        return new CloudProductConnectionDto(merged.id(), merged.name(), merged.description(), merged.cloudContainerName(), merged.connectionRequestStatus().name(), merged.credentialsExpiry(), merged.iconId(), merged.iconImageOverride(), merged.displayUrl(), merged.connectionDependencies(), this.mapExperienceToDto(merged.experience()), merged.deleteConfirmationMessageOverride(), this.mapConsentToDto(merged.consent()), merged.source().name());
    }

    private CloudProductConnectionExperienceDto mapExperienceToDto(Experience experience) {
        if (experience == null) {
            return null;
        }
        CloudProductConnectionAccessEntitlementsDto dcAccessEntitlements = this.mapDcAccessEntitlementsToDto(experience.dcAccessEntitlements());
        return new CloudProductConnectionExperienceDto(dcAccessEntitlements, experience.cloudScopes());
    }

    private CloudProductConnectionAccessEntitlementsDto mapDcAccessEntitlementsToDto(DcAccessEntitlements dcAccessEntitlements) {
        if (dcAccessEntitlements == null) {
            return null;
        }
        CloudProductConnectionAccessEntitlementDetailDto required = this.mapDcAccessEntitlementDetailToDto(dcAccessEntitlements.required());
        CloudProductConnectionAccessEntitlementDetailDto optional = this.mapDcAccessEntitlementDetailToDto(dcAccessEntitlements.optional());
        return new CloudProductConnectionAccessEntitlementsDto(required, optional, dcAccessEntitlements.consentText());
    }

    private CloudProductConnectionAccessEntitlementDetailDto mapDcAccessEntitlementDetailToDto(DcAccessEntitlementDetail detail) {
        if (detail == null) {
            return null;
        }
        return new CloudProductConnectionAccessEntitlementDetailDto(detail.description(), detail.scopes(), detail.dataExportEntitlements());
    }

    private CloudProductConnectionConsentDto mapConsentToDto(CloudProductConnectionConsent consent) {
        if (consent == null) {
            return null;
        }
        return new CloudProductConnectionConsentDto(this.mapConsentAccessEntitlementsToDto(consent.dcAccessEntitlements()));
    }

    private CloudProductConnectionConsentAccessEntitlementsDto mapConsentAccessEntitlementsToDto(CloudProductConnectionConsentAccessEntitlements dcAccessEntitlements) {
        if (dcAccessEntitlements == null) {
            return null;
        }
        return new CloudProductConnectionConsentAccessEntitlementsDto(dcAccessEntitlements.scopes(), dcAccessEntitlements.dataExportEntitlements());
    }
}

