/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.status;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.core.ApplinkStatusService;
import com.atlassian.applinks.core.rest.context.UriInfoFilterBinding;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.applink.ApplinkHelper;
import com.atlassian.applinks.internal.common.exception.NoAccessException;
import com.atlassian.applinks.internal.common.exception.NoSuchApplinkException;
import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.internal.common.rest.util.RestApplicationIdParser;
import com.atlassian.applinks.internal.rest.RestUrl;
import com.atlassian.applinks.internal.rest.RestUrlBuilder;
import com.atlassian.applinks.internal.rest.RestVersion;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.internal.rest.model.status.RestApplinkOAuthStatus;
import com.atlassian.applinks.internal.rest.model.status.RestApplinkStatus;
import com.atlassian.applinks.internal.status.oauth.OAuthStatusService;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;

@Api
@Path(value="status")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@UnrestrictedAccess
@UriInfoFilterBinding
@NoCacheHeaderFilterBinding
public class ApplinkStatusResource {
    public static final String CONTEXT = "status";
    public static final RestUrl STATUS_PATH = RestUrl.forPath("status");
    public static final RestUrl OAUTH_PATH = RestUrl.forPath("oauth");
    private static final String AUTHORISATION_CALLBACK = "authorisationCallback";
    private static final String READ_SCOPE = "READ";
    private static final String BITBUCKET_PUBLIC_REPOS_SCOPE = "PUBLIC_REPOS";
    private final ApplinkHelper applinkHelper;
    private final ApplinkStatusService applinkStatusService;
    private final OAuthStatusService oAuthStatusService;

    @Nonnull
    public static RestUrlBuilder statusUrl(@Nonnull ApplicationId id) {
        return new RestUrlBuilder().version(RestVersion.V3).addPath(STATUS_PATH).addApplicationId(id);
    }

    @Nonnull
    public static RestUrlBuilder oAuthStatusUrl(@Nonnull ApplicationId id) {
        return ApplinkStatusResource.statusUrl(id).addPath(OAUTH_PATH);
    }

    @Inject
    public ApplinkStatusResource(ApplinkHelper applinkHelper, ApplinkStatusService applinkStatusService, OAuthStatusService oAuthStatusService) {
        this.applinkHelper = applinkHelper;
        this.applinkStatusService = applinkStatusService;
        this.oAuthStatusService = oAuthStatusService;
    }

    @ApiOperation(value="Returns the status of the Applink with a given id", authorizations={@Authorization(value="Admin")}, response=RestApplinkStatus.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successful"), @ApiResponse(code=401, message="User does not have Administrator access"), @ApiResponse(code=404, message="No Applink with the given ID exists on this server")})
    @GET
    @Path(value="{id}")
    public Response getStatus(@PathParam(value="id") String id, @ApiParam(hidden=true) @QueryParam(value="authorisationCallback") String authorisationCallback) throws NoAccessException, NoSuchApplinkException {
        URI uriAuthorisationCallback = ApplinkStatusResource.parseAuthorisationCallback(authorisationCallback);
        return RestUtil.ok(new RestApplinkStatus(this.applinkStatusService.getApplinkStatus(RestApplicationIdParser.parseApplicationId(id)), uriAuthorisationCallback));
    }

    @ApiOperation(value="Get the Applink Oauth status for an applink with the given id", response=RestApplinkOAuthStatus.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successful"), @ApiResponse(code=404, message="No Applink with the given ID exists on this server")})
    @GET
    @Path(value="{id}/oauth")
    @ScopesAllowed(requiredScope={"READ", "PUBLIC_REPOS"})
    public Response getOAuthStatus(@PathParam(value="id") String id) throws ServiceException {
        return RestUtil.ok(new RestApplinkOAuthStatus(this.oAuthStatusService.getOAuthStatus(RestApplicationIdParser.parseApplicationId(id))));
    }

    @ApiOperation(value="Update the Applink Oauth status for an applink with the given id", authorizations={@Authorization(value="Admin")}, notes="NOTE: Enabling Two-legged OAuth with Impersonation requires Sysadmin access", response=RestApplinkOAuthStatus.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Update successful"), @ApiResponse(code=401, message="User does not have Administrator access"), @ApiResponse(code=404, message="No Applink with the given ID exists on this server"), @ApiResponse(code=500, message="Malformed json body (this will hopefully be fixed in a future API release)"), @ApiResponse(code=409, message="Public key for remote host unavailable and no cached credenitals exist")})
    @PUT
    @Path(value="{id}/oauth")
    public Response updateOAuthStatus(@PathParam(value="id") String id, RestApplinkOAuthStatus restOAuthStatus) throws ServiceException {
        ApplicationLink link = this.applinkHelper.getApplicationLink(RestApplicationIdParser.parseApplicationId(id));
        this.oAuthStatusService.updateOAuthStatus(link, restOAuthStatus.asDomain());
        return RestUtil.noContent();
    }

    private static URI parseAuthorisationCallback(String authorisationCallback) {
        if (authorisationCallback == null) {
            return null;
        }
        try {
            URI callback = new URI(authorisationCallback);
            if (callback.isAbsolute()) {
                return callback;
            }
            throw new WebApplicationException(RestUtil.badRequest("authorisationCallback must be absolute"));
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException(RestUtil.badRequest(e.getMessage()));
        }
    }
}

