/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.uniconn;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.core.rest.model.ApplicationLinkEntity;
import com.atlassian.applinks.core.rest.model.CreatedApplicationLinkEntity;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionAcceptRequest;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionConsentDto;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionDto;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionsResponseDto;
import com.atlassian.applinks.internal.rest.model.uniconn.RejectCloudProductConnectionRequest;
import com.atlassian.applinks.internal.rest.model.uniconn.mapper.CloudProductConnectionDtoMapper;
import com.atlassian.applinks.internal.rest.uniconn.filter.UniconnFeatureFilterBinding;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionApplicationLinkService;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionService;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionStatusService;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.UniconnProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.UniconnProductConnectionStatusDetails;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.plugins.rest.api.model.Link;
import com.atlassian.plugins.rest.api.model.Status;
import com.atlassian.sal.api.message.I18nResolver;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.NoSuchElementException;
import org.springframework.web.bind.annotation.RequestBody;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="uniconn/product-connections")
@Singleton
@NoCacheHeaderFilterBinding
@UniconnFeatureFilterBinding
public class CloudProductConnectionsResource {
    public static final String CONTEXT = "uniconn/product-connections";
    private final CloudProductConnectionService cloudProductConnectionService;
    private final CloudProductConnectionDtoMapper cloudProductConnectionDtoMapper;
    private final CloudProductConnectionApplicationLinkService cloudProductConnectionApplicationLinkService;
    private final CloudProductConnectionStatusService cloudProductConnectionStatusService;
    private final I18nResolver i18nResolver;
    private final MutatingApplicationLinkService applicationLinkService;

    @Inject
    public CloudProductConnectionsResource(CloudProductConnectionService cloudProductConnectionService, CloudProductConnectionDtoMapper cloudProductConnectionDtoMapper, CloudProductConnectionApplicationLinkService cloudProductConnectionApplicationLinkService, CloudProductConnectionStatusService cloudProductConnectionStatusService, I18nResolver i18nResolver, MutatingApplicationLinkService applicationLinkService) {
        this.cloudProductConnectionService = cloudProductConnectionService;
        this.cloudProductConnectionDtoMapper = cloudProductConnectionDtoMapper;
        this.cloudProductConnectionApplicationLinkService = cloudProductConnectionApplicationLinkService;
        this.cloudProductConnectionStatusService = cloudProductConnectionStatusService;
        this.i18nResolver = i18nResolver;
        this.applicationLinkService = applicationLinkService;
    }

    @GET
    @ApiOperation(value="Get active cloud product connections", response=CloudProductConnectionsResponseDto.class)
    @ApiResponses(value={@ApiResponse(code=200, message="success"), @ApiResponse(code=403, message="User does not have System Admin access")})
    public Response getCloudProductConnections() {
        List<UniconnProductConnection> uniconnProductConnectionList = this.cloudProductConnectionService.getProductConnections();
        List<CloudProductConnectionDto> dtos = uniconnProductConnectionList.stream().map(this.cloudProductConnectionDtoMapper::toMergedConnectionDto).toList();
        CloudProductConnectionsResponseDto dto = new CloudProductConnectionsResponseDto(dtos);
        return Response.ok((Object)dto).build();
    }

    @POST
    @Path(value="{id}/rejection")
    @ApiOperation(value="Reject a pending cloud product connection")
    @ApiResponses(value={@ApiResponse(code=204, message="Rejected successfully"), @ApiResponse(code=403, message="User does not have System Admin access"), @ApiResponse(code=404, message="Cloud product connection not found"), @ApiResponse(code=502, message="Failed to interact with external services")})
    public Response rejectCloudProductConnection(@PathParam(value="id") String id, @Valid RejectCloudProductConnectionRequest body) {
        String reason = body.reason() == null ? null : body.reason().trim();
        this.cloudProductConnectionService.rejectConnectionRequest(id, reason);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="{id}/consent")
    @ApiOperation(value="Edit consent for an existing cloud product connection", response=CloudProductConnectionConsentDto.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Consent updated successfully"), @ApiResponse(code=403, message="User does not have System Admin access"), @ApiResponse(code=404, message="Cloud product connection not found"), @ApiResponse(code=500, message="Consent update failed")})
    public Response editCloudProductConnectionConsent(@PathParam(value="id") String id, @Valid CloudProductConnectionConsentDto consentDto) {
        CloudProductConnection cloudProductConnection = this.cloudProductConnectionService.getConnection(id);
        if (cloudProductConnection == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.error.uniconn.connection.not.found", new Serializable[]{id}));
        }
        CloudProductConnectionConsentDto updatedConsent = this.cloudProductConnectionApplicationLinkService.editConsentForProductConnection(cloudProductConnection, consentDto);
        return Response.ok((Object)updatedConsent).build();
    }

    @DELETE
    @Path(value="{id}/credentials")
    @ApiOperation(value="Delete credentials for an existing cloud product connection")
    @ApiResponses(value={@ApiResponse(code=204, message="Credentials deleted successfully"), @ApiResponse(code=403, message="User does not have System Admin access"), @ApiResponse(code=404, message="Product connection not found"), @ApiResponse(code=409, message="No product credentials not found for deletion"), @ApiResponse(code=500, message="Failed to revoke credentials")})
    public Response deleteCloudProductConnectionCredentials(@PathParam(value="id") String id) {
        this.cloudProductConnectionApplicationLinkService.revokeProductConnectionCredentials(id);
        return Response.noContent().build();
    }

    @GET
    @Path(value="{id}/status")
    @ApiOperation(value="Get the status of a cloud product connection", response=UniconnProductConnectionStatusDetails.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Status retrieved successfully"), @ApiResponse(code=403, message="User does not have System Admin access"), @ApiResponse(code=404, message="Connection not found")})
    public Response getCloudProductConnectionStatus(@PathParam(value="id") String id) {
        CloudProductConnection cloudProductConnection = this.cloudProductConnectionService.getConnection(id);
        if (cloudProductConnection == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.error.uniconn.connection.not.found", new Serializable[]{id}));
        }
        UniconnProductConnectionStatusDetails statusDetails = this.cloudProductConnectionStatusService.getProductConnectionStatus(cloudProductConnection);
        return Response.ok((Object)statusDetails).build();
    }

    @POST
    @Path(value="{id}/acceptance")
    @ApiOperation(value="Create an application link based on a cloud product connection request", response=CreatedApplicationLinkEntity.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Application link created successfully"), @ApiResponse(code=400, message="Duplicate application link or creation failed due to invalid request"), @ApiResponse(code=403, message="User does not have System Admin access"), @ApiResponse(code=404, message="Connection request not found")})
    public Response createCloudProductConnectionApplicationLink(@PathParam(value="id") String connectionId, @Valid @RequestBody CloudProductConnectionAcceptRequest request) throws TypeNotInstalledException {
        ApplicationLink createdApplicationLink;
        CloudProductConnection cloudProductConnection;
        try {
            cloudProductConnection = this.cloudProductConnectionService.getConnectionRequestWithAppLocale(connectionId);
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.error.uniconn.connection.not.found", new Serializable[]{connectionId}));
        }
        try {
            createdApplicationLink = this.cloudProductConnectionApplicationLinkService.createCloudProductConnectionApplicationLink(cloudProductConnection, request);
        }
        catch (IllegalStateException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Status.badRequest().message(this.i18nResolver.getText("applinks.error.duplicate.applink", new Serializable[]{connectionId})).build()).build();
        }
        boolean autoConfigurationSuccessful = true;
        return RestUtil.ok(new CreatedApplicationLinkEntity(new ApplicationLinkEntity(createdApplicationLink, Link.self((URI)this.applicationLinkService.createSelfLinkFor(createdApplicationLink.getId()))), autoConfigurationSuccessful));
    }

    @DELETE
    @Path(value="/{connectionId}")
    @ApiOperation(value="Delete an application link and its associated cloud product connection")
    @ApiResponses(value={@ApiResponse(code=204, message="Application link and connection deleted successfully"), @ApiResponse(code=400, message="Failed to delete cloud product connection application link"), @ApiResponse(code=403, message="User does not have System Admin access"), @ApiResponse(code=404, message="Cloud product connection not found")})
    public Response deleteCloudProductConnectionApplicationLink(@PathParam(value="connectionId") String connectionId) {
        this.cloudProductConnectionApplicationLinkService.deleteCloudProductConnectionApplicationLink(connectionId);
        return Response.noContent().build();
    }
}

