/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.uniconn;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.internal.rest.uniconn.filter.UniconnFeatureFilterBinding;
import com.atlassian.applinks.internal.uniconn.HostApplicationMetadataService;
import com.atlassian.applinks.internal.uniconn.domain.HostApplicationMetadata;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="uniconn/metadata")
@Singleton
@NoCacheHeaderFilterBinding
@UniconnFeatureFilterBinding
public class HostApplicationMetadataResource {
    public static final String CONTEXT = "uniconn/metadata";
    private final HostApplicationMetadataService hostApplicationMetadataService;

    @Inject
    HostApplicationMetadataResource(HostApplicationMetadataService hostApplicationMetadataService) {
        this.hostApplicationMetadataService = hostApplicationMetadataService;
    }

    @GET
    @ApiOperation(value="Get host application metadata including host application information and available scopes", response=HostApplicationMetadata.class)
    @ApiResponses(value={@ApiResponse(code=200, message="success"), @ApiResponse(code=403, message="User does not have System Admin access")})
    public Response getHostApplicationMetadata() {
        HostApplicationMetadata metadata = this.hostApplicationMetadataService.getHostApplicationMetadata();
        return Response.ok((Object)metadata).build();
    }
}

