/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.uniconn.filter;

import com.atlassian.applinks.internal.feature.ApplinksFeatureService;
import com.atlassian.applinks.internal.feature.ApplinksFeatures;
import com.atlassian.applinks.internal.rest.uniconn.filter.UniconnFeatureFilterBinding;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=5000)
@UniconnFeatureFilterBinding
public class UniconnFeatureFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(UniconnFeatureFilter.class);
    private final ApplinksFeatureService featureService;

    @Inject
    public UniconnFeatureFilter(ApplinksFeatureService featureService) {
        this.featureService = featureService;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        log.debug("UniconnFeatureFilter: Processing request");
        boolean isEnabled = this.featureService.isEnabled(ApplinksFeatures.UNICONN);
        log.debug("UniconnFeatureFilter: Feature enabled: {}", (Object)isEnabled);
        if (!isEnabled) {
            log.info("UniconnFeatureFilter: Blocking access to uniconn endpoint - feature disabled");
            requestContext.abortWith(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        } else {
            log.trace("UniconnFeatureFilter: Allowing access to uniconn endpoint - feature enabled");
        }
    }
}

