/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.status.oauth.remote;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthAuthenticationProvider;
import com.atlassian.applinks.core.rest.ManifestResource;
import com.atlassian.applinks.internal.common.auth.oauth.ApplinksOAuth;
import com.atlassian.applinks.internal.common.net.ResponsePreconditions;
import com.atlassian.applinks.internal.rest.client.AuthorisationUriAwareRequest;
import com.atlassian.applinks.internal.rest.client.RestRequestBuilder;
import com.atlassian.applinks.internal.status.error.ApplinkErrorType;
import com.atlassian.applinks.internal.status.error.ApplinkStatusException;
import com.atlassian.applinks.internal.status.error.NetworkErrorTranslator;
import com.atlassian.applinks.internal.status.error.SimpleApplinkStatusException;
import com.atlassian.applinks.internal.status.oauth.remote.OAuthConnectionVerifier;
import com.atlassian.applinks.internal.util.remote.AnonymousApplinksResponseHandler;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class TwoLeggedOAuthConnectionVerifier
implements OAuthConnectionVerifier {
    private final AuthenticationConfigurationManager authenticationConfigurationManager;

    @Autowired
    public TwoLeggedOAuthConnectionVerifier(AuthenticationConfigurationManager authenticationConfigurationManager) {
        this.authenticationConfigurationManager = authenticationConfigurationManager;
    }

    @Override
    public void verifyOAuthConnection(@Nonnull ApplicationLink link) throws ApplinkStatusException {
        Objects.requireNonNull(link, "link");
        if (this.is2LoOAuth10Configured(link)) {
            TwoLeggedOAuthConnectionVerifier.getManifestWithOAuth1Credentials(link);
        } else if (this.is2LoOAuth20Configured(link)) {
            TwoLeggedOAuthConnectionVerifier.getManifestWithOAuth2ClientCredentials(link);
        }
    }

    private boolean is2LoOAuth10Configured(ApplicationLink link) {
        return this.isConfigured(link, TwoLeggedOAuthAuthenticationProvider.class);
    }

    private boolean is2LoOAuth20Configured(ApplicationLink link) {
        return this.isConfigured(link, TwoLeggedOAuth2AuthenticationProvider.class);
    }

    private static void getManifestWithOAuth1Credentials(ApplicationLink link) {
        try {
            AuthorisationUriAwareRequest request = new RestRequestBuilder(link).methodType(Request.MethodType.GET).url(ManifestResource.manifestUrl()).accept("application/json").authentication(TwoLeggedOAuthAuthenticationProvider.class).buildAnonymous();
            request.execute(new OAuthEchoResponseHandler());
        }
        catch (ResponseException e) {
            throw NetworkErrorTranslator.toApplinkErrorException(e, "2LO OAuth request failed");
        }
    }

    private static void getManifestWithOAuth2ClientCredentials(ApplicationLink link) {
        try {
            AuthorisationUriAwareRequest request = new RestRequestBuilder(link).methodType(Request.MethodType.GET).url(ManifestResource.manifestUrl()).accept("application/json").buildAnonymous();
            request.execute(new OAuthEchoResponseHandler());
        }
        catch (ResponseException e) {
            throw NetworkErrorTranslator.toApplinkErrorException(e, "Request for manifest with OAuth 2.0 client_credentials token failed");
        }
    }

    private boolean isConfigured(ApplicationLink link, Class<? extends AuthenticationProvider> provider) {
        return this.authenticationConfigurationManager.isConfigured(link.getId(), provider);
    }

    private static class OAuthEchoResponseHandler
    extends AnonymousApplinksResponseHandler<Void> {
        private OAuthEchoResponseHandler() {
        }

        public Void handle(Response response) throws ResponseException {
            ResponsePreconditions.checkStatus(response, Response.Status.OK, Response.Status.UNAUTHORIZED);
            if (response.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                if (ApplinksOAuth.isAuthLevelDisabled(response)) {
                    throw new SimpleApplinkStatusException(ApplinkErrorType.AUTH_LEVEL_UNSUPPORTED, "Received 401 from remote application, indicating that 2LO is not enabled");
                }
                ResponsePreconditions.fail(response);
            }
            return null;
        }
    }
}

