/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.ThreeLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.core.property.ApplicationLinkProperties;
import com.atlassian.applinks.core.property.PropertyService;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.applinks.internal.uniconn.UniconnOAuth2ClientService;
import com.atlassian.applinks.internal.uniconn.domain.UniconnConnectionRequest;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackboneApplicationLinkService {
    private static final Logger LOG = LoggerFactory.getLogger(BackboneApplicationLinkService.class);
    private final MutatingApplicationLinkService applicationLinkService;
    private final PropertyService propertyService;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final UniconnOAuth2ClientService uniconnOAuth2ClientService;

    @Autowired
    public BackboneApplicationLinkService(MutatingApplicationLinkService applicationLinkService, PropertyService propertyService, AuthenticationConfigurationManager authenticationConfigurationManager, UniconnOAuth2ClientService clientService) {
        this.applicationLinkService = applicationLinkService;
        this.propertyService = propertyService;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.uniconnOAuth2ClientService = clientService;
    }

    public ApplicationLink createApplicationLink(UniconnConnectionRequest request) throws TypeNotInstalledException {
        ApplicationLinkDetails applicationLinkDetails = ApplicationLinkDetails.builder().name(request.getName()).rpcUrl(URI.create(request.getRpcUrl())).displayUrl(URI.create(request.getDisplayUrl())).isPrimary(request.isPrimary()).clientId(request.getIncomingClientId()).clientCredentialsClientConfigurationId(request.getClientCredentialsClientId()).authorizationCodeClientConfigurationId(request.getAuthorizationCodeClientId()).isCloud(request.isCloud()).build();
        this.setApplicationLinkProperties(request);
        MutableApplicationLink applicationLink = this.applicationLinkService.addApplicationLink(request.getApplicationId(), request.getApplicationType(), applicationLinkDetails);
        this.registerAuthenticationProviders(applicationLink);
        return applicationLink;
    }

    public void deleteApplicationLinkSafely(ApplicationLink applicationLink) {
        try {
            LOG.debug("Deleting local application link: {}", (Object)applicationLink.getId());
            this.applicationLinkService.deleteApplicationLink(applicationLink);
            LOG.debug("Successfully deleted local application link: {}", (Object)applicationLink.getId());
        }
        catch (Exception e) {
            LOG.error("Failed to delete application link with id: {}", (Object)applicationLink.getId(), (Object)e);
            throw new IllegalStateException("Failed to delete application link with id: " + String.valueOf(applicationLink.getId()), e);
        }
    }

    public void cleanupFailedCreation(@Nullable ApplicationLink applicationLink, @Nullable String incomingClientId, @Nullable String authorizationCodeClientId, @Nullable String clientCredentialsClientId) {
        if (applicationLink != null) {
            try {
                this.applicationLinkService.deleteApplicationLink(applicationLink);
            }
            catch (Exception ex) {
                LOG.error("Failed to delete application link during clean up", (Throwable)ex);
            }
        } else {
            this.uniconnOAuth2ClientService.deleteInboundClient(incomingClientId);
            this.uniconnOAuth2ClientService.deleteOutboundClient(authorizationCodeClientId);
            this.uniconnOAuth2ClientService.deleteOutboundClient(clientCredentialsClientId);
        }
    }

    private void setApplicationLinkProperties(UniconnConnectionRequest request) {
        ApplicationLinkProperties properties = this.propertyService.getApplicationLinkProperties(request.getApplicationId());
        properties.putProperty(UniconnApplinkProperties.UNICONN.key(), String.valueOf(true));
        properties.setIsCloud(request.isCloud());
        properties.setSystem(true);
        if (request.getIncomingClientId() != null) {
            properties.setClientId(request.getIncomingClientId());
        }
        if (request.getAuthorizationCodeClientId() != null) {
            properties.setAuthorizationCodeClientConfigurationId(request.getAuthorizationCodeClientId());
        }
        if (request.getClientCredentialsClientId() != null) {
            properties.setClientCredentialsClientConfigurationId(request.getClientCredentialsClientId());
        }
        request.getConnectionProperties().forEach(properties::putProperty);
    }

    private void registerAuthenticationProviders(MutableApplicationLink applicationLink) {
        if (!StringUtils.isEmpty((CharSequence)applicationLink.getAuthorizationCodeClientConfigurationId())) {
            this.registerAuthenticationProvider(applicationLink, ThreeLeggedOAuth2AuthenticationProvider.class);
        }
        if (!StringUtils.isEmpty((CharSequence)applicationLink.getClientCredentialsClientConfigurationId())) {
            this.registerAuthenticationProvider(applicationLink, TwoLeggedOAuth2AuthenticationProvider.class);
        }
    }

    private void registerAuthenticationProvider(MutableApplicationLink applicationLink, Class<? extends AuthenticationProvider> providerClass) {
        if (!this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), providerClass)) {
            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), providerClass, Collections.emptyMap());
        }
    }
}

