/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import java.util.Optional;

public class BackboneConnectionHealthcheckResult {
    private final Status status;
    private final Long tokenExpirationTime;

    private BackboneConnectionHealthcheckResult(Status status, Long tokenExpirationTime) {
        this.status = status;
        this.tokenExpirationTime = tokenExpirationTime;
    }

    public static BackboneConnectionHealthcheckResult healthy(Long tokenExpirationTime) {
        return new BackboneConnectionHealthcheckResult(Status.HEALTHY, tokenExpirationTime);
    }

    public static BackboneConnectionHealthcheckResult authFailure() {
        return new BackboneConnectionHealthcheckResult(Status.AUTH_FAILURE, null);
    }

    public static BackboneConnectionHealthcheckResult networkFailure() {
        return new BackboneConnectionHealthcheckResult(Status.NETWORK_FAILURE, null);
    }

    public static BackboneConnectionHealthcheckResult notAvailable() {
        return new BackboneConnectionHealthcheckResult(Status.NOT_AVAILABLE, null);
    }

    public static BackboneConnectionHealthcheckResult unknown() {
        return new BackboneConnectionHealthcheckResult(Status.UNKNOWN, null);
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<Long> getTokenExpirationTime() {
        return Optional.ofNullable(this.tokenExpirationTime);
    }

    public static enum Status {
        HEALTHY,
        AUTH_FAILURE,
        NETWORK_FAILURE,
        NOT_AVAILABLE,
        UNKNOWN;

    }
}

