/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.internal.rest.uniconn.exception.BackboneConnectionException;
import com.atlassian.applinks.internal.rest.uniconn.exception.SrsResponseException;
import com.atlassian.applinks.internal.uniconn.BackboneConnectionHealthcheckResult;
import com.atlassian.applinks.internal.uniconn.client.srs.SrsClient;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsHealthcheckResponse;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class BackboneConnectionHealthcheckService {
    private static final Logger LOG = LoggerFactory.getLogger(BackboneConnectionHealthcheckService.class);
    private final SrsClient srsClient;

    public BackboneConnectionHealthcheckService(SrsClient srsClient) {
        this.srsClient = srsClient;
    }

    public BackboneConnectionHealthcheckResult checkConnectionHealthcheck(ApplicationLink applicationLink) {
        try {
            SrsHealthcheckResponse response = this.srsClient.performHealthcheck();
            if (!"UP".equalsIgnoreCase(response.status())) {
                LOG.error("SrsHealthcheck returned unexpected link status response: {}", (Object)response);
                return BackboneConnectionHealthcheckResult.notAvailable();
            }
            Long tokenExpirationTime = null;
            if (response.details() != null) {
                tokenExpirationTime = response.details().tokenExpirationTime();
            }
            return BackboneConnectionHealthcheckResult.healthy(tokenExpirationTime);
        }
        catch (Exception e) {
            return this.handleRequestException(e, applicationLink.getId().toString());
        }
    }

    private BackboneConnectionHealthcheckResult handleRequestException(Exception e, String applicationLinkId) {
        if (e instanceof BackboneConnectionException) {
            LOG.error("Backbone connection error during healthcheck on application link {} : {}", (Object)applicationLinkId, (Object)e.getMessage());
            return BackboneConnectionHealthcheckResult.authFailure();
        }
        if (e instanceof SrsResponseException) {
            SrsResponseException srsException = (SrsResponseException)e;
            if (srsException.getStatusCode() == HttpStatus.UNAUTHORIZED.value()) {
                LOG.error("Authentication failure during backbone connection healthcheck on application link {} : {}", (Object)applicationLinkId, (Object)e);
                return BackboneConnectionHealthcheckResult.authFailure();
            }
            if (e.getCause() instanceof SocketException) {
                LOG.error("Connection error during backbone healthcheck on application link {} : {}", (Object)applicationLinkId, (Object)e.getMessage());
                return BackboneConnectionHealthcheckResult.networkFailure();
            }
            LOG.error("Error during backbone connection healthcheck on application link {} : status={}, message={}", new Object[]{applicationLinkId, srsException.getStatusCode(), e.getMessage()});
            return BackboneConnectionHealthcheckResult.unknown();
        }
        LOG.error("Unknown error during backbone connection healthcheck on application link {} : {}", (Object)applicationLinkId, (Object)e);
        return BackboneConnectionHealthcheckResult.unknown();
    }
}

