/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.internal.feature.ApplinksFeatureService;
import com.atlassian.applinks.internal.feature.ApplinksFeatures;
import com.atlassian.applinks.internal.uniconn.BackboneConnectionMonitoringService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackboneConnectionMonitoringJob
implements JobRunner,
LifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(BackboneConnectionMonitoringJob.class);
    private static final long SCHEDULE_INTERVAL = TimeUnit.MINUTES.toMillis(5L);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)BackboneConnectionMonitoringJob.class.getName());
    private static final JobId JOB_ID = JobId.of((String)"applinks-backbone-connection-monitoring-job");
    private final BackboneConnectionMonitoringService backboneConnectionMonitoringService;
    private final ApplinksFeatureService featureService;
    @Nonnull
    private final SchedulerService scheduler;

    @Autowired
    public BackboneConnectionMonitoringJob(@Nonnull BackboneConnectionMonitoringService backboneConnectionMonitoringService, @Nonnull ApplinksFeatureService featureService, @Nonnull SchedulerService scheduler) {
        this.backboneConnectionMonitoringService = backboneConnectionMonitoringService;
        this.featureService = featureService;
        this.scheduler = Objects.requireNonNull(scheduler);
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        if (!this.featureService.isEnabledForAllUsers(ApplinksFeatures.UNICONN)) {
            LOG.debug("Uniconn feature is disabled. Skipping backbone connection monitoring job.");
            return JobRunnerResponse.success();
        }
        try {
            LOG.debug("Starting backbone connection monitoring job - checking connection status and updating credentials expiry");
            this.backboneConnectionMonitoringService.updateConnectionStatusForBackboneConnection();
            LOG.debug("Backbone connection monitoring job completed successfully");
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            LOG.error("Error executing backbone connection monitoring job", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    private Schedule getSchedule() {
        return Schedule.forInterval((long)SCHEDULE_INTERVAL, null);
    }

    public void onStart() {
        this.scheduler.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        try {
            this.scheduler.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withSchedule(this.getSchedule()));
            LOG.info("Scheduled backbone connection monitoring job to run every {} minutes", (Object)TimeUnit.MINUTES.toMinutes(SCHEDULE_INTERVAL));
        }
        catch (SchedulerServiceException e) {
            LOG.error("Unable to schedule backbone connection monitoring job", (Throwable)e);
        }
    }

    public void onStop() {
        this.scheduler.unscheduleJob(JOB_ID);
        this.scheduler.unregisterJobRunner(JOB_RUNNER_KEY);
        LOG.debug("Unscheduled backbone connection monitoring job");
    }
}

