/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.event.ApplicationLinkAuthConfigChangedEvent;
import com.atlassian.applinks.internal.api.uniconn.BackboneApplicationType;
import com.atlassian.applinks.internal.rest.uniconn.exception.SrsResponseException;
import com.atlassian.applinks.internal.uniconn.BackboneConnectionHealthcheckResult;
import com.atlassian.applinks.internal.uniconn.BackboneConnectionHealthcheckService;
import com.atlassian.applinks.internal.uniconn.BackboneConnectionService;
import com.atlassian.applinks.internal.uniconn.SrsMetadataPublisherService;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.applinks.internal.uniconn.domain.BackboneConnectionStatus;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackboneConnectionMonitoringService
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(BackboneConnectionMonitoringService.class);
    private final BackboneConnectionService backboneConnectionService;
    private final BackboneConnectionHealthcheckService healthcheckService;
    private final SrsMetadataPublisherService metadataPublisherService;
    private final TransactionTemplate transactionTemplate;
    private final EventPublisher eventPublisher;
    private final Clock clock;

    @Autowired
    public BackboneConnectionMonitoringService(BackboneConnectionService backboneConnectionService, BackboneConnectionHealthcheckService healthcheckService, SrsMetadataPublisherService metadataPublisherService, TransactionTemplate transactionTemplate, EventPublisher eventPublisher, Clock clock) {
        this.backboneConnectionService = backboneConnectionService;
        this.healthcheckService = healthcheckService;
        this.transactionTemplate = transactionTemplate;
        this.metadataPublisherService = metadataPublisherService;
        this.eventPublisher = eventPublisher;
        this.clock = clock;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onApplinkAuthConfigChanged(ApplicationLinkAuthConfigChangedEvent event) {
        if (!(event.getApplicationLink().getType() instanceof BackboneApplicationType)) {
            return;
        }
        this.updateConnectionStatusForBackboneConnection();
    }

    public void updateConnectionStatusForBackboneConnection() {
        LOG.debug("Checking backbone connections status");
        this.transactionTemplate.execute(() -> {
            ApplicationLink backboneApplink = this.backboneConnectionService.getPrimaryBackboneApplink();
            if (backboneApplink == null) {
                LOG.debug("No backbone connections to check");
                return null;
            }
            try {
                BackboneConnectionStatus newStatus;
                BackboneConnectionStatus currentStatus = this.backboneConnectionService.getBackboneConnectionStatus(backboneApplink);
                if (currentStatus.isPermanentlyDisabled()) {
                    LOG.debug("Backbone connection {} is permanently disabled, skipping healthcheck", (Object)backboneApplink.getId());
                    return null;
                }
                if (currentStatus != BackboneConnectionStatus.CONNECTED) {
                    LOG.debug("Backbone connection {} is not connected (current status: {}), sending metadata", (Object)backboneApplink.getId(), (Object)currentStatus);
                    try {
                        this.metadataPublisherService.publishDCMetadata();
                    }
                    catch (SrsResponseException e) {
                        LOG.warn("Skipping connection healthcheck as metadata call failed for application link {}", (Object)backboneApplink.getId(), (Object)e);
                        this.backboneConnectionService.updateBackboneConnectionStatus(backboneApplink, BackboneConnectionStatus.INTERRUPTED);
                        return null;
                    }
                }
                if (!Objects.equals((Object)currentStatus, (Object)(newStatus = this.determineNewStatus(backboneApplink, currentStatus)))) {
                    this.backboneConnectionService.updateBackboneConnectionStatus(backboneApplink, newStatus);
                }
            }
            catch (Exception e) {
                LOG.error("Error updating status for backbone connection with id: {}", (Object)backboneApplink.getId(), (Object)e);
            }
            return null;
        });
    }

    private BackboneConnectionStatus determineNewStatus(ApplicationLink backboneConnection, BackboneConnectionStatus currentStatus) {
        if (this.areCredentialsExpired(backboneConnection)) {
            return BackboneConnectionStatus.EXPIRED;
        }
        BackboneConnectionHealthcheckResult healthcheckResult = this.healthcheckService.checkConnectionHealthcheck(backboneConnection);
        this.updateCredentialsExpiryFromHealthcheck(backboneConnection, healthcheckResult);
        return this.mapHealthcheckResultToStatus(healthcheckResult, currentStatus);
    }

    private BackboneConnectionStatus mapHealthcheckResultToStatus(BackboneConnectionHealthcheckResult result, BackboneConnectionStatus currentStatus) {
        return switch (result.getStatus()) {
            case BackboneConnectionHealthcheckResult.Status.HEALTHY -> BackboneConnectionStatus.CONNECTED;
            case BackboneConnectionHealthcheckResult.Status.AUTH_FAILURE, BackboneConnectionHealthcheckResult.Status.NETWORK_FAILURE, BackboneConnectionHealthcheckResult.Status.NOT_AVAILABLE, BackboneConnectionHealthcheckResult.Status.UNKNOWN -> BackboneConnectionStatus.INTERRUPTED;
            default -> currentStatus;
        };
    }

    private boolean areCredentialsExpired(ApplicationLink backboneConnection) {
        String expiryProperty = (String)backboneConnection.getProperty(UniconnApplinkProperties.CREDENTIALS_EXPIRY.key());
        if (expiryProperty == null) {
            return false;
        }
        try {
            Instant now = this.clock.instant();
            boolean isExpired = now.isAfter(Instant.ofEpochMilli(Long.parseLong(expiryProperty)));
            if (isExpired) {
                LOG.info("Credentials expired for backbone connection {}: expiry={}, current={}", new Object[]{backboneConnection.getId(), expiryProperty, now});
            }
            return isExpired;
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid credentials expiry format for backbone connection {}: {}", (Object)backboneConnection.getId(), (Object)expiryProperty);
            return false;
        }
    }

    private void updateCredentialsExpiryFromHealthcheck(ApplicationLink backboneConnection, BackboneConnectionHealthcheckResult healthcheckResult) {
        healthcheckResult.getTokenExpirationTime().ifPresent(tokenExpirationTime -> {
            backboneConnection.putProperty(UniconnApplinkProperties.CREDENTIALS_EXPIRY.key(), (Object)tokenExpirationTime.toString());
            LOG.debug("Updated credentials expiry time to {} for backbone connection {}", tokenExpirationTime, (Object)backboneConnection.getId());
        });
    }
}

