/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.internal.api.uniconn.BackboneApplicationType;
import com.atlassian.applinks.internal.rest.model.uniconn.CreateBackboneApplicationLinkRequest;
import com.atlassian.applinks.internal.rest.uniconn.exception.BackboneConnectionException;
import com.atlassian.applinks.internal.rest.uniconn.exception.CannotDisableBackboneException;
import com.atlassian.applinks.internal.uniconn.BackboneApplicationLinkService;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionService;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.applinks.internal.uniconn.UniconnOAuth2ClientService;
import com.atlassian.applinks.internal.uniconn.client.srs.SrsClient;
import com.atlassian.applinks.internal.uniconn.domain.BackboneConnection;
import com.atlassian.applinks.internal.uniconn.domain.BackboneConnectionRequest;
import com.atlassian.applinks.internal.uniconn.domain.BackboneConnectionStatus;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionRequestStatus;
import com.atlassian.applinks.internal.uniconn.domain.OAuth2GrantType;
import com.atlassian.applinks.internal.uniconn.domain.OAuthClientDetails;
import com.atlassian.applinks.internal.uniconn.domain.SrsEncodedCredentials;
import com.atlassian.applinks.internal.uniconn.domain.UniconnProductConnection;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.applinks.spi.application.ApplicationIdUtil;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.net.URI;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackboneConnectionService {
    private static final Logger LOG = LoggerFactory.getLogger(BackboneConnectionService.class);
    private static final String UNICONN_SKIP_URL_VALIDATION_FEATURE = "uniconn.skip.url.validation";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final MutatingApplicationLinkService applicationLinkService;
    private final TypeAccessor typeAccessor;
    private final BackboneApplicationLinkService backboneApplicationLinkService;
    private final UniconnOAuth2ClientService uniconnOAuth2ClientService;
    private final CloudProductConnectionService cloudProductConnectionService;
    private final SrsClient srsClient;
    private final I18nResolver i18nResolver;
    private final ApplicationProperties applicationProperties;
    private final DarkFeatureManager darkFeatureManager;

    @Autowired
    public BackboneConnectionService(MutatingApplicationLinkService applicationLinkService, TypeAccessor typeAccessor, BackboneApplicationLinkService backboneApplicationLinkService, UniconnOAuth2ClientService uniconnOAuth2ClientService, CloudProductConnectionService cloudProductConnectionService, SrsClient srsClient, I18nResolver i18nResolver, ApplicationProperties applicationProperties, DarkFeatureManager darkFeatureManager) {
        this.applicationLinkService = applicationLinkService;
        this.typeAccessor = typeAccessor;
        this.backboneApplicationLinkService = backboneApplicationLinkService;
        this.uniconnOAuth2ClientService = uniconnOAuth2ClientService;
        this.cloudProductConnectionService = cloudProductConnectionService;
        this.srsClient = srsClient;
        this.i18nResolver = i18nResolver;
        this.applicationProperties = applicationProperties;
        this.darkFeatureManager = darkFeatureManager;
    }

    public List<ApplicationLink> getApplinks() {
        ApplicationLink backboneApplink = this.applicationLinkService.getPrimaryApplicationLink(BackboneApplicationType.class);
        return backboneApplink == null ? Collections.emptyList() : Collections.singletonList(backboneApplink);
    }

    public ApplicationLink getPrimaryBackboneApplink() {
        return this.applicationLinkService.getPrimaryApplicationLink(BackboneApplicationType.class);
    }

    public boolean disableBackboneConnection() throws CannotDisableBackboneException {
        ApplicationLink backboneApplink = this.getPrimaryBackboneApplink();
        if (backboneApplink != null) {
            List<UniconnProductConnection> connections = this.cloudProductConnectionService.getProductConnections();
            if (connections.stream().anyMatch(conn -> conn.connectionRequestStatus() == CloudProductConnectionRequestStatus.ACCEPTED)) {
                throw new CannotDisableBackboneException();
            }
            boolean isDisabledInCloud = this.disableLinkInSrs();
            this.disableBackboneApplicationLink(backboneApplink);
            return isDisabledInCloud;
        }
        return false;
    }

    private void disableBackboneApplicationLink(ApplicationLink backboneApplink) {
        this.uniconnOAuth2ClientService.deleteOutboundClient(backboneApplink.getClientCredentialsClientConfigurationId());
        this.updateBackboneConnectionStatus(backboneApplink, BackboneConnectionStatus.DISCONNECTED);
    }

    private boolean disableLinkInSrs() {
        try {
            this.srsClient.disableBackboneConnection();
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to disable backbone connection in SRS", (Throwable)e);
            return false;
        }
    }

    public ApplicationLink createOrReplaceApplink(CreateBackboneApplicationLinkRequest backboneAppLinkRequest) throws TypeNotInstalledException {
        BackboneConnection backboneConnection;
        try {
            backboneConnection = this.buildBackboneConnection(this.decodeClientCredentials(backboneAppLinkRequest.clientCredentials()));
        }
        catch (Exception e) {
            LOG.error("Error building backbone connection from client credentials", (Throwable)e);
            throw new BackboneConnectionException(this.i18nResolver.getText("applinks.error.uniconn.backbone.credentials.invalid"), e);
        }
        if (!this.darkFeatureManager.isEnabledForAllUsers(UNICONN_SKIP_URL_VALIDATION_FEATURE).orElse(false).booleanValue()) {
            this.validateDataCenterUrl(backboneConnection);
        }
        this.handleExistingBackboneApplicationLink(backboneConnection);
        ClientConfigurationEntity clientCredentials = null;
        ApplicationLink backboneApplink = null;
        try {
            clientCredentials = this.uniconnOAuth2ClientService.createOrUpdateOutgoingClient(null, backboneConnection.orgName(), backboneConnection.orgId(), backboneConnection.oauthClientDetails());
            BackboneConnectionRequest request = new BackboneConnectionRequest(backboneConnection, clientCredentials.getId());
            backboneApplink = this.backboneApplicationLinkService.createApplicationLink(request);
        }
        catch (Exception e) {
            LOG.error("Error creating or replacing backbone application link", (Throwable)e);
            this.backboneApplicationLinkService.cleanupFailedCreation(backboneApplink, null, null, clientCredentials != null ? clientCredentials.getId() : null);
            throw new BackboneConnectionException(this.i18nResolver.getText("applinks.error.uniconn.backbone.create.error"), e);
        }
        return backboneApplink;
    }

    public void updateBackboneConnectionStatus(ApplicationLink backboneApplink, BackboneConnectionStatus status) {
        backboneApplink.putProperty(UniconnApplinkProperties.CONNECTION_STATUS.key(), (Object)status.name());
        LOG.debug("Updated backbone connection status to {} for application link {}", (Object)status, (Object)backboneApplink.getId());
    }

    public BackboneConnectionStatus getBackboneConnectionStatus(@Nonnull ApplicationLink backboneApplink) {
        String status = (String)backboneApplink.getProperty(UniconnApplinkProperties.CONNECTION_STATUS.key());
        if (StringUtils.isBlank((CharSequence)status)) {
            LOG.debug("No backbone connection status found for application link {}, defaulting to CREATED", (Object)backboneApplink.getId());
            return BackboneConnectionStatus.CREATED;
        }
        try {
            return BackboneConnectionStatus.valueOf(status);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unknown backbone connection status '{}' for application link {}", (Object)status, (Object)backboneApplink.getId());
            return BackboneConnectionStatus.CREATED;
        }
    }

    private void validateOrganizationChange(ApplicationLink existingBackboneApplink, BackboneConnection newBackboneConnection) {
        String existingOrgId = (String)existingBackboneApplink.getProperty(UniconnApplinkProperties.ORG_ID.key());
        String existingOrgName = (String)existingBackboneApplink.getProperty(UniconnApplinkProperties.ORG_NAME.key());
        String newOrgId = newBackboneConnection.orgId();
        String newOrgName = newBackboneConnection.orgName();
        if (!existingOrgId.equals(newOrgId)) {
            LOG.warn("Organization change attempt detected. Existing org: {} ({}), New org: {} ({})", new Object[]{existingOrgName, existingOrgId, newOrgName, newOrgId});
            String errorMessage = this.i18nResolver.getText("applinks.error.uniconn.backbone.credentials.wrong.organization", new Serializable[]{existingOrgName != null ? existingOrgName : existingOrgId});
            throw new BackboneConnectionException(errorMessage);
        }
    }

    private void validateDataCenterUrl(BackboneConnection newBackboneConnection) {
        String currentDcUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        String newBaseUrl = newBackboneConnection.baseUrl();
        if (!this.normalizeUrl(currentDcUrl).equals(this.normalizeUrl(newBaseUrl))) {
            LOG.warn("Data Center URL mismatch detected. Current DC URL: {}, Credentials URL: {}", (Object)currentDcUrl, (Object)newBaseUrl);
            String errorMessage = this.i18nResolver.getText("applinks.error.uniconn.backbone.credentials.wrong.url", new Serializable[]{currentDcUrl});
            throw new BackboneConnectionException(errorMessage);
        }
    }

    private String normalizeUrl(String url) {
        if (url == null) {
            return "";
        }
        String normalized = url.toLowerCase().trim();
        if (normalized.endsWith("/")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        return normalized;
    }

    private void handleExistingBackboneApplicationLink(BackboneConnection backboneConnection) throws TypeNotInstalledException {
        ApplicationId applicationId = backboneConnection.applicationId();
        MutableApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(applicationId);
        if (applicationLink != null && !(applicationLink.getType() instanceof BackboneApplicationType)) {
            throw new IllegalStateException("Application with server ID " + String.valueOf(applicationId) + " already exists");
        }
        ApplicationLink existingBackboneApplink = this.getPrimaryBackboneApplink();
        if (existingBackboneApplink != null) {
            if (!this.cloudProductConnectionService.getProductConnections().isEmpty()) {
                this.validateOrganizationChange(existingBackboneApplink, backboneConnection);
            }
            this.applicationLinkService.deleteApplicationLink(existingBackboneApplink);
        }
    }

    private BackboneConnection buildBackboneConnection(SrsEncodedCredentials backboneConnectionDetails) {
        String displayUrl = UniconnApplinkUtils.getDisplayUrl(backboneConnectionDetails.orgId());
        ApplicationId applicationId = ApplicationIdUtil.generate((URI)URI.create(displayUrl));
        ApplicationType backboneType = this.typeAccessor.getApplicationType(BackboneApplicationType.class);
        return new BackboneConnection(Objects.requireNonNull(applicationId, "applicationId"), Objects.requireNonNull(backboneType, "applicationType"), Objects.requireNonNull(backboneConnectionDetails.linkId(), "linkId"), Objects.requireNonNull(backboneConnectionDetails.orgId(), "orgId"), Objects.requireNonNull(backboneConnectionDetails.orgName(), "orgName"), backboneConnectionDetails.name(), backboneConnectionDetails.baseUrl(), BackboneConnectionStatus.CREATED, UniconnApplinkUtils.getBackboneRpcUrl(), Objects.requireNonNull(displayUrl, "displayUrl"), backboneConnectionDetails.oAuth2Credentials().clientExpiryMillis(), new OAuthClientDetails(OAuth2GrantType.CLIENT_CREDENTIALS_GRANT, Objects.requireNonNull(backboneConnectionDetails.oAuth2Credentials().clientId(), "clientId"), Objects.requireNonNull(backboneConnectionDetails.oAuth2Credentials().clientSecret(), "clientSecret"), backboneConnectionDetails.oAuth2Credentials().scopes(), Objects.requireNonNull(backboneConnectionDetails.oAuth2Credentials().tokenEndpoint(), "tokenEndpoint"), null, Collections.emptyMap()));
    }

    private SrsEncodedCredentials decodeClientCredentials(String clientCredentials) throws JsonProcessingException {
        Objects.requireNonNull(clientCredentials, "Client credentials must not be null");
        if (clientCredentials.trim().isEmpty()) {
            throw new IllegalArgumentException("Client credentials must not be empty");
        }
        String sanitizedToken = clientCredentials.trim();
        String base64decoded = new String(Base64.getDecoder().decode(sanitizedToken));
        SrsEncodedCredentials srsEncodedCredentials = (SrsEncodedCredentials)OBJECT_MAPPER.readValue(base64decoded, SrsEncodedCredentials.class);
        return srsEncodedCredentials;
    }
}

