/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.PropertySet;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.ThreeLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.core.property.ApplicationLinkProperties;
import com.atlassian.applinks.core.property.PropertyService;
import com.atlassian.applinks.internal.common.exception.ClientConfigurationScopesNotFoundException;
import com.atlassian.applinks.internal.common.exception.DefaultServiceExceptionFactory;
import com.atlassian.applinks.internal.common.exception.InvalidEmptyValueException;
import com.atlassian.applinks.internal.common.exception.InvalidValueException;
import com.atlassian.applinks.internal.common.exception.ServiceException;
import com.atlassian.applinks.internal.common.i18n.I18nKey;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionAcceptRequest;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionConsentAccessEntitlementsDto;
import com.atlassian.applinks.internal.rest.model.uniconn.CloudProductConnectionConsentDto;
import com.atlassian.applinks.internal.rest.uniconn.exception.CloudProductConnectionException;
import com.atlassian.applinks.internal.rest.uniconn.exception.CloudProductConnectionNotFoundException;
import com.atlassian.applinks.internal.rest.uniconn.exception.ProductConnectionCredentialsNotFoundException;
import com.atlassian.applinks.internal.rest.uniconn.exception.SrsResponseException;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionService;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.applinks.internal.uniconn.audit.UniconnAuditPublisherService;
import com.atlassian.applinks.internal.uniconn.client.srs.SrsClient;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsExchangeOauthCredentialsResponse;
import com.atlassian.applinks.internal.uniconn.client.srs.mapper.SrsExchangeOauthCredentialsResponseMapper;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionStatus;
import com.atlassian.applinks.internal.uniconn.domain.DcAccessEntitlementDetail;
import com.atlassian.applinks.internal.uniconn.domain.DcAccessEntitlements;
import com.atlassian.applinks.internal.uniconn.domain.OAuth2GrantType;
import com.atlassian.applinks.internal.uniconn.domain.OAuthClientDetails;
import com.atlassian.applinks.internal.uniconn.entitlements.DataExportEntitlementService;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigStorageService;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.client.api.storage.config.ProviderType;
import com.atlassian.oauth2.client.api.storage.token.exception.ConfigurationNotFoundException;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientService;
import com.atlassian.oauth2.provider.api.client.CreateClientEntity;
import com.atlassian.oauth2.provider.api.client.internal.InternalRotationClientService;
import com.atlassian.oauth2.scopes.api.InvalidScopeException;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CloudProductConnectionApplicationLinkService {
    private static final Logger LOG = LoggerFactory.getLogger(CloudProductConnectionApplicationLinkService.class);
    private final DefaultServiceExceptionFactory serviceExceptionFactory;
    private final MutatingApplicationLinkService applicationLinkService;
    private final ClientConfigStorageService clientConfigStorageService;
    private final CloudProductConnectionService cloudProductConnectionService;
    private final ScopeResolver scopeResolver;
    private final ClientService clientService;
    private final InternalRotationClientService internalClientService;
    private final SrsClient srsClient;
    private final SrsExchangeOauthCredentialsResponseMapper srsExchangeOauthCredentialsResponseMapper;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final PropertyService propertyService;
    private final I18nResolver i18nResolver;
    private final DataExportEntitlementService dataExportEntitlementService;
    private final TransactionTemplate transactionTemplate;
    private final UniconnAuditPublisherService uniconnAuditPublisherService;

    @Autowired
    public CloudProductConnectionApplicationLinkService(DefaultServiceExceptionFactory serviceExceptionFactory, MutatingApplicationLinkService applicationLinkService, ClientConfigStorageService clientConfigStorageService, CloudProductConnectionService cloudProductConnectionService, ScopeResolver scopeResolver, ClientService clientService, InternalRotationClientService internalClientService, SrsClient srsClient, SrsExchangeOauthCredentialsResponseMapper srsExchangeOauthCredentialsResponseMapper, AuthenticationConfigurationManager authenticationConfigurationManager, PropertyService propertyService, I18nResolver i18nResolver, DataExportEntitlementService dataExportEntitlementService, TransactionTemplate transactionTemplate, UniconnAuditPublisherService uniconnAuditPublisherService) {
        this.serviceExceptionFactory = serviceExceptionFactory;
        this.applicationLinkService = applicationLinkService;
        this.clientConfigStorageService = clientConfigStorageService;
        this.cloudProductConnectionService = cloudProductConnectionService;
        this.scopeResolver = scopeResolver;
        this.clientService = clientService;
        this.internalClientService = internalClientService;
        this.srsClient = srsClient;
        this.srsExchangeOauthCredentialsResponseMapper = srsExchangeOauthCredentialsResponseMapper;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.propertyService = propertyService;
        this.i18nResolver = i18nResolver;
        this.dataExportEntitlementService = dataExportEntitlementService;
        this.transactionTemplate = transactionTemplate;
        this.uniconnAuditPublisherService = uniconnAuditPublisherService;
    }

    private Set<String> getConsentedScopes(CloudProductConnectionAcceptRequest request) {
        if (request.consent() == null || request.consent().dcAccessEntitlements() == null) {
            return Set.of();
        }
        CloudProductConnectionConsentAccessEntitlementsDto dto = request.consent().dcAccessEntitlements();
        return dto.scopes() != null ? dto.scopes() : Set.of();
    }

    private Set<String> getConsentedDataExportEntitlements(CloudProductConnectionAcceptRequest request) {
        if (request.consent() == null || request.consent().dcAccessEntitlements() == null) {
            return Set.of();
        }
        CloudProductConnectionConsentAccessEntitlementsDto dto = request.consent().dcAccessEntitlements();
        return dto.dataExportEntitlements() != null ? dto.dataExportEntitlements() : Set.of();
    }

    private void validateConsent(CloudProductConnection connection, Set<String> consentedScopes, Set<String> consentedDataExportEntitlements) {
        this.validateScopesConsent(connection, consentedScopes);
        this.validateDataExportEntitlementsConsent(connection, consentedDataExportEntitlements);
    }

    private void validateScopesConsent(CloudProductConnection connection, Set<String> consentedScopes) {
        DcAccessEntitlements dcEntitlements = connection.experience().dcAccessEntitlements();
        DcAccessEntitlementDetail requiredDetail = dcEntitlements != null ? dcEntitlements.required() : null;
        DcAccessEntitlementDetail optionalDetail = dcEntitlements != null ? dcEntitlements.optional() : null;
        Set requiredScopes = requiredDetail != null && requiredDetail.scopes() != null ? requiredDetail.scopes() : Set.of();
        Set optionalScopes = optionalDetail != null && optionalDetail.scopes() != null ? optionalDetail.scopes() : Set.of();
        HashSet allowedScopes = new HashSet(requiredScopes);
        allowedScopes.addAll(optionalScopes);
        if (!consentedScopes.containsAll(requiredScopes)) {
            throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.consent.required.scopes"));
        }
        if (!allowedScopes.containsAll(consentedScopes)) {
            throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.consent.extra.scopes"));
        }
    }

    private void validateDataExportEntitlementsConsent(CloudProductConnection connection, Set<String> consentedDataExportEntitlements) {
        DcAccessEntitlements dcEntitlements = connection.experience().dcAccessEntitlements();
        DcAccessEntitlementDetail requiredDetail = dcEntitlements != null ? dcEntitlements.required() : null;
        DcAccessEntitlementDetail optionalDetail = dcEntitlements != null ? dcEntitlements.optional() : null;
        Set requiredEntitlements = requiredDetail != null && requiredDetail.dataExportEntitlements() != null ? requiredDetail.dataExportEntitlements() : Set.of();
        Set optionalEntitlements = optionalDetail != null && optionalDetail.dataExportEntitlements() != null ? optionalDetail.dataExportEntitlements() : Set.of();
        HashSet allowedEntitlements = new HashSet(requiredEntitlements);
        allowedEntitlements.addAll(optionalEntitlements);
        Set availableEntitlementKeys = this.dataExportEntitlementService.getAllDataExportEntitlements().stream().map(entitlement -> entitlement.key()).collect(Collectors.toSet());
        if (!availableEntitlementKeys.containsAll(consentedDataExportEntitlements)) {
            throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.consent.unknown.entitlements"));
        }
        if (!consentedDataExportEntitlements.containsAll(requiredEntitlements)) {
            throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.consent.required.entitlements"));
        }
        if (!allowedEntitlements.containsAll(consentedDataExportEntitlements)) {
            throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.consent.extra.entitlements"));
        }
    }

    public CloudProductConnection getCloudProductConnection(String connectionId) {
        CloudProductConnection cloudProductConnection = this.cloudProductConnectionService.getConnectionRequest(connectionId);
        if (cloudProductConnection == null) {
            throw new IllegalArgumentException("Cloud product connection not found for cloudProductConnectionId: " + connectionId);
        }
        return cloudProductConnection;
    }

    public ApplicationLink createCloudProductConnectionApplicationLink(@Nonnull CloudProductConnection cloudProductConnection, @Nonnull CloudProductConnectionAcceptRequest request) throws TypeNotInstalledException {
        String redirectURL;
        ApplicationLink applicationLink = this.findApplicationLinkByConnectionId(cloudProductConnection.id());
        this.checkDuplicateApplink(applicationLink, cloudProductConnection.id(), cloudProductConnection.applicationId());
        if (applicationLink == null) {
            applicationLink = this.createCloudProductApplinkInternal(cloudProductConnection, request);
            redirectURL = this.getRedirectURL(applicationLink);
        } else if (cloudProductConnection.status() == CloudProductConnectionStatus.CREATED) {
            this.registerOutgoingAuthenticationProviders(applicationLink);
            redirectURL = this.getRedirectURL(applicationLink);
        } else {
            throw new IllegalStateException("Applink already exist for connection Id: " + cloudProductConnection.id());
        }
        this.sendAppLinkInstalledAcknowledgment(cloudProductConnection.id(), null, redirectURL);
        this.uniconnAuditPublisherService.publishCloudProductConnectionAccepted(cloudProductConnection);
        return applicationLink;
    }

    private void checkDuplicateApplink(ApplicationLink existingApplinkWithProductConnectionId, String cloudProductConnectionId, String cloudProductConnectionApplicationId) throws TypeNotInstalledException {
        if (existingApplinkWithProductConnectionId != null && !existingApplinkWithProductConnectionId.getId().get().equals(cloudProductConnectionApplicationId)) {
            LOG.error("Applink {} already exists for this product connection request with id : {}", (Object)existingApplinkWithProductConnectionId.getId(), (Object)cloudProductConnectionId);
            throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.duplicate.connection", new Serializable[]{existingApplinkWithProductConnectionId.getName()}));
        }
        MutableApplicationLink existingApplinkWithApplicationId = this.applicationLinkService.getApplicationLink(new ApplicationId(cloudProductConnectionApplicationId));
        if (existingApplinkWithApplicationId != null && !cloudProductConnectionId.equals(UniconnApplinkUtils.getCloudProductConnectionId((ApplicationLink)existingApplinkWithApplicationId))) {
            LOG.error("Applink {} already exists for this application id : {}", (Object)existingApplinkWithApplicationId.getId(), (Object)cloudProductConnectionApplicationId);
            throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.duplicate.application", new Serializable[]{existingApplinkWithApplicationId.getName()}));
        }
    }

    private MutableApplicationLink createCloudProductApplinkInternal(@Nonnull CloudProductConnection cloudProductConnection, @Nonnull CloudProductConnectionAcceptRequest request) {
        return (MutableApplicationLink)this.transactionTemplate.execute(() -> {
            boolean hasCloudScopes;
            ApplicationId applicationId = new ApplicationId(cloudProductConnection.applicationId());
            Set<String> dcScopes = UniconnApplinkUtils.getRequiredDcScopes(cloudProductConnection.experience());
            Set<String> cloudScopes = cloudProductConnection.experience().cloudScopes();
            boolean hasDcScopes = !dcScopes.isEmpty();
            boolean bl = hasCloudScopes = !cloudScopes.isEmpty();
            if (!hasDcScopes && !hasCloudScopes) {
                throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.consent.empty.scopes"));
            }
            Set<String> consentedScopes = this.getConsentedScopes(request);
            Set<String> consentedDataExportEntitlements = this.getConsentedDataExportEntitlements(request);
            this.validateConsent(cloudProductConnection, consentedScopes, consentedDataExportEntitlements);
            MutableApplicationLink applicationLink = null;
            ApplinkExchangedClientsDetails exchangedClientsDetails = null;
            Client incomingClient = null;
            try {
                if (hasDcScopes) {
                    incomingClient = this.createIncomingClient(cloudProductConnection, consentedScopes);
                }
                exchangedClientsDetails = this.exchangeCredentialsAndCreateOutgoingClients(incomingClient, hasCloudScopes, cloudProductConnection);
                applicationLink = this.createApplicationLinkForProductConnection(cloudProductConnection, exchangedClientsDetails, applicationId, consentedScopes, consentedDataExportEntitlements);
                this.registerOutgoingAuthenticationProviders((ApplicationLink)applicationLink);
                return applicationLink;
            }
            catch (Exception e) {
                LOG.error("Failed to create uniconn application link", (Throwable)e);
                this.cleanUpCreatedClients(applicationLink, incomingClient != null ? incomingClient.getId() : null, exchangedClientsDetails);
                throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.application.link.creation.failed"), e);
            }
        });
    }

    private ApplinkExchangedClientsDetails exchangeCredentialsAndCreateOutgoingClients(Client incomingClient, boolean hasCloudScopes, CloudProductConnection cloudProductConnection) throws ServiceException, ResponseException {
        List<OAuthClientDetails> outgoingClientDetails = this.exchangeCredentials(incomingClient, cloudProductConnection);
        String clientCredentialsClientId = null;
        String authorizationCodeClientId = null;
        if (hasCloudScopes) {
            if (outgoingClientDetails.isEmpty()) {
                LOG.error("No outgoing credentials received in exchange for cloud product connection : {}", (Object)cloudProductConnection.id());
                throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.application.link.creation.failed"));
            }
            clientCredentialsClientId = this.createOutgoingClientFromFirstOfType(cloudProductConnection, outgoingClientDetails, OAuth2GrantType.CLIENT_CREDENTIALS_GRANT).map(ClientConfigurationEntity::getId).orElse(null);
            authorizationCodeClientId = this.createOutgoingClientFromFirstOfType(cloudProductConnection, outgoingClientDetails, OAuth2GrantType.AUTHORIZATION_CODE_GRANT).map(ClientConfigurationEntity::getId).orElse(null);
        }
        ApplinkExchangedClientsDetails result = new ApplinkExchangedClientsDetails(incomingClient != null ? incomingClient.getId() : null, authorizationCodeClientId, clientCredentialsClientId);
        return result;
    }

    private MutableApplicationLink createApplicationLinkForProductConnection(CloudProductConnection cloudProductConnection, ApplinkExchangedClientsDetails exchangedClientsDetails, ApplicationId applicationId, Set<String> consentedScopes, Set<String> consentedDataExportEntitlements) {
        ApplicationLinkDetails applicationLinkDetails = ApplicationLinkDetails.builder().name(cloudProductConnection.name()).rpcUrl(URI.create(cloudProductConnection.rpcUrl())).displayUrl(URI.create(cloudProductConnection.displayUrl())).clientId(exchangedClientsDetails.incomingClientId).clientCredentialsClientConfigurationId(exchangedClientsDetails.clientCredentialsClientId).authorizationCodeClientConfigurationId(exchangedClientsDetails.authorizationCodeClientId).isCloud(true).build();
        ApplicationLinkProperties applicationLinkProperties = this.propertyService.getApplicationLinkProperties(applicationId);
        applicationLinkProperties.setSystem(true);
        applicationLinkProperties.putProperty(UniconnApplinkProperties.UNICONN.key(), String.valueOf(true));
        applicationLinkProperties.putProperty(UniconnApplinkProperties.CLOUD_PRODUCT_TYPE_ID.key(), cloudProductConnection.productTypeId());
        applicationLinkProperties.putProperty(UniconnApplinkProperties.CLOUD_PRODUCT_CONNECTION_ID.key(), cloudProductConnection.id());
        applicationLinkProperties.putProperty(UniconnApplinkProperties.CLOUD_PRODUCT_ICON_ID.key(), cloudProductConnection.iconId());
        applicationLinkProperties.putProperty(UniconnApplinkProperties.CLOUD_PRODUCT_NAME.key(), cloudProductConnection.name());
        if (cloudProductConnection.cloudContainerName() != null) {
            applicationLinkProperties.putProperty(UniconnApplinkProperties.CLOUD_PRODUCT_CONTAINER_NAME.key(), cloudProductConnection.cloudContainerName());
        }
        if (exchangedClientsDetails.incomingClientId != null) {
            applicationLinkProperties.setClientId(exchangedClientsDetails.incomingClientId);
        }
        applicationLinkProperties.setAuthorizationCodeClientConfigurationId(exchangedClientsDetails.authorizationCodeClientId);
        applicationLinkProperties.setClientCredentialsClientConfigurationId(exchangedClientsDetails.clientCredentialsClientId);
        applicationLinkProperties.setIsCloud(true);
        if (!consentedScopes.isEmpty()) {
            ArrayList<String> scopesList = new ArrayList<String>(consentedScopes);
            Collections.sort(scopesList);
            applicationLinkProperties.putProperty(UniconnApplinkProperties.INCOMING_SCOPES.key(), scopesList);
        }
        if (!consentedDataExportEntitlements.isEmpty()) {
            ArrayList<String> entitlementsList = new ArrayList<String>(consentedDataExportEntitlements);
            Collections.sort(entitlementsList);
            applicationLinkProperties.putProperty(UniconnApplinkProperties.DATA_EXPORT_ENTITLEMENTS.key(), entitlementsList);
        }
        UniconnApplinkUtils.setCloudProductConnectionCustomProperties(applicationLinkProperties, cloudProductConnection.customProperties());
        return this.applicationLinkService.addApplicationLink(applicationId, cloudProductConnection.applicationType(), applicationLinkDetails);
    }

    public void rotateCloudProductConnectionApplicationLinkCredentials(@Nonnull CloudProductConnection cloudProductConnection) throws IllegalStateException, ServiceException, TypeNotInstalledException, ResponseException {
        ApplicationId applicationId = new ApplicationId(cloudProductConnection.applicationId());
        MutableApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(applicationId);
        Set<String> dcScopes = UniconnApplinkUtils.getRequiredDcScopes(cloudProductConnection.experience());
        Set<String> cloudScopes = cloudProductConnection.experience().cloudScopes();
        boolean hasDcScopes = !dcScopes.isEmpty();
        boolean hasCloudScopes = !cloudScopes.isEmpty();
        Client incomingClient = null;
        if (hasDcScopes) {
            incomingClient = this.rotateIncomingDcClient(applicationLink, cloudProductConnection);
        }
        List<OAuthClientDetails> outgoingClientDetails = this.exchangeCredentials(incomingClient, cloudProductConnection);
        if (hasCloudScopes) {
            this.updateOutgoingClientsForCloudScopes(applicationLink, cloudProductConnection, outgoingClientDetails);
        }
        if (hasDcScopes) {
            this.internalClientService.revokeRotatedClientSecret(incomingClient.getId());
        }
        this.sendAppLinkInstalledAcknowledgment(cloudProductConnection.id(), cloudProductConnection.credentialRotation().id(), null);
        if (hasDcScopes && incomingClient != null) {
            applicationLink.removeProperty(UniconnApplinkProperties.CURRENT_ROTATION_ID.key());
        }
        this.uniconnAuditPublisherService.publishCloudProductConnectionCredentialsRotated(cloudProductConnection);
    }

    private Client rotateIncomingDcClient(MutableApplicationLink applicationLink, CloudProductConnection cloudProductConnection) {
        boolean shouldRotate;
        Client incomingClient;
        String clientId = applicationLink.getClientId();
        if (clientId == null) {
            throw new IllegalStateException("DC client ID is not set for cloud product connection having DC scopes with id: " + cloudProductConnection.id());
        }
        Optional clientOptional = this.internalClientService.getById(clientId);
        if (clientOptional.isEmpty()) {
            throw new IllegalStateException("DC client not found for cloud product connection having DC scopes with id: " + cloudProductConnection.id());
        }
        Client clientToRotate = incomingClient = (Client)clientOptional.get();
        String existingRotationId = (String)applicationLink.getProperty(UniconnApplinkProperties.CURRENT_ROTATION_ID.key());
        String newRotationId = cloudProductConnection.credentialRotation().id();
        boolean areCredentialsRevoked = UniconnApplinkUtils.areCredentialsRevoked((ApplicationLink)applicationLink);
        boolean bl = shouldRotate = existingRotationId == null || !existingRotationId.equals(newRotationId) || areCredentialsRevoked;
        if (shouldRotate) {
            LOG.debug("Encountered new rotation ID or revoked credentials, rotating DC credentials for cloud product connection with id: {}", (Object)cloudProductConnection.id());
            Optional rotatedClient = (Optional)this.transactionTemplate.execute(() -> {
                Optional newClient = this.internalClientService.rotateClient(clientToRotate.getClientId());
                if (areCredentialsRevoked) {
                    applicationLink.removeProperty(UniconnApplinkProperties.PRODUCT_CREDENTIALS_REVOKED.key());
                }
                applicationLink.putProperty(UniconnApplinkProperties.CURRENT_ROTATION_ID.key(), (Object)newRotationId);
                return newClient;
            });
            if (rotatedClient.isEmpty()) {
                throw new IllegalStateException("Failed to rotate DC client for cloud product connection with id: " + cloudProductConnection.id());
            }
            incomingClient = (Client)rotatedClient.get();
        } else {
            LOG.debug("Same rotation ID already exists, not rotating DC credentials for cloud product connection with id: {}", (Object)cloudProductConnection.id());
        }
        return incomingClient;
    }

    private void updateOutgoingClientsForCloudScopes(MutableApplicationLink applicationLink, CloudProductConnection cloudProductConnection, List<OAuthClientDetails> outgoingClientDetails) {
        if (outgoingClientDetails.isEmpty()) {
            throw new IllegalStateException("No outgoing clients found in exchange credentials response for cloud product connection having cloud scopes with id: " + cloudProductConnection.id());
        }
        String clientCredentialsClientId = applicationLink.getClientCredentialsClientConfigurationId();
        String authorizationCodeClientId = applicationLink.getAuthorizationCodeClientConfigurationId();
        ApplicationLinkProperties applinkProperties = this.propertyService.getApplicationLinkProperties(applicationLink.getId());
        this.ensureOutgoingClientForGrant(clientCredentialsClientId, applicationLink, cloudProductConnection, outgoingClientDetails, OAuth2GrantType.CLIENT_CREDENTIALS_GRANT, applinkProperties::setClientCredentialsClientConfigurationId, TwoLeggedOAuth2AuthenticationProvider.class);
        this.ensureOutgoingClientForGrant(authorizationCodeClientId, applicationLink, cloudProductConnection, outgoingClientDetails, OAuth2GrantType.AUTHORIZATION_CODE_GRANT, applinkProperties::setAuthorizationCodeClientConfigurationId, ThreeLeggedOAuth2AuthenticationProvider.class);
    }

    private void cleanUpCreatedClients(@Nullable MutableApplicationLink applicationLink, @Nullable String incomingClientId, @Nullable ApplinkExchangedClientsDetails createdClients) {
        if (applicationLink != null) {
            try {
                this.applicationLinkService.deleteApplicationLink((ApplicationLink)applicationLink);
            }
            catch (Exception ex) {
                LOG.error("Failed to delete application link during clean up", (Throwable)ex);
            }
        }
        if (incomingClientId != null) {
            try {
                this.clientService.removeById(incomingClientId);
            }
            catch (Exception ex) {
                LOG.error("Failed to delete incoming client during clean up", (Throwable)ex);
            }
        }
        if (createdClients != null && createdClients.authorizationCodeClientId != null) {
            try {
                this.clientConfigStorageService.delete(createdClients.authorizationCodeClientId);
            }
            catch (Exception ex) {
                LOG.error("Failed to delete outgoing Authorization Code client during cleanup", (Throwable)ex);
            }
        }
        if (createdClients != null && createdClients.clientCredentialsClientId != null) {
            try {
                this.clientConfigStorageService.delete(createdClients.clientCredentialsClientId);
            }
            catch (Exception ex) {
                LOG.error("Failed to delete outgoing Client Credentials client during cleanup", (Throwable)ex);
            }
        }
    }

    private void registerOutgoingAuthenticationProviders(ApplicationLink applicationLink) {
        try {
            boolean isClientCredentialsSupported;
            boolean isAuthorizationCodeSupported;
            boolean bl = isAuthorizationCodeSupported = !StringUtils.isEmpty((CharSequence)applicationLink.getAuthorizationCodeClientConfigurationId());
            if (isAuthorizationCodeSupported) {
                this.registerAuthenticationProvider(applicationLink, ThreeLeggedOAuth2AuthenticationProvider.class);
            }
            boolean bl2 = isClientCredentialsSupported = !StringUtils.isEmpty((CharSequence)applicationLink.getClientCredentialsClientConfigurationId());
            if (isClientCredentialsSupported) {
                this.registerAuthenticationProvider(applicationLink, TwoLeggedOAuth2AuthenticationProvider.class);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to register outgoing authentication providers. Cleaning up applink and associated clients", (Throwable)e);
            throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.application.link.creation.failed"), e);
        }
    }

    private void registerAuthenticationProvider(ApplicationLink applicationLink, Class<? extends AuthenticationProvider> providerClass) {
        if (!this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), providerClass)) {
            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), providerClass, Collections.emptyMap());
        }
    }

    private void unregisterAuthenticationProvider(ApplicationLink applicationLink, Class<? extends AuthenticationProvider> providerClass) {
        if (this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), providerClass)) {
            this.authenticationConfigurationManager.unregisterProvider(applicationLink.getId(), providerClass);
        }
    }

    private Client createIncomingClient(CloudProductConnection cloudProductConnection, Set<String> consentedScopes) throws ServiceException {
        Set<String> requestedScopes = consentedScopes != null ? consentedScopes : Set.of();
        String requestedScopesStr = String.join((CharSequence)" ", requestedScopes.stream().toList());
        this.validateLocalScopes(requestedScopes, requestedScopesStr);
        List<String> dcAuthCodeRedirectUrls = cloudProductConnection.dcAuthCodeRedirectUrls();
        for (String redirectUrl : dcAuthCodeRedirectUrls) {
            this.validateUri(redirectUrl, "redirectUrl");
        }
        String clientName = String.format("UC Client %s-%s", cloudProductConnection.name(), cloudProductConnection.id());
        CreateClientEntity newClientEntity = new CreateClientEntity(clientName, this.scopeResolver.getScope(requestedScopesStr), dcAuthCodeRedirectUrls, GrantType.CLIENT_DEFAULT_GRANT_TYPES, null);
        return this.clientService.create(newClientEntity);
    }

    private List<OAuthClientDetails> exchangeCredentials(Client client, CloudProductConnection cloudProductConnection) throws ResponseException {
        SrsExchangeOauthCredentialsResponse response = this.srsClient.exchangeOauthCredentials(client, cloudProductConnection);
        return this.srsExchangeOauthCredentialsResponseMapper.fromDto(response);
    }

    @Nonnull
    private ClientConfigurationEntity createOrUpdateOutgoingClient(String outgoingClientId, CloudProductConnection cloudProductConnection, OAuthClientDetails clientDetails) throws ServiceException {
        String clientId = clientDetails.clientId();
        String clientSecret = clientDetails.clientSecret();
        Set<String> scopes = clientDetails.scopes();
        String name = String.format("UC %s-%s (%s)", cloudProductConnection.name(), cloudProductConnection.id(), clientDetails.grantType().name().toLowerCase());
        this.validateStringLength(name, "name");
        this.validateStringNotBlank(clientId, "clientId");
        this.validateStringNotBlank(clientSecret, "clientSecret");
        this.validateStringLength(clientId, "clientId");
        this.validateStringLength(clientSecret, "clientSecret");
        if (scopes == null || scopes.isEmpty()) {
            throw this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{"Scopes"});
        }
        for (String scope : scopes) {
            if (scope.contains(" ")) {
                this.serviceExceptionFactory.raise(InvalidValueException.class, I18nKey.newI18nKey("applinks.service.error.invalidvalue.no.space", new Serializable[0]));
            }
            this.validateStringLength(scope, "scope");
        }
        this.validateUri(clientDetails.authorizationEndpoint(), "authorizationEndpoint");
        this.validateUri(clientDetails.tokenEndpoint(), "tokenEndpoint");
        GrantType grantType = switch (clientDetails.grantType()) {
            default -> throw new MatchException(null, null);
            case OAuth2GrantType.AUTHORIZATION_CODE_GRANT -> GrantType.AUTHORIZATION_CODE_GRANT;
            case OAuth2GrantType.CLIENT_CREDENTIALS_GRANT -> GrantType.CLIENT_CREDENTIALS_GRANT;
        };
        ClientConfigurationEntity clientConfigEntity = ClientConfigurationEntity.builder().id(outgoingClientId).name(name).grantType(grantType).providerType(ProviderType.GENERIC).clientId(clientId).clientSecret(clientSecret).authorizationEndpoint(clientDetails.authorizationEndpoint()).tokenEndpoint(clientDetails.tokenEndpoint()).scopes(new ArrayList<String>(scopes)).customParams(clientDetails.customParams()).build();
        try {
            return this.clientConfigStorageService.save(clientConfigEntity);
        }
        catch (ConfigurationNotFoundException e) {
            throw new IllegalStateException("Failed to create client configuration", e);
        }
    }

    private Optional<ClientConfigurationEntity> createOutgoingClientFromFirstOfType(CloudProductConnection cloudProductConnection, List<OAuthClientDetails> outgoingClientDetails, OAuth2GrantType grantType) throws ServiceException {
        return this.createOrUpdateOutgoingClientFromFirstOfType(null, cloudProductConnection, outgoingClientDetails, grantType);
    }

    private Optional<OAuthClientDetails> getFirstOutgoingClientOfType(List<OAuthClientDetails> outgoingClientDetails, OAuth2GrantType grantType) {
        return outgoingClientDetails.stream().filter(details -> details.grantType().equals((Object)grantType)).findFirst();
    }

    private Optional<ClientConfigurationEntity> createOrUpdateOutgoingClientFromFirstOfType(String outgoingClientId, CloudProductConnection cloudProductConnection, List<OAuthClientDetails> outgoingClientDetails, OAuth2GrantType grantType) throws ServiceException {
        Optional<OAuthClientDetails> clientDetails = this.getFirstOutgoingClientOfType(outgoingClientDetails, grantType);
        Optional<ClientConfigurationEntity> clientCredentialsClientEntity = Optional.empty();
        if (clientDetails.isPresent()) {
            clientCredentialsClientEntity = Optional.of(this.createOrUpdateOutgoingClient(outgoingClientId, cloudProductConnection, clientDetails.get()));
        }
        return clientCredentialsClientEntity;
    }

    private void ensureOutgoingClientForGrant(String existingClientConfigurationId, MutableApplicationLink applicationLink, CloudProductConnection cloudProductConnection, List<OAuthClientDetails> outgoingClientDetails, OAuth2GrantType grantType, Consumer<String> setConfigurationId, Class<? extends AuthenticationProvider> providerClass) {
        this.transactionTemplate.execute(() -> {
            try {
                if (existingClientConfigurationId == null) {
                    String newClientId = this.createOutgoingClientFromFirstOfType(cloudProductConnection, outgoingClientDetails, grantType).map(ClientConfigurationEntity::getId).orElse(null);
                    if (newClientId == null) {
                        throw new IllegalStateException("Failed to create outgoing client for cloud product connection having cloud scopes with id: " + cloudProductConnection.id());
                    }
                    setConfigurationId.accept(newClientId);
                    this.registerAuthenticationProvider((ApplicationLink)applicationLink, providerClass);
                } else {
                    this.createOrUpdateOutgoingClientFromFirstOfType(existingClientConfigurationId, cloudProductConnection, outgoingClientDetails, grantType);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to update outgoing client for cloud product connection", e);
            }
            return null;
        });
    }

    private void validateUri(String uriString, String name) throws InvalidValueException, InvalidEmptyValueException {
        if (StringUtils.isBlank((CharSequence)uriString)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{name});
        }
        this.validateStringLength(uriString, name);
        try {
            URI.create(uriString);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.serviceExceptionFactory.raise(InvalidValueException.class, new Serializable[]{name, "valid URL", uriString});
        }
    }

    private void validateLocalScopes(Set<String> requestedScopes, String scopeName) throws ServiceException {
        if (requestedScopes.stream().anyMatch(scope -> scope.contains(" "))) {
            this.serviceExceptionFactory.raise(InvalidValueException.class, I18nKey.newI18nKey("applinks.service.error.invalidvalue.no.space", new Serializable[0]));
        }
        this.validateStringLength(scopeName, "scopeName");
        try {
            this.scopeResolver.getScope(scopeName);
        }
        catch (InvalidScopeException e) {
            throw new ClientConfigurationScopesNotFoundException("Scopes not found", e);
        }
    }

    private void validateStringLength(String string, String name) throws InvalidValueException {
        if (string.length() >= 450) {
            this.serviceExceptionFactory.raise(InvalidValueException.class, I18nKey.newI18nKey("applinks.service.error.invalidvalue.toolong", new Serializable[]{name}));
        }
    }

    private void validateStringNotBlank(String string, String name) throws InvalidEmptyValueException {
        if (StringUtils.isBlank((CharSequence)string)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{name});
        }
    }

    public void deleteCloudProductConnectionApplicationLink(String connectionId) {
        LOG.debug("Starting deletion process for cloud product connection: {}", (Object)connectionId);
        ApplicationLink applicationLink = this.findApplicationLinkByConnectionId(connectionId);
        this.deleteApplinkLocally(connectionId);
        try {
            this.deleteCloudConnection(connectionId);
        }
        catch (Exception e) {
            LOG.error("Failed to delete cloud product connection from SRS for connection id: {} - {} ", (Object)connectionId, (Object)e);
        }
        this.uniconnAuditPublisherService.publishCloudProductConnectionDeletion(connectionId, applicationLink);
    }

    public void deleteCloudConnection(String connectionId) {
        CloudProductConnection connection = this.cloudProductConnectionService.getConnection(connectionId);
        if (connection.status() != CloudProductConnectionStatus.CONNECTED) {
            LOG.debug("Cloud product connection {} is not in CONNECTED state. Current state: {}", (Object)connectionId, (Object)connection.status());
            throw new CloudProductConnectionException("Connection must be in CONNECTED state to be deleted. Current state: " + String.valueOf((Object)connection.status()));
        }
        try {
            LOG.debug("Deleting connection from SRS: {}", (Object)connectionId);
            this.srsClient.deleteConnection(connectionId);
            LOG.debug("Successfully deleted connection from SRS: {}", (Object)connectionId);
            LOG.debug("Successfully completed normal deletion of cloud product connection: {}", (Object)connectionId);
        }
        catch (SrsResponseException | ResponseException e) {
            LOG.error("Failed to delete connection from SRS: {}", (Object)connectionId, (Object)e);
            throw new SrsResponseException("Failed to delete connection : " + connectionId, e);
        }
    }

    public void deleteApplinkLocally(String connectionId) {
        ApplicationLink applicationLink = this.findApplicationLinkByConnectionId(connectionId);
        if (applicationLink != null) {
            LOG.debug("Found local application link, removing it: {}", (Object)applicationLink.getId());
            this.deleteApplicationLinkSafely(applicationLink, connectionId);
            LOG.debug("Successfully removed local application link for connection: {}", (Object)connectionId);
        } else {
            LOG.error("No local application link found for connection: {} ", (Object)connectionId);
            this.throwCloudProductConnectionNotFoundException(connectionId);
        }
    }

    public ApplicationLink findApplicationLinkByConnectionId(String connectionId) {
        LOG.debug("Searching for application link with connection ID property: {}", (Object)connectionId);
        return StreamSupport.stream(this.applicationLinkService.getApplicationLinks().spliterator(), false).filter(UniconnApplinkUtils::isUniconnApplink).filter(link -> connectionId.equals(UniconnApplinkUtils.getCloudProductConnectionId(link))).findFirst().orElse(null);
    }

    private void deleteApplicationLinkSafely(ApplicationLink applicationLink, String connectionId) {
        try {
            LOG.debug("Deleting local application link: {}", (Object)applicationLink.getId());
            this.applicationLinkService.deleteApplicationLink(applicationLink);
            LOG.debug("Successfully deleted local application link: {}", (Object)applicationLink.getId());
        }
        catch (Exception e) {
            LOG.error("Failed to delete application link for connection: {}", (Object)connectionId, (Object)e);
            throw new CloudProductConnectionException(this.i18nResolver.getText("applinks.error.uniconn.application.link.deletion.failed"));
        }
    }

    private void sendAppLinkInstalledAcknowledgment(String connectionId, String rotationId, String redirectURL) {
        try {
            this.srsClient.acknowledgeAppLinkInstalled(connectionId, rotationId, redirectURL);
        }
        catch (SrsResponseException | ResponseException e) {
            LOG.error("Failed to send app link installed acknowledgment to SRS for connection: {}", (Object)connectionId, (Object)e);
            throw new SrsResponseException(this.i18nResolver.getText("applinks.error.uniconn.application.link.acknowledgement.failed"));
        }
    }

    public CloudProductConnectionConsentDto editConsentForProductConnection(@Nonnull CloudProductConnection cloudProductConnection, @Nonnull CloudProductConnectionConsentDto consentDto) {
        ApplicationLink applicationLink = this.findApplicationLinkByConnectionId(cloudProductConnection.id());
        if (applicationLink == null) {
            this.throwCloudProductConnectionNotFoundException(cloudProductConnection.id());
        }
        Set<String> consentedDataExportEntitlements = this.getConsentedDataExportEntitlements(consentDto);
        this.validateDataExportEntitlementsConsent(cloudProductConnection, consentedDataExportEntitlements);
        this.updateDataExportEntitlementsProperty(applicationLink, consentedDataExportEntitlements);
        Set<String> scopesForAudit = this.getConsentedScopes(consentDto);
        this.uniconnAuditPublisherService.publishCloudProductConnectionConsentUpdated(cloudProductConnection, scopesForAudit, consentedDataExportEntitlements);
        return this.extractConsentFromApplink(applicationLink);
    }

    public void revokeProductConnectionCredentials(String productConnectionId) {
        ApplicationLink applicationLink = this.findApplicationLinkByConnectionId(productConnectionId);
        if (applicationLink == null) {
            this.throwCloudProductConnectionNotFoundException(productConnectionId);
        }
        if (UniconnApplinkUtils.areCredentialsRevoked(applicationLink)) {
            throw new ProductConnectionCredentialsNotFoundException(this.i18nResolver.getText("applinks.error.uniconn.credentials.notfound"));
        }
        this.transactionTemplate.execute(() -> {
            PropertySet applinkAdminProperties = this.propertyService.getAdminProperties(applicationLink.getId());
            if (applicationLink.getClientId() != null) {
                String clientId = applicationLink.getClientId();
                LOG.debug("Revoking incoming client for product connection: {}", (Object)productConnectionId);
                Optional client = this.clientService.getById(clientId);
                if (client.isPresent()) {
                    this.clientService.rotateClient(((Client)client.get()).getClientId());
                    this.clientService.revokeRotatedClientSecret(clientId);
                }
                applicationLink.putProperty(UniconnApplinkProperties.PRODUCT_CREDENTIALS_REVOKED.key(), (Object)String.valueOf(true));
            }
            if (applicationLink.getAuthorizationCodeClientConfigurationId() != null) {
                LOG.debug("Revoking outgoing authorization code client for product connection: {}", (Object)productConnectionId);
                this.unregisterAuthenticationProvider(applicationLink, ThreeLeggedOAuth2AuthenticationProvider.class);
                this.removeOutgoingClientConfiguration(applicationLink.getAuthorizationCodeClientConfigurationId());
                applinkAdminProperties.removeProperty(ApplicationLinkProperties.Property.AUTHORIZATION_CODE_CLIENT_CONFIGURATION_ENTITY_ID.key());
            }
            if (applicationLink.getClientCredentialsClientConfigurationId() != null) {
                LOG.debug("Revoking outgoing client credentials client for product connection: {}", (Object)productConnectionId);
                this.unregisterAuthenticationProvider(applicationLink, TwoLeggedOAuth2AuthenticationProvider.class);
                this.removeOutgoingClientConfiguration(applicationLink.getClientCredentialsClientConfigurationId());
                applinkAdminProperties.removeProperty(ApplicationLinkProperties.Property.CLIENT_CREDENTIALS_CLIENT_CONFIGURATION_ENTITY_ID.key());
            }
            return null;
        });
        if (applicationLink != null) {
            this.uniconnAuditPublisherService.publishCloudProductConnectionCredentialsRevoked(productConnectionId, applicationLink);
        }
    }

    private void removeOutgoingClientConfiguration(String clientConfigurationId) {
        try {
            this.clientConfigStorageService.delete(clientConfigurationId);
        }
        catch (ConfigurationNotFoundException e) {
            LOG.error("Outgoing client configuration not found with id  : {}", (Object)clientConfigurationId);
        }
    }

    private Set<String> getConsentedScopes(CloudProductConnectionConsentDto consentDto) {
        if (consentDto == null || consentDto.dcAccessEntitlements() == null) {
            return Set.of();
        }
        CloudProductConnectionConsentAccessEntitlementsDto dto = consentDto.dcAccessEntitlements();
        return dto.scopes() != null ? dto.scopes() : Set.of();
    }

    private Set<String> getConsentedDataExportEntitlements(CloudProductConnectionConsentDto consentDto) {
        if (consentDto == null || consentDto.dcAccessEntitlements() == null) {
            return Set.of();
        }
        CloudProductConnectionConsentAccessEntitlementsDto dto = consentDto.dcAccessEntitlements();
        return dto.dataExportEntitlements() != null ? dto.dataExportEntitlements() : Set.of();
    }

    private void updateDataExportEntitlementsProperty(ApplicationLink applicationLink, Set<String> consentedDataExportEntitlements) {
        ApplicationLinkProperties applicationLinkProperties = this.propertyService.getApplicationLinkProperties(applicationLink.getId());
        ArrayList<String> entitlementsList = new ArrayList<String>(consentedDataExportEntitlements);
        Collections.sort(entitlementsList);
        applicationLinkProperties.putProperty(UniconnApplinkProperties.DATA_EXPORT_ENTITLEMENTS.key(), entitlementsList);
    }

    private CloudProductConnectionConsentDto extractConsentFromApplink(ApplicationLink applicationLink) {
        Object scopesProperty = applicationLink.getProperty(UniconnApplinkProperties.INCOMING_SCOPES.key());
        Object entitlementsProperty = applicationLink.getProperty(UniconnApplinkProperties.DATA_EXPORT_ENTITLEMENTS.key());
        Set<String> scopes = this.extractStringSetFromProperty(scopesProperty);
        Set<String> entitlements = this.extractStringSetFromProperty(entitlementsProperty);
        return new CloudProductConnectionConsentDto(new CloudProductConnectionConsentAccessEntitlementsDto(scopes, entitlements));
    }

    private Set<String> extractStringSetFromProperty(@Nullable Object property) {
        if (property == null) {
            return Set.of();
        }
        if (property instanceof List) {
            return ((List)property).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        if (property instanceof Set) {
            return ((Set)property).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return Set.of();
    }

    private String getRedirectURL(ApplicationLink applicationLink) {
        String authorizationCodeClientConfigurationId = applicationLink.getAuthorizationCodeClientConfigurationId();
        if (authorizationCodeClientConfigurationId == null || authorizationCodeClientConfigurationId.isEmpty()) {
            return null;
        }
        Optional maybeConfig = this.clientConfigStorageService.getById(authorizationCodeClientConfigurationId);
        try {
            ClientConfigurationEntity config = (ClientConfigurationEntity)maybeConfig.get();
            return this.clientConfigStorageService.generateRedirectUrl(config.getAuthorizationEndpoint());
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("No configuration found with id " + authorizationCodeClientConfigurationId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error building Redirect Url for ApplicationLink", e);
        }
    }

    private void throwCloudProductConnectionNotFoundException(String cloudProductConnectionId) {
        LOG.error("Cloud product connection with id {} not found", (Object)cloudProductConnectionId);
        throw new CloudProductConnectionNotFoundException(this.i18nResolver.getText("applinks.error.uniconn.connection.not.found"));
    }

    private record ApplinkExchangedClientsDetails(String incomingClientId, String authorizationCodeClientId, String clientCredentialsClientId) {
    }
}

