/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientExpirationEvaluator;
import com.atlassian.oauth2.provider.api.client.internal.InternalRotationClientService;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CloudProductConnectionCredentialsExpiryResolver {
    private static final Logger LOG = LoggerFactory.getLogger(CloudProductConnectionCredentialsExpiryResolver.class);
    private final InternalRotationClientService internalClientService;
    private final ClientExpirationEvaluator clientExpirationEvaluator;

    @Autowired
    public CloudProductConnectionCredentialsExpiryResolver(InternalRotationClientService internalClientService, ClientExpirationEvaluator clientExpirationEvaluator) {
        this.internalClientService = internalClientService;
        this.clientExpirationEvaluator = clientExpirationEvaluator;
    }

    public Optional<Long> getProductConnectionExpiry(ApplicationLink applicationLink, CloudProductConnection cloudProductConnection) {
        Long finalExpiry = null;
        Optional<Long> clientExpiry = this.getClientExpiry(applicationLink.getClientId());
        Long connectionExpiry = cloudProductConnection.credentialsExpiry();
        if (clientExpiry.isPresent() && connectionExpiry != null) {
            finalExpiry = Math.min(connectionExpiry, clientExpiry.get());
        } else if (connectionExpiry != null) {
            finalExpiry = connectionExpiry;
        } else if (clientExpiry.isPresent()) {
            finalExpiry = clientExpiry.get();
        }
        return Optional.ofNullable(finalExpiry);
    }

    public Optional<Long> getClientExpiry(@Nullable String clientId) {
        if (clientId == null) {
            return Optional.empty();
        }
        try {
            Optional clientOptional = this.internalClientService.getById(clientId);
            if (clientOptional.isPresent()) {
                Client client = (Client)clientOptional.get();
                Long expiryDuration = client.getExpiryDuration() != null ? client.getExpiryDuration().toMillis() : this.clientExpirationEvaluator.getDefaultClientCredentialExpiry() * 1000L;
                return Optional.of(client.getCreatedDate() + expiryDuration);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            LOG.warn("Failed to retrieve client expiry for clientId: {}", (Object)clientId, (Object)e);
            return Optional.empty();
        }
    }
}

