/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionHeartbeatResult;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.oauth2.client.api.lib.token.TokenServiceException;
import com.atlassian.oauth2.client.api.storage.token.exception.UnrecoverableTokenException;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class CloudProductConnectionHeartbeatService {
    private static final Logger LOG = LoggerFactory.getLogger(CloudProductConnectionHeartbeatService.class);

    public CloudProductConnectionHeartbeatResult checkConnectionHeartbeat(ApplicationLink applicationLink, CloudProductConnection cloudProductConnection) {
        if (!this.isHeartbeatConfigured(cloudProductConnection)) {
            return CloudProductConnectionHeartbeatResult.NOT_AVAILABLE;
        }
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory(TwoLeggedOAuth2AuthenticationProvider.class);
        if (requestFactory == null) {
            return CloudProductConnectionHeartbeatResult.NOT_AVAILABLE;
        }
        return this.executeHeartbeatRequest(requestFactory, cloudProductConnection.heartbeatPath(), cloudProductConnection.id());
    }

    private boolean isHeartbeatConfigured(CloudProductConnection cloudProductConnection) {
        String heartbeatPath = cloudProductConnection.heartbeatPath();
        return heartbeatPath != null && !heartbeatPath.isEmpty();
    }

    private CloudProductConnectionHeartbeatResult executeHeartbeatRequest(ApplicationLinkRequestFactory requestFactory, String heartbeatPath, String connectionId) {
        try {
            return (CloudProductConnectionHeartbeatResult)((Object)requestFactory.createRequest(Request.MethodType.GET, heartbeatPath).execute((ApplicationLinkResponseHandler)new HeartbeatResponseHandler()));
        }
        catch (Exception e) {
            return this.handleRequestException(e, connectionId);
        }
    }

    private CloudProductConnectionHeartbeatResult handleRequestException(Exception e, String connectionId) {
        if (e instanceof ResponseException) {
            LOG.error("Network failure during connection health check on product connection  {} : {}", (Object)connectionId, (Object)e);
            return CloudProductConnectionHeartbeatResult.NETWORK_FAILURE;
        }
        if (e instanceof CredentialsRequiredException) {
            LOG.error("Authentication failure during connection health check on product connection {} : {}", (Object)connectionId, (Object)e);
            return CloudProductConnectionHeartbeatResult.AUTH_FAILURE;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            if (cause instanceof UnrecoverableTokenException) {
                boolean isConnectException = CloudProductConnectionHeartbeatService.isConnectExceptionNestedInTokenException((UnrecoverableTokenException)cause);
                LOG.error("Unrecoverable token error during connection health check on product connection {} : {}", (Object)connectionId, (Object)e.getMessage());
                return isConnectException ? CloudProductConnectionHeartbeatResult.NETWORK_FAILURE : CloudProductConnectionHeartbeatResult.AUTH_FAILURE;
            }
            if (cause instanceof SocketException) {
                LOG.error("Connection error during health check on product connection {} : {}", (Object)connectionId, (Object)e.getMessage());
                return CloudProductConnectionHeartbeatResult.NETWORK_FAILURE;
            }
        }
        LOG.error("Unknown error during connection health check", (Throwable)e);
        return CloudProductConnectionHeartbeatResult.UNKNOWN;
    }

    private static boolean isConnectExceptionNestedInTokenException(UnrecoverableTokenException cause) {
        return cause.getCause() != null && cause.getCause() instanceof TokenServiceException && cause.getCause().getCause() != null && cause.getCause().getCause() instanceof SocketException;
    }

    private static class HeartbeatResponseHandler
    implements ApplicationLinkResponseHandler<CloudProductConnectionHeartbeatResult> {
        private HeartbeatResponseHandler() {
        }

        public CloudProductConnectionHeartbeatResult handle(Response response) {
            return response.isSuccessful() ? CloudProductConnectionHeartbeatResult.HEALTHY : this.mapErrorResponse(response);
        }

        public CloudProductConnectionHeartbeatResult credentialsRequired(Response response) {
            return CloudProductConnectionHeartbeatResult.AUTH_FAILURE;
        }

        private CloudProductConnectionHeartbeatResult mapErrorResponse(Response response) {
            return response.getStatusCode() == HttpStatus.UNAUTHORIZED.value() ? CloudProductConnectionHeartbeatResult.AUTH_FAILURE : CloudProductConnectionHeartbeatResult.UNKNOWN;
        }
    }
}

