/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.internal.api.uniconn.BackboneApplicationType;
import com.atlassian.applinks.internal.api.uniconn.CloudProductApplicationType;
import com.atlassian.applinks.internal.application.IconUriResolver;
import com.atlassian.applinks.internal.rest.uniconn.exception.CloudProductConnectionNotFoundException;
import com.atlassian.applinks.internal.rest.uniconn.exception.SrsResponseException;
import com.atlassian.applinks.internal.uniconn.UniconnProductConnectionRetriever;
import com.atlassian.applinks.internal.uniconn.audit.UniconnAuditPublisherService;
import com.atlassian.applinks.internal.uniconn.client.srs.NoBackboneConnectionException;
import com.atlassian.applinks.internal.uniconn.client.srs.SrsClient;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionStatus;
import com.atlassian.applinks.internal.uniconn.domain.UniconnProductConnection;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.net.ResponseException;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CloudProductConnectionService {
    private static final Logger LOG = LoggerFactory.getLogger(CloudProductConnectionService.class);
    private final SrsClient srsClient;
    private final TypeAccessor typeAccessor;
    private final LocaleResolver localeResolver;
    private final MutatingApplicationLinkService applicationLinkService;
    private final UniconnAuditPublisherService uniconnAuditPublisherService;
    private final UniconnProductConnectionRetriever productConnectionRetriever;
    private final I18nResolver i18nResolver;

    @Autowired
    CloudProductConnectionService(SrsClient srsClient, TypeAccessor typeAccessor, LocaleResolver localeResolver, MutatingApplicationLinkService applicationLinkService, UniconnProductConnectionRetriever productConnectionRetriever, UniconnAuditPublisherService uniconnAuditPublisherService, I18nResolver i18nResolver) {
        this.srsClient = srsClient;
        this.typeAccessor = typeAccessor;
        this.localeResolver = localeResolver;
        this.applicationLinkService = applicationLinkService;
        this.productConnectionRetriever = productConnectionRetriever;
        this.uniconnAuditPublisherService = uniconnAuditPublisherService;
        this.i18nResolver = i18nResolver;
    }

    public List<CloudProductConnection> getCreatedConnections() {
        return this.getCreatedConnections(this.localeResolver.getLocale());
    }

    public List<CloudProductConnection> getCreatedConnections(Locale locale) {
        try {
            return this.srsClient.getConnections(locale, CloudProductConnectionStatus.CREATED).stream().toList();
        }
        catch (NoBackboneConnectionException e) {
            return Collections.emptyList();
        }
        catch (ResponseException e) {
            throw new RuntimeException("Failed to fetch connection requests", e);
        }
    }

    private List<CloudProductConnection> getConnectionsWithStatuses(CloudProductConnectionStatus ... statuses) {
        try {
            List<CloudProductConnection> result = this.srsClient.getConnections(this.localeResolver.getLocale(), statuses);
            LOG.debug("Uniconn product connections fetched from SRS with statuses {}: {}", (Object)statuses, (Object)result.size());
            return result;
        }
        catch (NoBackboneConnectionException e) {
            LOG.debug("No backbone connection; returning empty list for active uniconn product connections");
            return Collections.emptyList();
        }
        catch (ResponseException e) {
            LOG.error("Failed to fetch active uniconn product connections from SRS", (Throwable)e);
            throw new SrsResponseException("Failed to fetch product connections", e);
        }
    }

    public List<CloudProductConnection> getActiveConnections() {
        LOG.debug("Fetching active uniconn product connections from SRS");
        return this.getConnectionsWithStatuses(CloudProductConnectionStatus.CREATED, CloudProductConnectionStatus.CONNECTED);
    }

    public List<CloudProductConnection> getAllConnections() {
        LOG.debug("Fetching all uniconn product connections from SRS");
        return this.getConnectionsWithStatuses((CloudProductConnectionStatus[])Arrays.stream(CloudProductConnectionStatus.values()).filter(status -> status != CloudProductConnectionStatus.UNKNOWN).toArray(CloudProductConnectionStatus[]::new));
    }

    public CloudProductConnection getConnectionRequest(String connectionRequestId) {
        return this.getCreatedConnections().stream().filter(connection -> connection.id().equals(connectionRequestId)).findFirst().orElse(null);
    }

    public CloudProductConnection getConnectionRequestWithAppLocale(String connectionRequestId) {
        return this.getCreatedConnections(this.localeResolver.getApplicationLocale()).stream().filter(connection -> connection.id().equals(connectionRequestId)).findFirst().orElseThrow();
    }

    public CloudProductConnection getConnection(String connectionId) {
        return this.getActiveConnections().stream().filter(connection -> connection.id().equals(connectionId)).findFirst().orElse(null);
    }

    public String getApplicationName(@Nonnull CloudProductConnection cloudProductConnection) {
        return cloudProductConnection.name();
    }

    public URI getAvatarUri(@Nonnull CloudProductConnection cloudProductConnection) {
        return Optional.ofNullable(IconUriResolver.resolveIconUri(cloudProductConnection.applicationType())).orElseGet(this::getDefaultAvatarURI);
    }

    private URI getDefaultAvatarURI() {
        return Objects.requireNonNull(IconUriResolver.resolveIconUri(this.typeAccessor.getApplicationType(CloudProductApplicationType.class)));
    }

    public void rejectConnectionRequest(String cloudProductConnectionId, String reason) {
        CloudProductConnection connection = this.getConnectionRequest(cloudProductConnectionId);
        if (connection == null) {
            this.throwCloudProductConnectionNotFoundException(cloudProductConnectionId);
        }
        try {
            this.srsClient.rejectConnection(cloudProductConnectionId, reason);
            this.uniconnAuditPublisherService.publishCloudProductConnectionRejected(connection, reason);
        }
        catch (SrsResponseException | ResponseException e) {
            LOG.error("Failed to reject product connection request {} : {}", (Object)cloudProductConnectionId, (Object)e);
            throw new SrsResponseException(this.i18nResolver.getText("applinks.error.uniconn.request.rejection.failed"));
        }
    }

    public List<ApplicationLink> getAllProductUniconnApplinks() {
        return StreamSupport.stream(this.applicationLinkService.getApplicationLinks().spliterator(), false).filter(UniconnApplinkUtils::isUniconnCloudProductConnectionApplink).toList();
    }

    public List<UniconnProductConnection> getProductConnections() {
        List<CloudProductConnection> activeConnections;
        try {
            activeConnections = this.getActiveConnections();
        }
        catch (Exception e) {
            LOG.error("Failed to fetch response from SRS, entering offline mode, only uniconn applinks available locally would be returned", (Throwable)e);
            activeConnections = Collections.emptyList();
        }
        List<ApplicationLink> uniconnApplinks = this.getAllProductUniconnApplinks();
        ApplicationLink backboneApplink = this.applicationLinkService.getPrimaryApplicationLink(BackboneApplicationType.class);
        return this.productConnectionRetriever.getUniconnProductConnections(uniconnApplinks, activeConnections, backboneApplink);
    }

    private void throwCloudProductConnectionNotFoundException(String cloudProductConnectionId) {
        LOG.error("Cloud product connection with id {} not found", (Object)cloudProductConnectionId);
        throw new CloudProductConnectionNotFoundException(this.i18nResolver.getText("applinks.error.uniconn.connection.not.found"));
    }
}

