/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.internal.rest.uniconn.exception.CloudProductConnectionNotFoundException;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionApplicationLinkService;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionCredentialsExpiryResolver;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionHeartbeatResult;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionHeartbeatService;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.CredentialRotationStatus;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionStatus;
import com.atlassian.applinks.internal.uniconn.domain.Experience;
import com.atlassian.applinks.internal.uniconn.domain.UniconnProductConnectionStatus;
import com.atlassian.applinks.internal.uniconn.domain.UniconnProductConnectionStatusDetails;
import com.atlassian.applinks.internal.uniconn.domain.UniconnProductConnectionStatusMessage;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CloudProductConnectionStatusService {
    private final CloudProductConnectionApplicationLinkService applicationLinkService;
    private final I18nResolver i18nResolver;
    private final CloudProductConnectionCredentialsExpiryResolver credentialsExpiryResolver;
    private final CloudProductConnectionHeartbeatService heartbeatService;

    @Autowired
    public CloudProductConnectionStatusService(CloudProductConnectionApplicationLinkService applicationLinkService, I18nResolver i18nResolver, CloudProductConnectionCredentialsExpiryResolver credentialsExpiryResolver, CloudProductConnectionHeartbeatService heartbeatService) {
        this.applicationLinkService = Objects.requireNonNull(applicationLinkService, "applicationLinkService");
        this.i18nResolver = Objects.requireNonNull(i18nResolver, "i18nResolver");
        this.credentialsExpiryResolver = Objects.requireNonNull(credentialsExpiryResolver, "credentialsExpiryResolver");
        this.heartbeatService = Objects.requireNonNull(heartbeatService, "heartbeatService");
    }

    public UniconnProductConnectionStatusDetails getProductConnectionStatus(CloudProductConnection cloudProductConnection) {
        if (cloudProductConnection.status() == CloudProductConnectionStatus.CREATED) {
            return new UniconnProductConnectionStatusDetails(UniconnProductConnectionStatus.CREATED, null);
        }
        ApplicationLink applicationLink = this.getApplicationLinkOrThrow(cloudProductConnection);
        if (cloudProductConnection.status() != CloudProductConnectionStatus.CONNECTED) {
            return new UniconnProductConnectionStatusDetails(null, null);
        }
        return this.determineConnectionStatus(applicationLink, cloudProductConnection);
    }

    private ApplicationLink getApplicationLinkOrThrow(CloudProductConnection cloudProductConnection) {
        ApplicationLink applicationLink = this.applicationLinkService.findApplicationLinkByConnectionId(cloudProductConnection.id());
        if (applicationLink == null) {
            throw new CloudProductConnectionNotFoundException(this.i18nResolver.getText("applinks.error.uniconn.connection.not.found"));
        }
        return applicationLink;
    }

    private UniconnProductConnectionStatusDetails determineConnectionStatus(ApplicationLink applicationLink, CloudProductConnection cloudProductConnection) {
        if (UniconnApplinkUtils.areCredentialsRevoked(applicationLink)) {
            return this.createStatusDetails(UniconnProductConnectionStatus.DISABLED, UniconnProductConnectionStatusMessage.CREDENTIALS_REVOKED);
        }
        if (this.areCredentialsExpired(applicationLink, cloudProductConnection)) {
            return this.determineCredentialExpiredStatusMessage(cloudProductConnection);
        }
        CloudProductConnectionHeartbeatResult result = this.heartbeatService.checkConnectionHeartbeat(applicationLink, cloudProductConnection);
        if (result != CloudProductConnectionHeartbeatResult.HEALTHY && result != CloudProductConnectionHeartbeatResult.NOT_AVAILABLE) {
            return this.determineConnectionInterruptedMessage(result);
        }
        if (cloudProductConnection.credentialRotation() != null) {
            return this.determineCredentialRotationMessage(cloudProductConnection);
        }
        return this.createStatusDetails(UniconnProductConnectionStatus.CONNECTED, null);
    }

    private UniconnProductConnectionStatusDetails determineCredentialExpiredStatusMessage(CloudProductConnection cloudProductConnection) {
        UniconnProductConnectionStatusMessage message;
        if (cloudProductConnection.credentialRotation() != null) {
            message = switch (cloudProductConnection.credentialRotation().status()) {
                default -> throw new MatchException(null, null);
                case CredentialRotationStatus.REQUESTED, CredentialRotationStatus.CREDENTIALS_RECEIVED -> UniconnProductConnectionStatusMessage.CREDENTIALS_EXPIRED_AWAITING_ROTATION;
                case CredentialRotationStatus.ROTATION_FAILED -> UniconnProductConnectionStatusMessage.CREDENTIALS_EXPIRED_ROTATION_FAILED;
            };
        } else {
            message = UniconnProductConnectionStatusMessage.CREDENTIALS_EXPIRED_INITIATE_ROTATION;
        }
        return this.createStatusDetails(UniconnProductConnectionStatus.CREDENTIALS_EXPIRED, message);
    }

    private UniconnProductConnectionStatusDetails determineCredentialRotationMessage(CloudProductConnection cloudProductConnection) {
        UniconnProductConnectionStatusMessage message = switch (cloudProductConnection.credentialRotation().status()) {
            default -> throw new MatchException(null, null);
            case CredentialRotationStatus.REQUESTED, CredentialRotationStatus.CREDENTIALS_RECEIVED -> UniconnProductConnectionStatusMessage.CONNECTED_AWAITING_ROTATION;
            case CredentialRotationStatus.ROTATION_FAILED -> UniconnProductConnectionStatusMessage.CONNECTED_ROTATION_FAILED;
        };
        return this.createStatusDetails(UniconnProductConnectionStatus.CONNECTED, message);
    }

    private UniconnProductConnectionStatusDetails createStatusDetails(UniconnProductConnectionStatus status, UniconnProductConnectionStatusMessage message) {
        return new UniconnProductConnectionStatusDetails(status, message != null ? this.i18nResolver.getText(message.getI18nKey()) : null);
    }

    private boolean areCredentialsExpired(ApplicationLink applicationLink, CloudProductConnection cloudProductConnection) {
        Long productConnectionExpiry = this.credentialsExpiryResolver.getProductConnectionExpiry(applicationLink, cloudProductConnection).orElse(null);
        if (productConnectionExpiry == null) {
            return false;
        }
        return System.currentTimeMillis() > productConnectionExpiry;
    }

    private Set<String> extractDcScopes(Experience experience) {
        return experience.dcAccessEntitlements() != null && experience.dcAccessEntitlements().required() != null && experience.dcAccessEntitlements().required().scopes() != null ? experience.dcAccessEntitlements().required().scopes() : Set.of();
    }

    private UniconnProductConnectionStatusDetails determineConnectionInterruptedMessage(CloudProductConnectionHeartbeatResult result) {
        UniconnProductConnectionStatusMessage message = switch (result) {
            case CloudProductConnectionHeartbeatResult.AUTH_FAILURE -> UniconnProductConnectionStatusMessage.INTERRUPTED_AUTH_FAILURE;
            case CloudProductConnectionHeartbeatResult.NETWORK_FAILURE -> UniconnProductConnectionStatusMessage.INTERRUPTED_NETWORK_FAILURE;
            case CloudProductConnectionHeartbeatResult.UNKNOWN -> UniconnProductConnectionStatusMessage.INTERRUPTED_UNKNOWN;
            default -> null;
        };
        return this.createStatusDetails(UniconnProductConnectionStatus.INTERRUPTED, message);
    }
}

