/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.internal.application.IconUriResolver;
import com.atlassian.applinks.internal.uniconn.domain.HostApplicationDataExportEntitlement;
import com.atlassian.applinks.internal.uniconn.domain.HostApplicationInformation;
import com.atlassian.applinks.internal.uniconn.domain.HostApplicationMetadata;
import com.atlassian.applinks.internal.uniconn.domain.HostApplicationScopeDetails;
import com.atlassian.applinks.internal.uniconn.scopes.AvailableDataExportEntitlementsProvider;
import com.atlassian.applinks.internal.uniconn.scopes.AvailableScopesProvider;
import com.atlassian.sal.api.message.I18nResolver;
import java.net.URI;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HostApplicationMetadataService {
    private final InternalHostApplication internalHostApplication;
    private final I18nResolver i18nResolver;
    private final AvailableScopesProvider availableScopesResolver;
    private final AvailableDataExportEntitlementsProvider availableDataExportEntitlementsProvider;

    @Autowired
    public HostApplicationMetadataService(InternalHostApplication internalHostApplication, I18nResolver i18nResolver, AvailableScopesProvider availableScopesResolver, AvailableDataExportEntitlementsProvider availableDataExportEntitlementsProvider) {
        this.internalHostApplication = internalHostApplication;
        this.i18nResolver = i18nResolver;
        this.availableScopesResolver = availableScopesResolver;
        this.availableDataExportEntitlementsProvider = availableDataExportEntitlementsProvider;
    }

    public HostApplicationMetadata getHostApplicationMetadata() {
        HostApplicationInformation hostApplicationInformation = this.getHostApplicationInformation();
        List<HostApplicationScopeDetails> availableScopes = this.availableScopesResolver.getAvailableScopesDetails();
        List<HostApplicationDataExportEntitlement> availableDataExportEntitlements = this.availableDataExportEntitlementsProvider.getAvailableDataExportEntitlements();
        return new HostApplicationMetadata(hostApplicationInformation, availableScopes, availableDataExportEntitlements);
    }

    private HostApplicationInformation getHostApplicationInformation() {
        String name = this.internalHostApplication.getName();
        String productName = this.i18nResolver.getText(this.internalHostApplication.getType().getI18nKey());
        String iconUrl = this.getIconUrl();
        return new HostApplicationInformation(name, productName, iconUrl);
    }

    private String getIconUrl() {
        URI iconUri = IconUriResolver.resolveIconUri(this.internalHostApplication.getType());
        return iconUri != null ? iconUri.toString() : null;
    }
}

