/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class InstanceMetadataProvider {
    private static final String PLUGIN_KEY = "com.atlassian.applinks.applinks-plugin";
    private final LicenseHandler licenseHandler;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;

    public InstanceMetadataProvider(LicenseHandler licenseHandler, ApplicationProperties applicationProperties, PluginAccessor pluginAccessor) {
        this.licenseHandler = licenseHandler;
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public Set<String> getSens() {
        return this.licenseHandler.getAllSupportEntitlementNumbers();
    }

    @Nullable
    public String getServerId() {
        return this.licenseHandler.getServerId();
    }

    @Nonnull
    public String getProductType() {
        return this.applicationProperties.getPlatformId();
    }

    @Nonnull
    public String getProductVersion() {
        return this.applicationProperties.getVersion();
    }

    public String getPluginVersion() {
        Plugin plugin = this.pluginAccessor.getPlugin(PLUGIN_KEY);
        return plugin.getPluginInformation().getVersion();
    }
}

