/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.core.DefaultApplicationLinkService;
import com.atlassian.applinks.internal.api.uniconn.BackboneApplicationType;
import com.atlassian.applinks.internal.rest.uniconn.exception.SrsResponseException;
import com.atlassian.applinks.internal.uniconn.InstanceMetadataProvider;
import com.atlassian.applinks.internal.uniconn.client.srs.SrsClient;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsBackboneMetadataRequest;
import com.atlassian.applinks.internal.uniconn.client.srs.mapper.SrsCloudProductConnectionMetadataRequestMapper;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import java.util.List;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SrsMetadataPublisherService {
    private static final Logger LOG = LoggerFactory.getLogger(SrsMetadataPublisherService.class);
    private final DefaultApplicationLinkService applicationLinkService;
    private final SrsClient srsClient;
    private final SrsCloudProductConnectionMetadataRequestMapper srsCloudProductConnectionMetadataRequestMapper;
    private final InstanceMetadataProvider metadataProvider;

    @Autowired
    public SrsMetadataPublisherService(DefaultApplicationLinkService applicationLinkService, SrsClient srsClient, SrsCloudProductConnectionMetadataRequestMapper srsCloudProductConnectionMetadataRequestMapper, InstanceMetadataProvider metadataProvider) {
        this.applicationLinkService = applicationLinkService;
        this.srsClient = srsClient;
        this.srsCloudProductConnectionMetadataRequestMapper = srsCloudProductConnectionMetadataRequestMapper;
        this.metadataProvider = metadataProvider;
    }

    public void publishDCMetadata() throws SrsResponseException {
        this.srsClient.sendBackboneMetadata(this.buildSrsBackboneMetadataRequest());
        LOG.debug("Fetching application links for metadata publishing.");
        List<ApplicationLink> uniconnAppLinks = StreamSupport.stream(this.applicationLinkService.getApplicationLinks().spliterator(), false).filter(UniconnApplinkUtils::isUniconnApplink).filter(link -> !(link.getType() instanceof BackboneApplicationType)).toList();
        LOG.debug("Found {} application links for metadata publishing.", (Object)uniconnAppLinks.size());
        this.srsClient.sendProductConnectionsMetadata(this.srsCloudProductConnectionMetadataRequestMapper.toDto(uniconnAppLinks));
    }

    private SrsBackboneMetadataRequest buildSrsBackboneMetadataRequest() {
        return new SrsBackboneMetadataRequest(this.metadataProvider.getSens(), this.metadataProvider.getServerId(), this.metadataProvider.getProductType(), this.metadataProvider.getProductVersion(), this.metadataProvider.getPluginVersion());
    }
}

