/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn;

import com.atlassian.applinks.internal.common.exception.DefaultServiceExceptionFactory;
import com.atlassian.applinks.internal.common.exception.InvalidEmptyValueException;
import com.atlassian.applinks.internal.common.exception.InvalidValueException;
import com.atlassian.applinks.internal.common.i18n.I18nKey;
import java.io.Serializable;
import java.net.URI;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UniconnValidationService {
    private final DefaultServiceExceptionFactory serviceExceptionFactory;

    @Autowired
    public UniconnValidationService(DefaultServiceExceptionFactory serviceExceptionFactory) {
        this.serviceExceptionFactory = serviceExceptionFactory;
    }

    public void validateStringMaxLength(String string, String name) throws InvalidValueException {
        if (string.length() >= 450) {
            this.serviceExceptionFactory.raise(InvalidValueException.class, I18nKey.newI18nKey("applinks.service.error.invalidvalue.toolong", new Serializable[]{name}));
        }
    }

    public void validateStringNotBlank(String string, String name) throws InvalidEmptyValueException {
        if (StringUtils.isBlank((CharSequence)string)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{name});
        }
    }

    public void validateUri(String uriString, String name) throws InvalidValueException, InvalidEmptyValueException {
        if (StringUtils.isBlank((CharSequence)uriString)) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{name});
        }
        this.validateStringMaxLength(uriString, name);
        try {
            URI.create(uriString);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.serviceExceptionFactory.raise(InvalidValueException.class, new Serializable[]{name, "valid URL", uriString});
        }
    }

    public void validateScopes(Set<String> scopes) throws InvalidEmptyValueException, InvalidValueException {
        if (scopes == null || scopes.isEmpty()) {
            this.serviceExceptionFactory.raise(InvalidEmptyValueException.class, new Serializable[]{"Scopes"});
        }
        for (String scope : scopes) {
            if (scope.contains(" ")) {
                this.serviceExceptionFactory.raise(InvalidValueException.class, I18nKey.newI18nKey("applinks.service.error.invalidvalue.no.space", new Serializable[0]));
            }
            this.validateStringMaxLength(scope, "scope");
        }
    }
}

