/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.audit;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UniconnAuditPublisherService {
    private static final String UNICONN_AUDIT_CATEGORY = "applinks.audit.uniconn.category";
    private static final String UNICONN_AUDIT_ACTION_DELETED = "applinks.audit.uniconn.connection.deleted";
    private static final String UNICONN_AUDIT_ACTION_CREDENTIALS_ROTATED = "applinks.audit.uniconn.connection.credentials.rotated";
    private static final String UNICONN_AUDIT_ACTION_CREDENTIALS_REVOKED = "applinks.audit.uniconn.connection.credentials.revoked";
    private static final String UNICONN_AUDIT_ACTION_ACCEPTED = "applinks.audit.uniconn.connection.accepted";
    private static final String UNICONN_AUDIT_ACTION_REJECTED = "applinks.audit.uniconn.connection.rejected";
    private static final String UNICONN_AUDIT_ACTION_CONSENT_UPDATED = "applinks.audit.uniconn.connection.consent.updated";
    private static final String UNICONN_AUDIT_ATTR_REJECTION_REASON = "applinks.audit.uniconn.attr.reason";
    private static final String UNICONN_AUDIT_ATTR_CONSENTED_SCOPES = "applinks.audit.uniconn.attr.scopes";
    private static final String UNICONN_AUDIT_ATTR_CONSENTED_DATA_EXPORT_ENTITLEMENTS = "applinks.audit.uniconn.attr.dataExportEntitlements";
    private static final String UNICONN_AUDIT_ATTR_NAME = "applinks.audit.uniconn.attr.name";
    private static final String UNICONN_AUDIT_ATTR_APPLICATION_ID = "applinks.audit.uniconn.attr.application.id";
    private static final String UNICONN_AUDIT_ATTR_APPLICATION_TYPE = "applinks.audit.uniconn.attr.application.type";
    private final AuditService auditService;

    @Autowired
    public UniconnAuditPublisherService(@Nonnull AuditService auditService) {
        this.auditService = Objects.requireNonNull(auditService);
    }

    private AuditResource getCloudProductConnectionAffectedObject(@Nonnull String connectionId) {
        return AuditResource.builder((String)("product.connection." + connectionId), (String)"cloudProductConnection").id(connectionId).build();
    }

    private AuditEvent.Builder createBaseAuditEvent(@Nonnull String summaryI18nKey, @Nonnull String connectionId, @Nullable CloudProductConnection connection, @Nullable ApplicationLink applicationLink) {
        String applicationId;
        String applicationName;
        String string = connection != null ? connection.name() : (applicationName = applicationLink != null ? applicationLink.getName() : "");
        String string2 = connection != null ? connection.applicationId() : (applicationId = applicationLink != null ? applicationLink.getId().toString() : "");
        String applicationType = connection != null ? connection.applicationType().getI18nKey() : (applicationLink != null ? applicationLink.getType().getI18nKey() : "");
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.ECOSYSTEM, (CoverageLevel)CoverageLevel.BASE, (String)UNICONN_AUDIT_CATEGORY, (String)summaryI18nKey).build()).affectedObject(this.getCloudProductConnectionAffectedObject(connectionId));
        List<AuditAttribute> baseAttributes = List.of(AuditAttribute.fromI18nKeys((String)UNICONN_AUDIT_ATTR_NAME, (String)applicationName).build(), AuditAttribute.fromI18nKeys((String)UNICONN_AUDIT_ATTR_APPLICATION_ID, (String)applicationId).build(), AuditAttribute.fromI18nKeys((String)UNICONN_AUDIT_ATTR_APPLICATION_TYPE, (String)applicationType).build());
        return builder.extraAttributes(baseAttributes);
    }

    private static String joinSortedCommaSeparated(@Nonnull Set<String> values) {
        return values.isEmpty() ? "" : values.stream().sorted().collect(Collectors.joining(","));
    }

    public void publishCloudProductConnectionDeletion(@Nonnull String connectionId, @Nonnull ApplicationLink applicationLink) {
        this.auditEvent(UNICONN_AUDIT_ACTION_DELETED, connectionId, applicationLink, b -> {});
    }

    public void publishCloudProductConnectionCredentialsRotated(@Nonnull CloudProductConnection connection) {
        this.auditEvent(UNICONN_AUDIT_ACTION_CREDENTIALS_ROTATED, connection);
    }

    public void publishCloudProductConnectionCredentialsRevoked(@Nonnull String connectionId, @Nonnull ApplicationLink applicationLink) {
        this.auditEvent(UNICONN_AUDIT_ACTION_CREDENTIALS_REVOKED, connectionId, applicationLink, b -> {});
    }

    public void publishCloudProductConnectionAccepted(@Nonnull CloudProductConnection connection) {
        this.auditEvent(UNICONN_AUDIT_ACTION_ACCEPTED, connection);
    }

    public void publishCloudProductConnectionRejected(@Nonnull CloudProductConnection connection, @Nonnull String reason) {
        this.auditEvent(UNICONN_AUDIT_ACTION_REJECTED, connection, builder -> builder.extraAttributes(List.of(AuditAttribute.fromI18nKeys((String)UNICONN_AUDIT_ATTR_REJECTION_REASON, (String)reason).build())));
    }

    public void publishCloudProductConnectionConsentUpdated(@Nonnull CloudProductConnection connection, @Nonnull Set<String> scopes, @Nonnull Set<String> dataExportEntitlements) {
        String scopesValue = UniconnAuditPublisherService.joinSortedCommaSeparated(scopes);
        String entitlementsValue = UniconnAuditPublisherService.joinSortedCommaSeparated(dataExportEntitlements);
        this.auditEvent(UNICONN_AUDIT_ACTION_CONSENT_UPDATED, connection, builder -> {
            ArrayList<AuditAttribute> attributes = new ArrayList<AuditAttribute>();
            if (!scopesValue.isEmpty()) {
                attributes.add(AuditAttribute.fromI18nKeys((String)UNICONN_AUDIT_ATTR_CONSENTED_SCOPES, (String)scopesValue).build());
            }
            if (!entitlementsValue.isEmpty()) {
                attributes.add(AuditAttribute.fromI18nKeys((String)UNICONN_AUDIT_ATTR_CONSENTED_DATA_EXPORT_ENTITLEMENTS, (String)entitlementsValue).build());
            }
            if (!attributes.isEmpty()) {
                builder.extraAttributes(attributes);
            }
        });
    }

    private void auditEvent(@Nonnull String actionI18nKey, @Nonnull CloudProductConnection connection, @Nonnull Consumer<AuditEvent.Builder> builderCustomizer) {
        AuditEvent.Builder builder = this.createBaseAuditEvent(actionI18nKey, connection.id(), connection, null);
        builderCustomizer.accept(builder);
        this.auditService.audit(builder.build());
    }

    private void auditEvent(@Nonnull String actionI18nKey, @Nonnull String connectionId, @Nonnull ApplicationLink applicationLink, @Nonnull Consumer<AuditEvent.Builder> builderCustomizer) {
        AuditEvent.Builder builder = this.createBaseAuditEvent(actionI18nKey, connectionId, null, applicationLink);
        builderCustomizer.accept(builder);
        this.auditService.audit(builder.build());
    }

    private void auditEvent(@Nonnull String actionI18nKey, @Nonnull CloudProductConnection connection) {
        this.auditEvent(actionI18nKey, connection, b -> {});
    }
}

