/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.client.srs;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.internal.api.uniconn.BackboneApplicationType;
import com.atlassian.applinks.internal.rest.uniconn.exception.BackboneConnectionException;
import com.atlassian.applinks.internal.rest.uniconn.exception.SrsResponseException;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.applinks.internal.uniconn.client.srs.NoBackboneConnectionException;
import com.atlassian.applinks.internal.uniconn.client.srs.SrsRetryService;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsBackboneMetadataRequest;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsCloudProductConnectionsResponse;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsDisableLinkRequest;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsExchangeOauthCredentialsRequest;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsExchangeOauthCredentialsResponse;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsHealthcheckResponse;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsProductAppLinkAckRequest;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsProductConnectionsMetadataRequest;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsRejectCloudProductConnectionRequest;
import com.atlassian.applinks.internal.uniconn.client.srs.mapper.SrsCloudProductConnectionsResponseMapper;
import com.atlassian.applinks.internal.uniconn.client.srs.mapper.SrsExchangeOauthCredentialsRequestMapper;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnectionStatus;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.UriBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SrsClient {
    private static final String APP_LINK_INSTALLED_PATH = "/app-link-installed";
    private static final String CLOUD_PRODUCT_CONNECTIONS_PATH = "/cloud-product-connections";
    private static final String EXCHANGE_OAUTH_CREDENTIALS_PATH = "/exchange-oauth-credentials";
    private static final String REJECT_PATH = "/reject";
    private static final String METADATA_PATH = "/metadata";
    private static final String HEALTHCHECK_PATH = "/healthcheck";
    private static final String SRS_LEGACY_PATH = "/connectivity/api/v1";
    private static final String SRS_V3_API_CONTEXT_PATH = "/connectivity/api/v3/orgs/{orgId}/links/{linkId}";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final ApplicationLinkService applicationLinkService;
    private final SrsCloudProductConnectionsResponseMapper srsCloudProductConnectionsResponseMapper;
    private final SrsExchangeOauthCredentialsRequestMapper srsExchangeOauthCredentialsRequestMapper;
    private final SrsRetryService srsRetryService;

    private String toJson(Object payload) {
        try {
            return OBJECT_MAPPER.writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize payload", e);
        }
    }

    private <R> R fromJson(String json, Class<R> responseType) {
        try {
            return (R)OBJECT_MAPPER.readValue(json, responseType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize response", e);
        }
    }

    public SrsClient(ApplicationLinkService applicationLinkService, SrsCloudProductConnectionsResponseMapper srsCloudProductConnectionsResponseMapper, SrsExchangeOauthCredentialsRequestMapper srsExchangeOauthCredentialsRequestMapper, SrsRetryService srsRetryService) {
        this.applicationLinkService = applicationLinkService;
        this.srsCloudProductConnectionsResponseMapper = srsCloudProductConnectionsResponseMapper;
        this.srsExchangeOauthCredentialsRequestMapper = srsExchangeOauthCredentialsRequestMapper;
        this.srsRetryService = srsRetryService;
    }

    private <T, R> R sendRequestWithRetry(Request.MethodType methodType, URL url, T payload, Class<R> responseTypes) {
        return this.sendRequestWithRetry(methodType, url, payload, responseTypes, Collections.emptyMap());
    }

    private <T, R> R sendRequestWithRetry(Request.MethodType methodType, URL url, T payload, Class<R> responseType, Map<String, String> additionalHeaders) {
        String operationName = String.format("%s %s", methodType, url.getPath());
        return (R)this.srsRetryService.executeWithRetry(() -> this.sendRequest(methodType, url, payload, responseType, additionalHeaders), operationName);
    }

    private <T, R> R sendRequest(Request.MethodType methodType, URL url, T payload, Class<R> responseType, Map<String, String> additionalHeaders) {
        ApplicationLink appLink = this.getBackboneApplink();
        ApplicationLinkRequestFactory requestFactory = appLink.createNonImpersonatingAuthenticatedRequestFactory();
        try {
            Response responseObj;
            ApplicationLinkRequest request = requestFactory.createRequest(methodType, url.toString());
            if (additionalHeaders != null) {
                additionalHeaders.forEach((arg_0, arg_1) -> ((ApplicationLinkRequest)request).addHeader(arg_0, arg_1));
            }
            if (payload != null) {
                request.setRequestBody(this.toJson(payload));
                request.addHeader("Content-Type", "application/json");
            }
            if ((responseObj = (Response)request.executeAndReturn(r -> r)).isSuccessful()) {
                return this.buildResponse(responseObj, responseType);
            }
            throw new SrsResponseException(responseObj.getStatusCode());
        }
        catch (CredentialsRequiredException e) {
            throw new BackboneConnectionException(e.getMessage(), e);
        }
        catch (SrsResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SrsResponseException(e.getMessage(), e);
        }
    }

    private ApplicationLink getBackboneApplink() {
        ApplicationLink appLink = this.applicationLinkService.getPrimaryApplicationLink(BackboneApplicationType.class);
        if (appLink == null) {
            throw new NoBackboneConnectionException();
        }
        return appLink;
    }

    private <R> R buildResponse(Response response, Class<R> responseType) throws ResponseException {
        if (responseType == Void.class) {
            return null;
        }
        return this.fromJson(response.getResponseBodyAsString(), responseType);
    }

    private UriBuilder getSrsApiPath() {
        ApplicationLink backboneApplink = this.getBackboneApplink();
        if (StringUtils.isNotBlank((CharSequence)backboneApplink.getClientCredentialsClientConfigurationId())) {
            String orgId = (String)backboneApplink.getProperty(UniconnApplinkProperties.ORG_ID.key());
            if (orgId == null) {
                throw new BackboneConnectionException("No orgId found on backbone application link");
            }
            String linkId = (String)backboneApplink.getProperty(UniconnApplinkProperties.LINK_ID.key());
            if (linkId == null) {
                throw new BackboneConnectionException("No linkId found on backbone application link");
            }
            return this.getSrsOAuth2Path(orgId, linkId);
        }
        return this.getSrsLegacyPath();
    }

    private UriBuilder getSrsLegacyPath() {
        return UriBuilder.fromUri((String)UniconnApplinkUtils.getCloudApiBaseUrl()).path(SRS_LEGACY_PATH);
    }

    private UriBuilder getSrsOAuth2Path(String orgId, String linkId) {
        return UriBuilder.fromUri((String)UniconnApplinkUtils.getCloudApiBaseUrl()).path(SRS_V3_API_CONTEXT_PATH).resolveTemplate("orgId", (Object)orgId).resolveTemplate("linkId", (Object)linkId);
    }

    public List<CloudProductConnection> getConnections(CloudProductConnectionStatus status) throws ResponseException {
        return this.getConnections(null, status);
    }

    public List<CloudProductConnection> getConnections(Locale locale, CloudProductConnectionStatus ... statuses) throws ResponseException {
        try {
            UriBuilder builder = this.getSrsApiPath().path(CLOUD_PRODUCT_CONNECTIONS_PATH);
            if (statuses != null && statuses.length > 0) {
                String joined = Arrays.stream(statuses).map(Enum::name).collect(Collectors.joining(","));
                builder = builder.queryParam("status", new Object[]{joined});
            }
            URL url = builder.build(new Object[0]).toURL();
            Map<String, String> headers = null;
            if (locale != null) {
                headers = Map.of("Accept-Language", locale.toLanguageTag());
            }
            SrsCloudProductConnectionsResponse response = this.sendRequestWithRetry(Request.MethodType.GET, url, null, SrsCloudProductConnectionsResponse.class, headers);
            return this.srsCloudProductConnectionsResponseMapper.fromDto(response);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public SrsExchangeOauthCredentialsResponse exchangeOauthCredentials(@Nullable Client client, CloudProductConnection cloudProductConnection) throws ResponseException {
        try {
            URL url = this.getSrsApiPath().path("/cloud-product-connections/{id}/exchange-oauth-credentials").resolveTemplate("id", (Object)cloudProductConnection.id()).build(new Object[0]).toURL();
            String rotationId = cloudProductConnection.credentialRotation() != null ? cloudProductConnection.credentialRotation().id() : null;
            SrsExchangeOauthCredentialsRequest payload = this.srsExchangeOauthCredentialsRequestMapper.toDto(client, rotationId);
            return this.sendRequestWithRetry(Request.MethodType.POST, url, payload, SrsExchangeOauthCredentialsResponse.class);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void rejectConnection(String cloudProductConnectionId, String reason) throws ResponseException {
        try {
            URL url = this.getSrsApiPath().path("/cloud-product-connections/{id}/reject").resolveTemplate("id", (Object)cloudProductConnectionId).build(new Object[0]).toURL();
            SrsRejectCloudProductConnectionRequest payload = new SrsRejectCloudProductConnectionRequest(reason);
            this.sendRequestWithRetry(Request.MethodType.POST, url, payload, Void.class);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteConnection(String cloudProductConnectionId) throws ResponseException {
        try {
            URL url = this.getSrsApiPath().path("/cloud-product-connections/{id}").resolveTemplate("id", (Object)cloudProductConnectionId).build(new Object[0]).toURL();
            this.sendRequestWithRetry(Request.MethodType.DELETE, url, null, Void.class);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void disableBackboneConnection() {
        try {
            URL url = this.getSrsApiPath().path("/enabled").build(new Object[0]).toURL();
            this.sendRequestWithRetry(Request.MethodType.POST, url, new SrsDisableLinkRequest(false), Void.class);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void acknowledgeAppLinkInstalled(String connectionId, @Nullable String rotationId, @Nullable String redirectURL) throws ResponseException {
        try {
            URL url = this.getSrsApiPath().path("/cloud-product-connections/{id}/app-link-installed").resolveTemplate("id", (Object)connectionId).build(new Object[0]).toURL();
            SrsProductAppLinkAckRequest payload = new SrsProductAppLinkAckRequest(rotationId, redirectURL);
            this.sendRequestWithRetry(Request.MethodType.PUT, url, payload, Void.class);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendProductConnectionsMetadata(@Nonnull SrsProductConnectionsMetadataRequest metadataRequestPayload) {
        try {
            URL url = this.getSrsApiPath().path("/cloud-product-connections/metadata").build(new Object[0]).toURL();
            this.sendRequestWithRetry(Request.MethodType.POST, url, metadataRequestPayload, Void.class);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendBackboneMetadata(@Nonnull SrsBackboneMetadataRequest metadataRequestPayload) throws SrsResponseException {
        try {
            URL url = this.getSrsApiPath().path(METADATA_PATH).build(new Object[0]).toURL();
            this.sendRequestWithRetry(Request.MethodType.POST, url, metadataRequestPayload, Void.class);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public SrsHealthcheckResponse performHealthcheck() {
        try {
            URL url = this.getSrsApiPath().path(HEALTHCHECK_PATH).build(new Object[0]).toURL();
            return this.sendRequestWithRetry(Request.MethodType.GET, url, null, SrsHealthcheckResponse.class);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

