/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.client.srs;

import com.atlassian.applinks.internal.rest.uniconn.exception.SrsResponseException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SrsRetryService {
    private static final Logger log = LoggerFactory.getLogger(SrsRetryService.class);

    public <T> T executeWithRetry(Supplier<T> operation, String operationName) {
        RuntimeException lastException = null;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                return operation.get();
            }
            catch (RuntimeException e) {
                lastException = e;
                if (!this.shouldRetry(e)) {
                    log.debug("SRS {} attempt {} failed with non-retryable exception: {}", new Object[]{operationName, attempt, e.getMessage()});
                    throw e;
                }
                log.warn("SRS {} attempt {} failed with retryable exception: {}", new Object[]{operationName, attempt, e.getMessage(), e});
                if (attempt >= 3) continue;
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Retry interrupted", ie);
                }
            }
        }
        throw lastException;
    }

    private boolean shouldRetry(RuntimeException exception) {
        if (this.isTemporaryNetworkIssue(exception)) {
            return true;
        }
        if (exception instanceof SrsResponseException) {
            SrsResponseException srsException = (SrsResponseException)exception;
            int statusCode = srsException.getStatusCode();
            return statusCode == 429 || statusCode >= 500 && statusCode < 600;
        }
        return false;
    }

    private boolean isTemporaryNetworkIssue(RuntimeException exception) {
        for (Throwable current = exception; current != null; current = current.getCause()) {
            String message;
            if (current instanceof SocketTimeoutException) {
                return true;
            }
            if (current instanceof ConnectException && (message = current.getMessage()) != null && message.contains("timed out")) {
                return true;
            }
            if (!(current instanceof SocketException) || (message = current.getMessage()) == null || !message.contains("Connection reset") && !message.contains("Broken pipe") && !message.contains("Connection aborted")) continue;
            return true;
        }
        return false;
    }
}

