/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.client.srs.mapper;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.internal.uniconn.CloudProductConnectionCredentialsExpiryResolver;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsProductConnectionClientMetadata;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsProductConnectionMetadata;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsProductConnectionsMetadataRequest;
import com.atlassian.applinks.internal.uniconn.utils.UniconnApplinkUtils;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.internal.InternalRotationClientService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SrsCloudProductConnectionMetadataRequestMapper {
    private static final Logger LOG = LoggerFactory.getLogger(SrsCloudProductConnectionMetadataRequestMapper.class);
    private final InternalRotationClientService internalClientService;
    private final CloudProductConnectionCredentialsExpiryResolver expiryResolver;

    public SrsCloudProductConnectionMetadataRequestMapper(InternalRotationClientService internalClientService, CloudProductConnectionCredentialsExpiryResolver expiryResolver) {
        this.internalClientService = internalClientService;
        this.expiryResolver = expiryResolver;
    }

    public SrsProductConnectionsMetadataRequest toDto(@Nonnull List<ApplicationLink> appLinks) {
        ArrayList<SrsProductConnectionMetadata> metadataDetails = new ArrayList<SrsProductConnectionMetadata>();
        for (ApplicationLink appLink : appLinks) {
            SrsProductConnectionMetadata metadata = this.createMetadataDetails(appLink);
            metadataDetails.add(metadata);
        }
        return new SrsProductConnectionsMetadataRequest(metadataDetails);
    }

    private SrsProductConnectionMetadata createMetadataDetails(@Nonnull ApplicationLink appLink) {
        String connectionId = UniconnApplinkUtils.getCloudProductConnectionId(appLink);
        List<String> dataExportEntitlements = this.extractDataExportEntitlements(appLink);
        if (UniconnApplinkUtils.areCredentialsRevoked(appLink)) {
            LOG.debug("Creating metadata for revoked connection: {}", (Object)connectionId);
            return new SrsProductConnectionMetadata(connectionId, dataExportEntitlements, null);
        }
        SrsProductConnectionClientMetadata clientDetails = this.createClientDetails(appLink);
        return new SrsProductConnectionMetadata(connectionId, dataExportEntitlements, clientDetails);
    }

    private List<String> extractDataExportEntitlements(@Nonnull ApplicationLink appLink) {
        Object entitlementsProperty = appLink.getProperty(UniconnApplinkProperties.DATA_EXPORT_ENTITLEMENTS.key());
        return this.extractListFromEntitlementsProperty(entitlementsProperty);
    }

    @Nullable
    private SrsProductConnectionClientMetadata createClientDetails(@Nonnull ApplicationLink appLink) {
        Optional client = this.internalClientService.getById(appLink.getClientId());
        if (client.isEmpty()) {
            LOG.error("Client with id {} not found while sending metadata for applink with id {}", (Object)appLink.getClientId(), (Object)appLink.getId());
            return null;
        }
        String clientId = ((Client)client.get()).getClientId();
        Optional<Long> expiry = this.expiryResolver.getClientExpiry(appLink.getClientId());
        if (expiry.isEmpty()) {
            LOG.warn("Could not determine expiry for client with id {} while sending metadata for applink with id {}", (Object)appLink.getClientId(), (Object)appLink.getId());
            return null;
        }
        return new SrsProductConnectionClientMetadata(clientId, expiry.get());
    }

    private List<String> extractListFromEntitlementsProperty(@Nullable Object property) {
        if (!(property instanceof List)) {
            LOG.warn("Entitlements property is not a list: {}", property);
            return List.of();
        }
        return ((List)property).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
    }
}

