/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.client.srs.mapper;

import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsExchangeOauthCredentialsResponse;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.SrsOauthClientResponse;
import com.atlassian.applinks.internal.uniconn.client.srs.mapper.SrsOAuthCredentialsGrantTypeMapper;
import com.atlassian.applinks.internal.uniconn.domain.OAuthClientDetails;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SrsExchangeOauthCredentialsResponseMapper {
    public List<OAuthClientDetails> fromDto(@Nonnull SrsExchangeOauthCredentialsResponse response) {
        return response.clients().stream().map(this::mapToOAuthClientDetails).collect(Collectors.toList());
    }

    private OAuthClientDetails mapToOAuthClientDetails(@Nonnull SrsOauthClientResponse clientResponse) {
        return new OAuthClientDetails(SrsOAuthCredentialsGrantTypeMapper.map(clientResponse.grantType()), clientResponse.credentials().clientId(), clientResponse.credentials().clientSecret(), clientResponse.scopes(), clientResponse.tokenEndpoint(), clientResponse.authorizationEndpoint(), clientResponse.customParams());
    }
}

