/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.domain;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.applinks.internal.uniconn.domain.BackboneConnection;
import com.atlassian.applinks.internal.uniconn.domain.UniconnConnectionRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public record BackboneConnectionRequest(@Nonnull BackboneConnection connection, @Nonnull String clientCredentialsClientId) implements UniconnConnectionRequest
{
    public BackboneConnectionRequest {
        Objects.requireNonNull(connection, "connection cannot be null");
        Objects.requireNonNull(clientCredentialsClientId, "clientCredentialsClientId cannot be null");
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.connection.applicationId();
    }

    @Override
    public ApplicationType getApplicationType() {
        return this.connection.applicationType();
    }

    @Override
    public String getName() {
        return this.connection.name();
    }

    @Override
    public String getRpcUrl() {
        return this.connection.rpcUrl();
    }

    @Override
    public String getDisplayUrl() {
        return this.connection.displayUrl();
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public boolean isCloud() {
        return true;
    }

    @Override
    public Map<String, Object> getConnectionProperties() {
        HashMap<String, Object> connectionProps = new HashMap<String, Object>();
        connectionProps.put(UniconnApplinkProperties.LINK_ID.key(), this.connection.linkId());
        connectionProps.put(UniconnApplinkProperties.ORG_ID.key(), this.connection.orgId());
        connectionProps.put(UniconnApplinkProperties.ORG_NAME.key(), this.connection.orgName());
        connectionProps.put(UniconnApplinkProperties.CONNECTION_STATUS.key(), this.connection.status().name());
        if (this.connection.credentialsExpiry() != null) {
            connectionProps.put(UniconnApplinkProperties.CREDENTIALS_EXPIRY.key(), String.valueOf(this.connection.credentialsExpiry()));
        }
        return connectionProps;
    }

    @Override
    public String getClientCredentialsClientId() {
        return this.clientCredentialsClientId;
    }

    @Override
    @Nullable
    public String getAuthorizationCodeClientId() {
        return null;
    }

    @Override
    @Nullable
    public String getIncomingClientId() {
        return null;
    }
}

