/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.scopes;

import com.atlassian.applinks.internal.uniconn.domain.HostApplicationDataExportEntitlement;
import com.atlassian.applinks.internal.uniconn.entitlements.DataExportEntitlement;
import com.atlassian.applinks.internal.uniconn.entitlements.DataExportEntitlementService;
import com.atlassian.applinks.internal.uniconn.scopes.AvailableDataExportEntitlementsProvider;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AvailableDataExportEntitlementsProviderImpl
implements AvailableDataExportEntitlementsProvider {
    private final DataExportEntitlementService dataExportEntitlementService;
    private final I18nResolver i18nResolver;

    @Autowired
    public AvailableDataExportEntitlementsProviderImpl(DataExportEntitlementService dataExportEntitlementService, I18nResolver i18nResolver) {
        this.dataExportEntitlementService = dataExportEntitlementService;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public List<HostApplicationDataExportEntitlement> getAvailableDataExportEntitlements() {
        List<DataExportEntitlement> entitlements = this.dataExportEntitlementService.getAllDataExportEntitlements();
        return entitlements.stream().map(this::convertToHostApplicationDataExportEntitlement).collect(Collectors.toList());
    }

    private HostApplicationDataExportEntitlement convertToHostApplicationDataExportEntitlement(DataExportEntitlement entitlement) {
        String resolvedTitle = this.i18nResolver.getText(entitlement.title());
        String[] descriptions = this.discoverAndResolveDescriptions(entitlement.descriptionPrefix());
        return new HostApplicationDataExportEntitlement(entitlement.key(), resolvedTitle, descriptions);
    }

    private String[] discoverAndResolveDescriptions(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return new String[0];
        }
        Map translations = this.i18nResolver.getAllTranslationsForPrefix(prefix);
        return translations.values().toArray(new String[0]);
    }
}

