/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.scopes;

import com.atlassian.applinks.internal.uniconn.domain.HostApplicationScopeDetails;
import com.atlassian.applinks.internal.uniconn.scopes.AvailableScopesProvider;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopeDescriptionService;
import com.atlassian.oauth2.scopes.api.ScopeDescriptionWithTitle;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultAvailableScopesProvider
implements AvailableScopesProvider {
    private final ScopeResolver scopeResolver;
    private final ScopeDescriptionService scopeDescriptionService;

    @Autowired
    public DefaultAvailableScopesProvider(ScopeResolver scopeResolver, ScopeDescriptionService scopeDescriptionService) {
        this.scopeResolver = scopeResolver;
        this.scopeDescriptionService = scopeDescriptionService;
    }

    @Override
    public List<HostApplicationScopeDetails> getAvailableScopesDetails() {
        Map scopeDescriptionsWithTitle = this.scopeDescriptionService.getScopeDescriptionsWithTitle();
        return this.scopeResolver.getAvailableScopes().stream().filter(scope -> scopeDescriptionsWithTitle.containsKey(scope.getName())).sorted((a, b) -> a.getName().compareTo(b.getName())).map(scope -> this.toScopeDetails((Scope)scope, (ScopeDescriptionWithTitle)scopeDescriptionsWithTitle.get(scope.getName()))).collect(Collectors.toList());
    }

    private HostApplicationScopeDetails toScopeDetails(Scope scope, ScopeDescriptionWithTitle scopeDescription) {
        String scopeName = scope.getName();
        String title = scopeDescription.getTitle();
        List<String> descriptions = List.of(scopeDescription.getDescription());
        List<String> inheritedScopes = scope.getScopeAndInheritedScopes().stream().filter(inherited -> !inherited.getName().equals(scope.getName())).map(Scope::getName).collect(Collectors.toList());
        return new HostApplicationScopeDetails(scopeName, title, descriptions, inheritedScopes);
    }
}

