/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.uniconn.utils;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.core.property.ApplicationLinkProperties;
import com.atlassian.applinks.internal.uniconn.UniconnApplinkProperties;
import com.atlassian.applinks.internal.uniconn.client.srs.dto.CredentialRotationStatus;
import com.atlassian.applinks.internal.uniconn.domain.CloudProductConnection;
import com.atlassian.applinks.internal.uniconn.domain.Experience;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UniconnApplinkUtils {
    private static final String CLOUD_API_BASE_URL_PROPERTY_NAME = "applinks.cloud.api.base.url";
    private static final String PROD_API_BASE_URL = "https://api.atlassian.com";
    private static final String STAGING_API_PREFIX = "https://api.stg";
    public static final String ADMIN_HUB_URL_TEMPLATE = "https://admin%s.atlassian.com";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(UniconnApplinkUtils.class);

    private UniconnApplinkUtils() {
    }

    public static boolean isUniconnApplink(ApplicationLink link) {
        if (link == null) {
            return false;
        }
        Object value = link.getProperty(UniconnApplinkProperties.UNICONN.key());
        return value != null && Boolean.parseBoolean(String.valueOf(value));
    }

    public static boolean isUniconnCloudProductConnectionApplink(ApplicationLink link) {
        if (link == null) {
            return false;
        }
        Object uniconnProperty = link.getProperty(UniconnApplinkProperties.UNICONN.key());
        String connectionId = UniconnApplinkUtils.getCloudProductConnectionId(link);
        return Boolean.parseBoolean(String.valueOf(uniconnProperty)) && StringUtils.isNotBlank((CharSequence)connectionId);
    }

    public static Set<String> getRequiredDcScopes(Experience experience) {
        return experience.dcAccessEntitlements() != null && experience.dcAccessEntitlements().required() != null ? experience.dcAccessEntitlements().required().scopes() : Set.of();
    }

    public static boolean areCredentialsRevoked(ApplicationLink applicationLink) {
        if (applicationLink == null) {
            return false;
        }
        Object credentialsRevokedProperty = applicationLink.getProperty(UniconnApplinkProperties.PRODUCT_CREDENTIALS_REVOKED.key());
        return Boolean.parseBoolean(String.valueOf(credentialsRevokedProperty));
    }

    public static boolean shouldRotateCredentials(CloudProductConnection connection) {
        return connection != null && connection.credentialRotation() != null && connection.credentialRotation().status() != CredentialRotationStatus.ROTATION_FAILED;
    }

    public static String getCloudProductConnectionId(ApplicationLink applicationLink) {
        if (applicationLink == null) {
            return null;
        }
        Object property = applicationLink.getProperty(UniconnApplinkProperties.CLOUD_PRODUCT_CONNECTION_ID.key());
        return property != null ? property.toString() : null;
    }

    public static boolean isStaging() {
        return UniconnApplinkUtils.getCloudApiBaseUrl().startsWith(STAGING_API_PREFIX);
    }

    public static String getCloudApiBaseUrl() {
        String baseUrlProp = System.getProperty(CLOUD_API_BASE_URL_PROPERTY_NAME);
        return baseUrlProp == null ? PROD_API_BASE_URL : baseUrlProp;
    }

    public static String getBackboneRpcUrl() {
        return UniconnApplinkUtils.getCloudApiBaseUrl();
    }

    public static String getDisplayUrl(String orgId) {
        String adminBaseUrl = UniconnApplinkUtils.getCloudAdminBaseUrl();
        return String.format("%s/o/%s", adminBaseUrl, orgId);
    }

    private static String getCloudAdminBaseUrl() {
        return String.format(ADMIN_HUB_URL_TEMPLATE, UniconnApplinkUtils.isStaging() ? ".stg" : "");
    }

    public static void setCloudProductConnectionCustomProperties(ApplicationLinkProperties applicationLinkProperties, @Nullable Map<String, String> properties) {
        Map<Object, Object> safeProperties = properties == null ? Collections.emptyMap() : properties;
        try {
            String json = MAPPER.writeValueAsString(safeProperties);
            applicationLinkProperties.putProperty(UniconnApplinkProperties.CUSTOM_CLIENT_PROPERTIES.key(), json);
        }
        catch (JsonProcessingException ex) {
            LOG.error("Failed to serialize custom properties", (Throwable)ex);
        }
    }
}

