/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.ui.velocity;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.auth.OrphanedTrustDetector;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.internal.common.docs.DocumentationLinker;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.applinks.ui.velocity.ListApplicationLinksContext;
import com.atlassian.applinks.ui.velocity.ListEntityLinksContext;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class VelocityContextFactory {
    private final InternalHostApplication internalHostApplication;
    private final InternalTypeAccessor typeAccessor;
    private final I18nResolver i18nResolver;
    private final DocumentationLinker documentationLinker;
    private final OrphanedTrustDetector orphanedTrustDetector;
    private final ApplicationLinkService applicationLinkService;
    private final ManifestRetriever manifestRetriever;
    private final MessageFactory messageFactory;
    private final UserManager userManager;
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public VelocityContextFactory(InternalHostApplication internalHostApplication, InternalTypeAccessor typeAccessor, I18nResolver i18nResolver, DocumentationLinker documentationLinker, @Qualifier(value="delegatingOrphanedTrustDetector") OrphanedTrustDetector orphanedTrustDetector, ApplicationLinkService applicationLinkService, ManifestRetriever manifestRetriever, MessageFactory messageFactory, UserManager userManager, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties) {
        this.internalHostApplication = internalHostApplication;
        this.typeAccessor = typeAccessor;
        this.i18nResolver = i18nResolver;
        this.documentationLinker = documentationLinker;
        this.orphanedTrustDetector = orphanedTrustDetector;
        this.applicationLinkService = applicationLinkService;
        this.manifestRetriever = manifestRetriever;
        this.messageFactory = messageFactory;
        this.userManager = userManager;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
    }

    public ListApplicationLinksContext buildListApplicationLinksContext(HttpServletRequest request) {
        boolean isSysadmin = this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey());
        return new ListApplicationLinksContext(this.internalHostApplication, this.typeAccessor, this.i18nResolver, this.documentationLinker, this.orphanedTrustDetector, request, this.pluginAccessor, isSysadmin, this.applicationProperties);
    }

    public ListEntityLinksContext buildListEntityLinksContext(HttpServletRequest request, String entityTypeId, String entityKey) {
        boolean isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUserKey(request));
        return new ListEntityLinksContext(this.applicationLinkService, this.manifestRetriever, this.internalHostApplication, this.documentationLinker, this.i18nResolver, this.messageFactory, this.typeAccessor, entityTypeId, entityKey, request.getContextPath(), this.getUsername(request), isAdmin);
    }

    private String getUsername(HttpServletRequest request) {
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        return userProfile != null ? userProfile.getUsername() : null;
    }
}

