/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.SatiableConsumer;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.plugin.util.ClassUtils;
import com.atlassian.stash.internal.Dao;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateDao<K extends Serializable, E>
implements Dao<K, E> {
    public static final int MAX_BATCH_SIZE = 100;
    protected static final int DELETE_PAGE_SIZE = 500;
    private static final List<HqlQueryBuilder.HqlQueryOrder> DEFAULT_IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.asc("id"));
    protected final Class<E> entityClass;
    protected final Logger log;
    private final SessionFactory sessionFactory;

    public AbstractHibernateDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.entityClass = (Class)ClassUtils.getTypeArguments(AbstractHibernateDao.class, this.getClass()).get(1);
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @Nonnull
    public E create(E entity) {
        this.session().saveOrUpdate(entity);
        return entity;
    }

    @Override
    public void delete(E entity) {
        this.session().delete(entity);
    }

    @Override
    public void deleteById(K id) {
        this.session().createQuery("delete from " + this.entityClass.getSimpleName() + " where id = :id").setParameter("id", id).executeUpdate();
    }

    @Override
    @Nonnull
    public Page<E> findAll(PageRequest pageRequest) {
        return this.pageQuery(this.createQueryBuilder().buildQuery(this.session()), pageRequest);
    }

    @Override
    @Nonnull
    public Page<E> findAll(PageRequest pageRequest, Predicate<? super E> predicate) {
        return this.pageQuery(this.createQueryBuilder().buildQuery(this.session()), pageRequest, predicate);
    }

    @Override
    public E getById(K id) {
        return this.entityClass.cast(this.session().get(this.entityClass, id));
    }

    @Override
    @Nonnull
    public List<E> getByIds(@Nonnull Collection<K> ids) {
        return this.createQueryBuilder().where(HqlQueryBuilder.HqlWhereQueryComponent.in("id", ids)).buildQuery(this.session()).list();
    }

    @Override
    public E loadById(K id) {
        return this.entityClass.cast(this.session().load(this.entityClass, id));
    }

    @Override
    public void refresh(E entity) {
        this.session().refresh(entity);
    }

    @Override
    public E update(E entity) {
        return this.entityClass.cast(this.session().merge(entity));
    }

    @Override
    public E updateAndFlush(E entity) {
        E result = this.update(entity);
        this.session().flush();
        return result;
    }

    protected HqlQueryBuilder<E> applyImplicitOrder(HqlQueryBuilder<E> builder) {
        Objects.requireNonNull(builder, "builder");
        return builder.orderBy(this.getImplicitOrder());
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return DEFAULT_IMPLICIT_QUERY_ORDER;
    }

    protected boolean isHsql() {
        return ((SessionFactoryImplementor)this.sessionFactory).getJdbcServices().getDialect() instanceof HSQLDialect;
    }

    protected boolean isPostgres() {
        return ((SessionFactoryImplementor)this.sessionFactory).getJdbcServices().getDialect() instanceof PostgreSQL81Dialect;
    }

    protected boolean isSqlServer() {
        return ((SessionFactoryImplementor)this.sessionFactory).getJdbcServices().getDialect() instanceof SQLServerDialect;
    }

    protected int maybeBulkDelete(String hql) {
        return this.maybeBulkDelete(hql, Collections.emptyMap());
    }

    protected int maybeBulkDelete(String hql, Map<String, Object> parameters) {
        Session session = this.session();
        if (this.isHsql()) {
            List entities;
            int deleted = 0;
            Query query = this.setParameters(session.createQuery(hql).setMaxResults(500), parameters);
            while (!(entities = query.list()).isEmpty()) {
                for (Object entity : entities) {
                    session.delete(entity);
                    ++deleted;
                }
                session.flush();
                session.clear();
                if (entities.size() >= 500) continue;
                break;
            }
            return deleted;
        }
        return this.setParameters(session.createQuery("delete " + hql), parameters).executeUpdate();
    }

    protected <T> Page<T> pageQuery(Query<T> query, PageRequest request, Predicate<? super T> predicate) {
        return HibernatePageUtils.pageQuery(query, request, predicate);
    }

    protected <T> Page<T> pageQuery(Query<T> query, PageRequest request) {
        return HibernatePageUtils.pageQuery(query, request);
    }

    protected void retryOnConstraintViolation(int maxAttempts, Runnable action) {
        this.retryOnConstraintViolation(maxAttempts, () -> {
            action.run();
            return null;
        });
    }

    protected <T> T retryOnConstraintViolation(int maxAttempts, UncheckedOperation<T> action) {
        return this.retryOnPersistenceException(maxAttempts, action, Collections.singleton(ConstraintViolationException.class));
    }

    protected <T> T retryOnPersistenceException(int maxAttempts, UncheckedOperation<T> action) {
        return this.retryOnPersistenceException(maxAttempts, action, Collections.emptyList());
    }

    protected void scrollQuery(Query query, Consumer<ScrollableResults> resultsConsumer) {
        try (ScrollableResults result = query.scroll(ScrollMode.FORWARD_ONLY);){
            while (result.next()) {
                resultsConsumer.accept(result);
            }
        }
    }

    protected void scrollQuery(Query query, SatiableConsumer<ScrollableResults> resultsConsumer) {
        try (ScrollableResults result = query.scroll(ScrollMode.FORWARD_ONLY);){
            boolean isDone = false;
            while (!isDone && result.next()) {
                isDone = resultsConsumer.accept((Object)result);
            }
        }
    }

    protected Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    protected Query setParameters(Query query, Map<String, Object> parameters) {
        parameters.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        return query;
    }

    private HqlQueryBuilder<E> createQueryBuilder() {
        return HqlQueryBuilder.selectFrom(this.entityClass).orderBy(this.getImplicitOrder());
    }

    private <T> T retryOnPersistenceException(int maxAttempts, UncheckedOperation<T> action, Collection<Class<? extends Exception>> exceptionClasses) {
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            try {
                return (T)action.perform();
            }
            catch (PersistenceException e) {
                if (exceptionClasses.isEmpty() || exceptionClasses.stream().anyMatch(clazz -> clazz.isInstance((Object)e) || clazz.isInstance(e.getCause()))) {
                    if (attempt >= maxAttempts) {
                        throw e;
                    }
                } else {
                    throw e;
                }
                this.log.debug("Failed to due persistence exception. Retrying... (attempt {}/{})", new Object[]{attempt, maxAttempts, e});
                continue;
            }
        }
        return null;
    }
}

