/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.stash.internal.backup.DatabaseTableAttribute;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public enum DatabaseTable {
    APP_PROPERTY("app_property", new DatabaseTableAttribute[0]),
    BB_DATA_STORE("bb_data_store", new DatabaseTableAttribute[0]),
    CWD_APPLICATION("cwd_application", DatabaseTableAttribute.CROWD),
    CWD_APPLICATION_SAML_CONFIG("cwd_application_saml_config", DatabaseTableAttribute.CROWD),
    CWD_APP_LICENSING("cwd_app_licensing", DatabaseTableAttribute.CROWD),
    CWD_DIRECTORY("cwd_directory", DatabaseTableAttribute.CROWD),
    CWD_APP_LICENSING_DIR_INFO("cwd_app_licensing_dir_info", DatabaseTableAttribute.CROWD),
    CWD_APP_LICENSED_USER("cwd_app_licensed_user", DatabaseTableAttribute.CROWD),
    CWD_APP_DIR_MAPPING("cwd_app_dir_mapping", DatabaseTableAttribute.CROWD),
    CWD_APP_DIR_GROUP_MAPPING("cwd_app_dir_group_mapping", DatabaseTableAttribute.CROWD),
    CWD_APP_DIR_OPERATION("cwd_app_dir_operation", DatabaseTableAttribute.CROWD),
    CWD_APPLICATION_ADDRESS("cwd_application_address", DatabaseTableAttribute.CROWD),
    CWD_APPLICATION_ALIAS("cwd_application_alias", DatabaseTableAttribute.CROWD),
    CWD_APPLICATION_ATTRIBUTE("cwd_application_attribute", DatabaseTableAttribute.CROWD),
    CWD_DIRECTORY_ATTRIBUTE("cwd_directory_attribute", DatabaseTableAttribute.CROWD),
    CWD_DIRECTORY_OPERATION("cwd_directory_operation", DatabaseTableAttribute.CROWD),
    CWD_GRANTED_PERM("cwd_granted_perm", new DatabaseTableAttribute[0]),
    CWD_GROUP("cwd_group", DatabaseTableAttribute.CROWD),
    CWD_GROUP_ATTRIBUTE("cwd_group_attribute", DatabaseTableAttribute.CROWD),
    CWD_MEMBERSHIP("cwd_membership", DatabaseTableAttribute.CROWD),
    CWD_PROPERTY("cwd_property", DatabaseTableAttribute.CROWD),
    CWD_TOMBSTONE("cwd_tombstone", DatabaseTableAttribute.CROWD),
    CWD_USER("cwd_user", DatabaseTableAttribute.CROWD),
    CWD_USER_ATTRIBUTE("cwd_user_attribute", DatabaseTableAttribute.CROWD),
    CWD_USER_CREDENTIAL_RECORD("cwd_user_credential_record", DatabaseTableAttribute.CROWD),
    CWD_WEBHOOK("cwd_webhook", DatabaseTableAttribute.CROWD),
    CWD_APP_DIR_DEFAULT_GROUPS("cwd_app_dir_default_groups", DatabaseTableAttribute.CROWD),
    CWD_GROUP_ADMIN_GROUP("cwd_group_admin_group", DatabaseTableAttribute.CROWD),
    CWD_GROUP_ADMIN_USER("cwd_group_admin_user", DatabaseTableAttribute.CROWD),
    CWD_SERVICE_ACCOUNT("cwd_service_account", DatabaseTableAttribute.CROWD),
    CWD_SERVICE_ACCOUNT_AUTH_METHOD("cwd_service_account_auth_method", DatabaseTableAttribute.CROWD),
    CWD_RESOURCE_RESTRICTIONS("cwd_resource_restrictions", DatabaseTableAttribute.CROWD),
    STASH_USER("stash_user", new DatabaseTableAttribute[0]),
    STA_NORMAL_USER("sta_normal_user", new DatabaseTableAttribute[0]),
    STA_SERVICE_USER("sta_service_user", new DatabaseTableAttribute[0]),
    STA_SHARED_LOB("sta_shared_lob", new DatabaseTableAttribute[0]),
    STA_USER_SETTINGS("sta_user_settings", new DatabaseTableAttribute[0]),
    PROJECT("project", new DatabaseTableAttribute[0]),
    STA_NORMAL_PROJECT("sta_normal_project", new DatabaseTableAttribute[0]),
    STA_PERSONAL_PROJECT("sta_personal_project", new DatabaseTableAttribute[0]),
    BB_PROJECT_ALIAS("bb_project_alias", new DatabaseTableAttribute[0]),
    REPOSITORY("repository", new DatabaseTableAttribute[0]),
    BB_REPOSITORY_ALIAS("bb_repository_alias", new DatabaseTableAttribute[0]),
    STA_REPO_HOOK("sta_repo_hook", new DatabaseTableAttribute[0]),
    STA_PERMISSION_TYPE("sta_permission_type", "perm_id", DatabaseTableAttribute.PREPOPULATED),
    STA_GLOBAL_PERMISSION("sta_global_permission", new DatabaseTableAttribute[0]),
    STA_PROJECT_PERMISSION("sta_project_permission", new DatabaseTableAttribute[0]),
    STA_REPO_PERMISSION("sta_repo_permission", new DatabaseTableAttribute[0]),
    TRUSTED_APP("trusted_app", new DatabaseTableAttribute[0]),
    TRUSTED_APP_RESTRICTION("trusted_app_restriction", new DatabaseTableAttribute[0]),
    CURRENT_APP("current_app", new DatabaseTableAttribute[0]),
    STA_REMEMBER_ME_TOKEN("sta_remember_me_token", new DatabaseTableAttribute[0]),
    HIBERNATE_UNIQUE_KEY("hibernate_unique_key", DatabaseTableAttribute.PREPOPULATED),
    ID_SEQUENCE("id_sequence", new DatabaseTableAttribute[0]),
    PLUGIN_SETTING("plugin_setting", new DatabaseTableAttribute[0]),
    PLUGIN_STATE("plugin_state", new DatabaseTableAttribute[0]),
    CHANGESET("changeset", new DatabaseTableAttribute[0]),
    CS_ATTRIBUTE("cs_attribute", new DatabaseTableAttribute[0]),
    CS_REPO_MEMBERSHIP("cs_repo_membership", new DatabaseTableAttribute[0]),
    CS_INDEXER_STATE("cs_indexer_state", new DatabaseTableAttribute[0]),
    REPOSITORY_ACCESS("repository_access", new DatabaseTableAttribute[0]),
    STA_REPOSITORY_SCOPED_ID("sta_repository_scoped_id", new DatabaseTableAttribute[0]),
    STA_PULL_REQUEST("sta_pull_request", new DatabaseTableAttribute[0]),
    BB_COMMENT_THREAD("bb_comment_thread", new DatabaseTableAttribute[0]),
    BB_COMMENT("bb_comment", new DatabaseTableAttribute[0]),
    BB_THREAD_ROOT_COMMENT("bb_thread_root_comment", new DatabaseTableAttribute[0]),
    BB_COMMENT_PARENT("bb_comment_parent", new DatabaseTableAttribute[0]),
    STA_COMMIT_DISCUSSION("sta_cmt_discussion", new DatabaseTableAttribute[0]),
    STA_CMT_DISC_PARTICIPANT("sta_cmt_disc_participant", new DatabaseTableAttribute[0]),
    BB_PR_PART_STATUS_WEIGHT("bb_pr_part_status_weight", DatabaseTableAttribute.PREPOPULATED),
    STA_PR_PARTICIPANT("sta_pr_participant", new DatabaseTableAttribute[0]),
    STA_DRIFT_REQUEST("sta_drift_request", new DatabaseTableAttribute[0]),
    STA_ACTIVITY("sta_activity", new DatabaseTableAttribute[0]),
    STA_REPO_ACTIVITY("sta_repo_activity", new DatabaseTableAttribute[0]),
    STA_REPO_ORIGIN("sta_repo_origin", new DatabaseTableAttribute[0]),
    STA_REPO_CREATED_ACTIVITY("sta_repo_created_activity", new DatabaseTableAttribute[0]),
    STA_REPO_PUSH_ACTIVITY("sta_repo_push_activity", new DatabaseTableAttribute[0]),
    STA_REPO_UPDATED_ACTIVITY("sta_repo_updated_activity", new DatabaseTableAttribute[0]),
    STA_REPO_PUSH_REF("sta_repo_push_ref", new DatabaseTableAttribute[0]),
    STA_CMT_DISC_ACTIVITY("sta_cmt_disc_activity", new DatabaseTableAttribute[0]),
    BB_CMT_DISC_COMMENT_ACTIVITY("bb_cmt_disc_comment_activity", new DatabaseTableAttribute[0]),
    STA_PR_ACTIVITY("sta_pr_activity", new DatabaseTableAttribute[0]),
    BB_PR_COMMENT_ACTIVITY("bb_pr_comment_activity", new DatabaseTableAttribute[0]),
    STA_PR_MERGE_ACTIVITY("sta_pr_merge_activity", new DatabaseTableAttribute[0]),
    STA_PR_RESCOPE_ACTIVITY("sta_pr_rescope_activity", new DatabaseTableAttribute[0]),
    STA_PR_RESCOPE_COMMITS("sta_pr_rescope_commit", new DatabaseTableAttribute[0]),
    STA_PR_RESCOPE_REQUEST("sta_pr_rescope_request", new DatabaseTableAttribute[0]),
    STA_PR_RESCOPE_REQUEST_CHANGE("sta_pr_rescope_request_change", new DatabaseTableAttribute[0]),
    BB_PR_REVIEWERS_UPDATED_ACTIVITY("bb_pr_reviewer_upd_activity", new DatabaseTableAttribute[0]),
    BB_PR_REVIEWERS_ADDED("bb_pr_reviewer_added", new DatabaseTableAttribute[0]),
    BB_PR_REVIEWERS_REMOVED("bb_pr_reviewer_removed", new DatabaseTableAttribute[0]),
    BB_PR_COMMIT("bb_pr_commit", new DatabaseTableAttribute[0]),
    BB_PR_TEMPLATE("bb_pull_request_template", new DatabaseTableAttribute[0]),
    STA_WATCHER("sta_watcher", new DatabaseTableAttribute[0]),
    STA_DELETED_GROUP("sta_deleted_group", new DatabaseTableAttribute[0]),
    BB_CLUSTEREDJOB("bb_clusteredjob", new DatabaseTableAttribute[0]),
    BB_GIT_PULL_REQUEST_CACHED_ANCESTOR("bb_git_pr_common_ancestor", new DatabaseTableAttribute[0]),
    BB_GIT_PULL_REQUEST_CACHED_MERGE("bb_git_pr_cached_merge", new DatabaseTableAttribute[0]),
    BB_HOOK_SCRIPT("bb_hook_script", new DatabaseTableAttribute[0]),
    BB_HOOK_SCRIPT_CONFIG("bb_hook_script_config", new DatabaseTableAttribute[0]),
    BB_HOOK_SCRIPT_TRIGGER("bb_hook_script_trigger", new DatabaseTableAttribute[0]),
    BB_INTEGRITY_EVENT("bb_integrity_event", new DatabaseTableAttribute[0]),
    BB_MERGE_QUEUE("bb_merge_queue", new DatabaseTableAttribute[0]),
    BB_MERGE_QUEUE_SETTINGS("bb_merge_queue_settings", new DatabaseTableAttribute[0]),
    BB_MESH_MIGRATION_JOB("bb_mesh_migration_job", new DatabaseTableAttribute[0]),
    BB_MESH_MIGRATION_QUEUE("bb_mesh_migration_queue", new DatabaseTableAttribute[0]),
    BB_MESH_NODE("bb_mesh_node", new DatabaseTableAttribute[0]),
    BB_MESH_NODE_KEY("bb_mesh_node_key", new DatabaseTableAttribute[0]),
    BB_MESH_PARTITION_MIGRATION("bb_mesh_partition_migration", new DatabaseTableAttribute[0]),
    BB_MESH_PARTITION_REPLICA("bb_mesh_partition_replica", new DatabaseTableAttribute[0]),
    BB_MESH_SIGNING_KEY("bb_mesh_signing_key", new DatabaseTableAttribute[0]),
    BB_MESH_REPO_REPLICA("bb_mesh_repo_replica", new DatabaseTableAttribute[0]),
    BB_MIRROR_CONTENT_HASH("bb_mirror_content_hash", new DatabaseTableAttribute[0]),
    BB_MIRROR_METADATA_HASH("bb_mirror_metadata_hash", new DatabaseTableAttribute[0]),
    BB_PROJ_MERGE_CONFIG("bb_proj_merge_config", new DatabaseTableAttribute[0]),
    BB_PROJ_MERGE_STRATEGY("bb_proj_merge_strategy", new DatabaseTableAttribute[0]),
    BB_RL_REJECT_COUNTER("bb_rl_reject_counter", new DatabaseTableAttribute[0]),
    BB_REPO_MERGE_CONFIG("bb_repo_merge_config", new DatabaseTableAttribute[0]),
    BB_REPO_MERGE_STRATEGY("bb_repo_merge_strategy", new DatabaseTableAttribute[0]),
    BB_SCM_MERGE_CONFIG("bb_scm_merge_config", new DatabaseTableAttribute[0]),
    BB_SCM_MERGE_STRATEGY("bb_scm_merge_strategy", new DatabaseTableAttribute[0]),
    BB_ALERT("bb_alert", new DatabaseTableAttribute[0]),
    BB_LABEL("bb_label", new DatabaseTableAttribute[0]),
    BB_LABEL_MAPPING("bb_label_mapping", new DatabaseTableAttribute[0]),
    BB_JOB("bb_job", new DatabaseTableAttribute[0]),
    BB_JOB_MESSAGE("bb_job_message", new DatabaseTableAttribute[0]),
    BB_USER_DARK_FEATURE("bb_user_dark_feature", new DatabaseTableAttribute[0]),
    BB_RL_USER_SETTINGS("bb_rl_user_settings", new DatabaseTableAttribute[0]),
    BB_ANNOUNCEMENT_BANNER("bb_announcement_banner", new DatabaseTableAttribute[0]),
    BB_SUGGESTION_GROUP("bb_suggestion_group", new DatabaseTableAttribute[0]),
    BB_ATTACHMENT("bb_attachment", new DatabaseTableAttribute[0]),
    BB_ATTACHMENT_METADATA("bb_attachment_metadata", new DatabaseTableAttribute[0]),
    BB_BUILD_STATUS("bb_build_status", new DatabaseTableAttribute[0]),
    BB_AUTO_DECLINE_SETTINGS("bb_auto_decline_settings", new DatabaseTableAttribute[0]),
    BB_EMOTICON("bb_emoticon", DatabaseTableAttribute.PREPOPULATED),
    BB_REVIEWER_GROUP("bb_reviewer_group", new DatabaseTableAttribute[0]),
    BB_REVIEWER_GROUP_USER("bb_reviewer_group_user", new DatabaseTableAttribute[0]),
    BB_REPO_SIZE("bb_repo_size", new DatabaseTableAttribute[0]),
    BB_DEPLOYMENT("bb_deployment", new DatabaseTableAttribute[0]),
    BB_DEPLOYED_COMMIT("bb_dep_commit", new DatabaseTableAttribute[0]),
    BB_SECRET_SCAN_RULES("bb_secret_scan_rule", DatabaseTableAttribute.PREPOPULATED),
    BB_SECRET_SCAN_EXEMPT_REPOS("bb_ss_exempt_repo", new DatabaseTableAttribute[0]),
    BB_SECRET_SCAN_ALLOW_LIST_RULES("bb_secret_allowlist_rule", new DatabaseTableAttribute[0]),
    BB_PROJECT_SETTINGS_RESTRICTION("bb_settings_restriction", new DatabaseTableAttribute[0]),
    BB_AUTO_MERGE_SETTINGS("bb_auto_merge_settings", new DatabaseTableAttribute[0]),
    BB_AUTO_MERGE_REQUEST("bb_auto_merge_request", new DatabaseTableAttribute[0]),
    BB_PR_AUTO_MERGE_CANCELLED_ACTIVITY("bb_pr_am_cancelled_activity", new DatabaseTableAttribute[0]),
    BB_X509_CERTIFICATE("bb_x509_certificate", new DatabaseTableAttribute[0]),
    BB_X509_REVOKED_CERTIFICATE("bb_x509_revoked_certificate", new DatabaseTableAttribute[0]),
    BB_PR_PHASE_ACTIVITY("bb_pr_phase_activity", new DatabaseTableAttribute[0]),
    BB_SEALED_SECRET("bb_sealed_secret", new DatabaseTableAttribute[0]);

    private static final Map<String, DatabaseTable> NAME_TO_TABLE_MAP;
    private final Set<DatabaseTableAttribute> attributes;
    private final String orderingColumn;
    private final String tableName;

    private DatabaseTable(String tableName, DatabaseTableAttribute ... attributes) {
        this(tableName, (String)null, attributes);
    }

    private DatabaseTable(String tableName, String orderingColumn, DatabaseTableAttribute ... attributes) {
        this.tableName = tableName.toLowerCase(Locale.US);
        this.orderingColumn = orderingColumn;
        this.attributes = attributes.length > 0 ? EnumSet.copyOf(ImmutableSet.copyOf((Object[])attributes)) : Collections.emptySet();
    }

    public String getOrderingColumn() {
        return this.orderingColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public static List<String> getTableNames() {
        return Chainable.chain(DatabaseTable.getTables()).transform(DatabaseTable::getTableName).toList();
    }

    public static List<String> getTableNames(DatabaseTableAttribute first, DatabaseTableAttribute ... rest) {
        return Chainable.chain(DatabaseTable.getTables()).filter(DatabaseTable.with(first, rest)).transform(DatabaseTable::getTableName).toList();
    }

    public static List<DatabaseTable> getTables() {
        return ImmutableList.copyOf((Object[])DatabaseTable.values());
    }

    public static boolean isKnownTable(String tableName) {
        return NAME_TO_TABLE_MAP.containsKey(tableName);
    }

    private static Map<String, DatabaseTable> buildNameToTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DatabaseTable table : DatabaseTable.values()) {
            builder.put((Object)table.getTableName(), (Object)table);
        }
        return builder.build();
    }

    private static Predicate<DatabaseTable> with(DatabaseTableAttribute first, DatabaseTableAttribute ... rest) {
        EnumSet<DatabaseTableAttribute[]> desired = EnumSet.of(first, rest);
        return input -> input.attributes.containsAll(desired);
    }

    static {
        NAME_TO_TABLE_MAP = DatabaseTable.buildNameToTableMap();
    }
}

