/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class CommentSearchCriteria {
    private final CommentThreadDiffAnchorState anchorState;
    private final InternalApplicationUser author;
    private final InternalCommentable commentable;
    private final Set<CommentThreadDiffAnchorType> diffTypes;
    private final String fromHash;
    private final boolean omitPendingComments;
    private final String path;
    private final InternalApplicationUser pendingAuthor;
    private final Set<CommentSeverity> severities;
    private final Set<CommentState> states;
    private final String toHash;

    private CommentSearchCriteria(@Nonnull Builder builder) {
        this.anchorState = builder.anchorState;
        this.author = builder.author;
        this.commentable = builder.commentable;
        this.diffTypes = builder.diffTypes.build();
        this.fromHash = builder.fromHash;
        this.omitPendingComments = builder.omitPendingComments;
        this.path = builder.path;
        this.pendingAuthor = builder.pendingAuthor;
        this.severities = builder.severities.build();
        this.states = builder.states.build();
        this.toHash = builder.toHash;
    }

    @Nonnull
    public CommentThreadDiffAnchorState getAnchorState() {
        return this.anchorState;
    }

    @Nonnull
    public Optional<InternalApplicationUser> getAuthor() {
        return Optional.ofNullable(this.author);
    }

    @Nonnull
    public InternalCommentable getCommentable() {
        return this.commentable;
    }

    @Nonnull
    public Set<CommentThreadDiffAnchorType> getDiffTypes() {
        return this.diffTypes;
    }

    @Nonnull
    public Optional<String> getFromHash() {
        return Optional.ofNullable(this.fromHash);
    }

    @Nonnull
    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    @Nonnull
    public Optional<InternalApplicationUser> getPendingAuthor() {
        return Optional.ofNullable(this.pendingAuthor);
    }

    @Nonnull
    public Set<CommentSeverity> getSeverities() {
        return this.severities;
    }

    @Nonnull
    public Set<CommentState> getStates() {
        return this.states;
    }

    @Nonnull
    public Optional<String> getToHash() {
        return Optional.ofNullable(this.toHash);
    }

    public boolean hasDiffTypes() {
        return !this.diffTypes.isEmpty();
    }

    public boolean hasSeverities() {
        return !this.severities.isEmpty();
    }

    public boolean hasStates() {
        return !this.states.isEmpty();
    }

    public boolean omitPendingComments() {
        return this.omitPendingComments;
    }

    public static class Builder
    extends BuilderSupport {
        private final InternalCommentable commentable;
        private final ImmutableSet.Builder<CommentThreadDiffAnchorType> diffTypes;
        private final ImmutableSet.Builder<CommentSeverity> severities;
        private final ImmutableSet.Builder<CommentState> states;
        private CommentThreadDiffAnchorState anchorState;
        private InternalApplicationUser author;
        private String fromHash;
        private boolean omitPendingComments;
        private String path;
        private InternalApplicationUser pendingAuthor;
        private String toHash;

        public Builder(@Nonnull InternalCommentable commentable) {
            this.commentable = Objects.requireNonNull(commentable, "commentable");
            this.anchorState = CommentThreadDiffAnchorState.ACTIVE;
            this.diffTypes = ImmutableSet.builder();
            this.severities = ImmutableSet.builder();
            this.states = ImmutableSet.builder();
        }

        public Builder(@Nonnull CommentSearchCriteria commentSearchCriteria) {
            this(Objects.requireNonNull(commentSearchCriteria, (String)"commentSearchCriteria").commentable);
            this.anchorState = commentSearchCriteria.anchorState;
            this.author = commentSearchCriteria.author;
            this.fromHash = commentSearchCriteria.fromHash;
            this.path = commentSearchCriteria.path;
            this.pendingAuthor = commentSearchCriteria.pendingAuthor;
            this.toHash = commentSearchCriteria.toHash;
            this.diffTypes(commentSearchCriteria.diffTypes);
            this.severities(commentSearchCriteria.severities);
            this.states(commentSearchCriteria.states);
        }

        @Nonnull
        public Builder anchorState(@Nonnull CommentThreadDiffAnchorState value) {
            this.anchorState = Objects.requireNonNull(value, "anchorState");
            return this;
        }

        @Nonnull
        public Builder author(@Nullable InternalApplicationUser value) {
            this.author = value;
            return this;
        }

        @Nonnull
        public CommentSearchCriteria build() {
            return new CommentSearchCriteria(this);
        }

        @Nonnull
        public Builder diffType(@Nullable CommentThreadDiffAnchorType value) {
            Builder.addIf(Objects::nonNull, this.diffTypes, (Object)value);
            return this;
        }

        @Nonnull
        public Builder diffTypes(@Nullable Iterable<CommentThreadDiffAnchorType> values) {
            Builder.addIf(Objects::nonNull, this.diffTypes, values);
            return this;
        }

        @Nonnull
        public Builder fromHash(@Nullable String value) {
            this.fromHash = value;
            return this;
        }

        @Nonnull
        public Builder omitPendingComments() {
            this.omitPendingComments = true;
            return this;
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Nonnull
        public Builder pendingAuthor(@Nonnull InternalApplicationUser value) {
            this.pendingAuthor = value;
            return this;
        }

        @Nonnull
        public Builder severities(@Nullable Iterable<CommentSeverity> values) {
            Builder.addIf(Objects::nonNull, this.severities, values);
            return this;
        }

        @Nonnull
        public Builder severity(@Nullable CommentSeverity value) {
            Builder.addIf(Objects::nonNull, this.severities, (Object)value);
            return this;
        }

        @Nonnull
        public Builder state(@Nullable CommentState value) {
            Builder.addIf(Objects::nonNull, this.states, (Object)value);
            return this;
        }

        @Nonnull
        public Builder states(@Nullable Iterable<CommentState> values) {
            Builder.addIf(Objects::nonNull, this.states, values);
            return this;
        }

        @Nonnull
        public Builder toHash(@Nullable String value) {
            this.toHash = value;
            return this;
        }
    }
}

