/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.stash.internal.comment.AbstractDiffCommentAnchorSearchCriteria;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class CommitDiscussionAnchorSearchCriteria
extends AbstractDiffCommentAnchorSearchCriteria {
    private final InternalCommitDiscussion discussion;
    private final String fromHash;
    private final Long pullRequestScopedId;
    private final String toHash;

    protected CommitDiscussionAnchorSearchCriteria(Builder builder) {
        super(builder);
        this.discussion = builder.discussion;
        this.fromHash = builder.fromHash == null ? this.discussion.getParentId() : builder.fromHash;
        this.pullRequestScopedId = builder.pullRequestScopedId;
        this.toHash = builder.toHash;
    }

    @Nonnull
    public InternalCommitDiscussion getDiscussion() {
        return this.discussion;
    }

    @Nonnull
    public Optional<String> getFromHash() {
        return Optional.ofNullable(this.fromHash);
    }

    @Nonnull
    public Optional<Long> getPullRequestScopedId() {
        return Optional.ofNullable(this.pullRequestScopedId);
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    public static class Builder
    extends AbstractDiffCommentAnchorSearchCriteria.AbstractBuilder<Builder, CommitDiscussionAnchorSearchCriteria> {
        private final InternalCommitDiscussion discussion;
        private final String toHash;
        private String fromHash;
        private Long pullRequestScopedId;

        public Builder(@Nonnull InternalCommitDiscussion value) {
            this.discussion = Objects.requireNonNull(value, "discussion");
            this.toHash = this.discussion.getCommitId();
        }

        @Override
        @Nonnull
        public CommitDiscussionAnchorSearchCriteria build() {
            return new CommitDiscussionAnchorSearchCriteria(this);
        }

        @Nonnull
        public Builder fromHash(@Nullable String value) {
            this.fromHash = value;
            return this.self();
        }

        @Nonnull
        public Builder pullRequestScopedId(@Nullable Long value) {
            this.pullRequestScopedId = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

