/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.springframework.jdbc.datasource.AbstractDriverBasedDataSource;
import org.springframework.util.ClassUtils;

public enum DbType {
    MSSQL("mssql", "jdbc:sqlserver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", false, 1433){

        @Override
        @Nonnull
        public String generateUrl(@Nonnull String hostName, @Nonnull String database, int port) {
            return String.format("%1$s://%2$s:%3$d;databaseName=%4$s;encrypt=false;", this.getProtocol(), hostName, port, database);
        }
    }
    ,
    ORACLE("oracle", "jdbc:oracle:thin", "oracle.jdbc.OracleDriver", true, 1521){

        @Override
        @Nonnull
        public String generateUrl(@Nonnull String hostName, @Nonnull String service, int port) {
            return String.format("%1$s:@//%2$s:%3$d/%4$s", this.getProtocol(), hostName, port, service);
        }

        @Override
        @Nonnull
        public Map<String, String> getPropertyMap(Duration timeout) {
            return ImmutableMap.of((Object)"oracle.net.CONNECT_TIMEOUT", (Object)String.valueOf(timeout.toMillis()));
        }
    }
    ,
    POSTGRES("postgres", "jdbc:postgresql", "org.postgresql.Driver", false, 5432){

        @Override
        @Nonnull
        public String generateUrl(@Nonnull String hostName, @Nonnull String database, int port) {
            return String.format("%1$s://%2$s:%3$d/%4$s?targetServerType=master", this.getProtocol(), hostName, port, database);
        }
    };

    public static final List<DbType> AS_LIST;
    private static final Map<String, DbType> ENUM_BY_DRIVER;
    private static final Map<String, DbType> ENUM_BY_KEY;
    private static final String BITBUCKET_DB_MIGRATION_HELP_KEY = "bitbucket.help.db.migration.";
    private final int defaultPort;
    private final String displayNameKey;
    private final String driverClassName;
    private final String key;
    private final String protocol;
    private final boolean usesSid;

    private DbType(String key, String protocol, String driverClassName, boolean usesSid, int defaultPort) {
        this.defaultPort = defaultPort;
        this.driverClassName = driverClassName;
        this.key = key;
        this.protocol = protocol;
        this.usesSid = usesSid;
        this.displayNameKey = "com.atlassian.bitbucket.database.display.name." + key;
    }

    @Nonnull
    public static Optional<DbType> forDriver(@Nonnull String driverClassName) {
        Objects.requireNonNull(driverClassName, "driverClassName");
        return Optional.ofNullable(ENUM_BY_DRIVER.get(driverClassName));
    }

    @Nonnull
    public static Optional<DbType> forKey(@Nonnull String key) {
        Objects.requireNonNull(key, "key");
        return Optional.ofNullable(ENUM_BY_KEY.get(key));
    }

    public static boolean isInternal(@Nonnull String driverClassName) {
        return driverClassName.startsWith("org.h2") || driverClassName.startsWith("org.hsqldb");
    }

    public void applyTimeout(AbstractDriverBasedDataSource dataSource, Duration timeout) {
        this.setDataSourceProperties(this.getPropertyMap(timeout), dataSource);
    }

    @Nonnull
    public abstract String generateUrl(@Nonnull String var1, @Nonnull String var2, int var3);

    public int getDefaultPort() {
        return this.defaultPort;
    }

    @Nonnull
    public String getDisplayNameKey() {
        return this.displayNameKey;
    }

    @Nonnull
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Nonnull
    public String getHelpKey() {
        return BITBUCKET_DB_MIGRATION_HELP_KEY + this.getKey();
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Map<String, String> getPropertyMap(Duration timeout) {
        return ImmutableMap.of((Object)"loginTimeout", (Object)String.valueOf(timeout.toSeconds()));
    }

    @Nonnull
    public String getProtocol() {
        return this.protocol;
    }

    public boolean isDriverAvailable() {
        return ClassUtils.isPresent((String)this.driverClassName, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    public boolean usesSid() {
        return this.usesSid;
    }

    private static Map<String, DbType> mapByDriver() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DbType t : DbType.values()) {
            builder.put((Object)t.getDriverClassName(), (Object)t);
        }
        return builder.build();
    }

    private static Map<String, DbType> mapByKey() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DbType t : DbType.values()) {
            builder.put((Object)t.getKey(), (Object)t);
        }
        return builder.build();
    }

    private void setDataSourceProperties(Map<String, String> pairs, AbstractDriverBasedDataSource dataSource) {
        Properties connectionProperties = dataSource.getConnectionProperties();
        if (connectionProperties == null) {
            connectionProperties = new Properties();
        }
        connectionProperties.putAll(pairs);
        dataSource.setConnectionProperties(connectionProperties);
    }

    static {
        AS_LIST = ImmutableList.copyOf((Object[])DbType.values());
        ENUM_BY_DRIVER = DbType.mapByDriver();
        ENUM_BY_KEY = DbType.mapByKey();
    }
}

