/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.application.InternalApplicationDefaultGroupMembershipConfiguration;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.permission.GroupAdministrationGrantToGroup;
import com.atlassian.crowd.model.permission.UserAdministrationGrantToGroup;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.webhook.WebhookImpl;
import com.atlassian.stash.internal.activity.InternalActivity;
import com.atlassian.stash.internal.attachment.InternalAttachment;
import com.atlassian.stash.internal.attachment.InternalAttachmentMetadata;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionParticipant;
import com.atlassian.stash.internal.darkfeature.InternalUserDarkFeature;
import com.atlassian.stash.internal.emoticon.InternalEmoticon;
import com.atlassian.stash.internal.hook.script.InternalHookScript;
import com.atlassian.stash.internal.hook.script.InternalHookScriptConfig;
import com.atlassian.stash.internal.integrity.InternalIntegrityEvent;
import com.atlassian.stash.internal.merge.InternalProjectMergeConfig;
import com.atlassian.stash.internal.merge.InternalRepositoryMergeConfig;
import com.atlassian.stash.internal.merge.InternalScmMergeConfig;
import com.atlassian.stash.internal.mergequeue.InternalMergeQueueSettings;
import com.atlassian.stash.internal.mesh.InternalMeshNode;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionMigration;
import com.atlassian.stash.internal.plugin.PluginSetting;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipantStatusType;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestReviewersUpdatedActivity;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeRequest;
import com.atlassian.stash.internal.pull.automerge.InternalAutoMergeSettings;
import com.atlassian.stash.internal.pull.reviewer.InternalReviewerGroup;
import com.atlassian.stash.internal.pull.template.InternalPullRequestTemplate;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryHook;
import com.atlassian.stash.internal.repository.InternalRepositoryPushActivity;
import com.atlassian.stash.internal.repository.InternalRepositorySize;
import com.atlassian.stash.internal.scheduling.InternalClusteredJob;
import com.atlassian.stash.internal.secrets.InternalSealedSecret;
import com.atlassian.stash.internal.secretscanning.InternalSecretScanningAllowlistRule;
import com.atlassian.stash.internal.secretscanning.InternalSecretScanningExemptRepository;
import com.atlassian.stash.internal.secretscanning.InternalSecretScanningRule;
import com.atlassian.stash.internal.server.InternalDataStore;
import com.atlassian.stash.internal.settingsrestriction.InternalProjectSettingsRestriction;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalPermissionType;
import com.atlassian.stash.internal.user.InternalUserSettings;
import com.atlassian.stash.internal.watcher.InternalWatcherMapping;
import jakarta.annotation.Nonnull;
import org.springframework.util.ReflectionUtils;

public enum EntityCache {
    BB_ACTIVITY(InternalActivity.class, false),
    BB_APPLICATION_USER(InternalApplicationUser.class),
    BB_ATTACHMENT(InternalAttachment.class),
    BB_ATTACHMENT_METADATA(InternalAttachmentMetadata.class),
    BB_AUTO_MERGE_REQUEST(InternalAutoMergeRequest.class),
    BB_AUTO_MERGE_SETTINGS(InternalAutoMergeSettings.class),
    BB_CLUSTERED_JOB(InternalClusteredJob.class),
    BB_COMMENT(InternalComment.class),
    BB_COMMENT$COMMENTS(InternalComment.class, "comments"),
    BB_COMMENT_THREAD(InternalCommentThread.class),
    BB_COMMIT_DISCUSSION(InternalCommitDiscussion.class, false),
    BB_COMMIT_DISCUSSION$PARTICIPANTS(InternalCommitDiscussion.class, "participants", false),
    BB_COMMIT_DISCUSSION_PARTICIPANT(InternalCommitDiscussionParticipant.class),
    BB_DATA_STORE(InternalDataStore.class),
    BB_DEP("com.atlassian.bitbucket.internal.deployments.model.InternalDeployment"),
    BB_DEP_COMMIT("com.atlassian.bitbucket.internal.deployments.model.InternalDeployedCommit"),
    BB_EMOTICON(InternalEmoticon.class),
    BB_HOOK_SCRIPT(InternalHookScript.class),
    BB_HOOK_SCRIPT_CONFIG(InternalHookScriptConfig.class),
    BB_HOOK_SCRIPT_CONFIG$TRIGGER_IDS(InternalHookScriptConfig.class, "triggerIds"),
    BB_INTEGRITY_EVENT(InternalIntegrityEvent.class),
    BB_LABEL("com.atlassian.bitbucket.internal.label.model.InternalLabel"),
    BB_LABEL_MAPPING("com.atlassian.bitbucket.internal.label.model.InternalLabelMapping"),
    BB_MERGE_QUEUE_SETTINGS(InternalMergeQueueSettings.class),
    BB_MESH_NODE(InternalMeshNode.class),
    BB_MESH_PARTITION_MIGRATION(InternalMeshPartitionMigration.class),
    BB_PERMISSION_TYPE(InternalPermissionType.class),
    BB_PLUGIN_SETTING(PluginSetting.class),
    BB_PROJECT(InternalProject.class),
    BB_PROJECT_MERGE_CONFIG(InternalProjectMergeConfig.class),
    BB_PROJECT_MERGE_CONFIG$STRATEGY_IDS(InternalProjectMergeConfig.class, "strategyIds"),
    BB_PROJECT_SETTINGS_RESTRICTION(InternalProjectSettingsRestriction.class),
    BB_PULL_REQUEST(InternalPullRequest.class, false),
    BB_PULL_REQUEST$PARTICIPANTS(InternalPullRequest.class, "participants", false),
    BB_PULL_REQUEST_PARTICIPANT(InternalPullRequestParticipant.class),
    BB_PULL_REQUEST_PARTICIPANT_STATUS_TYPE(InternalPullRequestParticipantStatusType.class),
    BB_PULL_REQUEST_RESCOPE_ACTIVITY$COMMITS(InternalPullRequestRescopeActivity.class, "commits", false),
    BB_PULL_REQUEST_REVIEWERS_UPDATED_ACTIVITY$ADDED_REVIEWERS(InternalPullRequestReviewersUpdatedActivity.class, "addedReviewers", false),
    BB_PULL_REQUEST_REVIEWERS_UPDATED_ACTIVITY$REMOVED_REVIEWERS(InternalPullRequestReviewersUpdatedActivity.class, "removedReviewers", false),
    BB_PULL_REQUEST_TEMPLATE(InternalPullRequestTemplate.class),
    BB_REPOSITORY(InternalRepository.class),
    BB_REPOSITORY_HOOK(InternalRepositoryHook.class, false),
    BB_REPOSITORY_MERGE_CONFIG(InternalRepositoryMergeConfig.class),
    BB_REPOSITORY_MERGE_CONFIG$STRATEGY_IDS(InternalRepositoryMergeConfig.class, "strategyIds"),
    BB_REPOSITORY_PUSH_ACTIVITY$REF_CHANGES(InternalRepositoryPushActivity.class, "refChanges", false),
    BB_REPOSITORY_SIZE(InternalRepositorySize.class),
    BB_REVIEWER_GROUP(InternalReviewerGroup.class),
    BB_REVIEWER_GROUP$USERS(InternalReviewerGroup.class, "users"),
    BB_SEALED_SECRET(InternalSealedSecret.class),
    BB_SECRET_SCAN_ALLOWLIST_RULES(InternalSecretScanningAllowlistRule.class),
    BB_SECRET_SCAN_EXEMPT_REPOS(InternalSecretScanningExemptRepository.class),
    BB_SECRET_SCAN_RULES(InternalSecretScanningRule.class),
    BB_SCM_MERGE_CONFIG(InternalScmMergeConfig.class),
    BB_SCM_MERGE_CONFIG$STRATEGY_IDS(InternalScmMergeConfig.class, "strategyIds"),
    BB_USER_DARK_FEATURE(InternalUserDarkFeature.class),
    BB_USER_SETTINGS(InternalUserSettings.class),
    BB_WATCHER_MAPPING(InternalWatcherMapping.class),
    BB_X509_CERTIFICATE("com.atlassian.bitbucket.internal.x509.model.InternalX509Certificate"),
    BB_X509_REVOKED_CERTIFICATE("com.atlassian.bitbucket.internal.x509.model.InternalX509RevokedCertificate"),
    CWD_APPLICATION(ApplicationImpl.class),
    CWD_APPLICATION$ATTRIBUTES(ApplicationImpl.class, "attributes"),
    CWD_APPLICATION$DIRECTORY_MAPPINGS(ApplicationImpl.class, "directoryMappings"),
    CWD_APPLICATION$REMOTE_ADDRESSES(ApplicationImpl.class, "remoteAddresses"),
    CWD_APPLICATION$WEBHOOKS(ApplicationImpl.class, "webhooks"),
    CWD_APPLICATION_DEFAULT_GROUP_MEMBERSHIP_CONFIGURATION(InternalApplicationDefaultGroupMembershipConfiguration.class),
    CWD_DIRECTORY(DirectoryImpl.class),
    CWD_DIRECTORY$ALLOWED_OPERATIONS(DirectoryImpl.class, "allowedOperations"),
    CWD_DIRECTORY$ATTRIBUTES(DirectoryImpl.class, "attributes"),
    CWD_DIRECTORY_MAPPING(DirectoryMapping.class),
    CWD_DIRECTORY_MAPPING$AUTHORISED_GROUPS(DirectoryMapping.class, "authorisedGroups"),
    CWD_DIRECTORY_MAPPING$ALLOWED_OPERATIONS(DirectoryMapping.class, "allowedOperations"),
    CWD_GROUP_ADMINISTRATION_GRANT_TO_GROUP(GroupAdministrationGrantToGroup.class),
    CWD_GROUP_MAPPING(GroupMapping.class),
    CWD_GROUP(InternalGroup.class),
    CWD_GROUP$GRANTS_TO_OTHER_GROUPS(InternalGroup.class, "grantsToOtherGroups"),
    CWD_GROUP$GROUP_GRANTS_TO_THIS_GROUP(InternalGroup.class, "groupGrantsToThisGroup"),
    CWD_GROUP$USER_GRANTS_TO_THIS_GROUP(InternalGroup.class, "userGrantsToThisGroup"),
    CWD_PROPERTY(Property.class),
    CWD_USER_ATTRIBUTE(InternalUserAttribute.class),
    CWD_USER(InternalUser.class),
    CWD_USER$ATTRIBUTES(InternalUser.class, "attributes"),
    CWD_USER$CREDENTIAL_RECORDS(InternalUser.class, "credentialRecords"),
    CWD_USER$GROUP_GRANTS(InternalUser.class, "groupGrants"),
    CWD_USER_ADMINISTRATION_GRANT_TO_GROUP(UserAdministrationGrantToGroup.class),
    CWD_WEBHOOK_IMPL(WebhookImpl.class),
    NATURAL_PROJECT_MERGE_CONFIG(InternalProjectMergeConfig.class.getName() + "##NaturalId"),
    NATURAL_REPOSITORY_MERGE_CONFIG(InternalRepositoryMergeConfig.class.getName() + "##NaturalId"),
    NATURAL_SCM_MERGE_CONFIG(InternalScmMergeConfig.class.getName() + "##NaturalId"),
    NATURAL_PLUGIN_SETTING(PluginSetting.class.getName() + "##NaturalId"),
    QUERY_AUTO_MERGE_SETTINGS_BY_SCOPE("query.autoMergeSettingsByScope"),
    QUERY_CWD_USER_BY_DIRECTORY("query.cwdUserByDirectory"),
    QUERY_GROUP_MEMBERSHIPS("query.groupMemberships"),
    QUERY_MERGE_QUEUE_SETTINGS_BY_SCOPE("query.mergeQueueSettingsByScope"),
    QUERY_PERMISSIONS("query.permissions"),
    QUERY_PROJECTS("query.projects"),
    QUERY_PUBLIC_REPOSITORY_COUNT("query.publicRepositoryCountByProject"),
    QUERY_PULL_REQUEST_COUNT("query.pullRequestCountByUser"),
    QUERY_PULL_REQUEST_PARTICIPANT_USERS("query.pullRequestParticipantUsers"),
    QUERY_REPOSITORIES_BY_HIERARCHY("query.repositoriesByHierarchy"),
    QUERY_REPOSITORY_BY_SLUG("query.repositoryBySlug");

    private final String name;
    private final boolean nearCacheable;

    private EntityCache(Class<?> entityClass) {
        this(entityClass, true);
    }

    private EntityCache(Class<?> entityClass, boolean nearCacheable) {
        this(entityClass.getName(), nearCacheable);
    }

    private EntityCache(Class<?> entityClass, String field) {
        this(entityClass, field, true);
    }

    private EntityCache(Class<?> entityClass, String field, boolean nearCacheable) {
        this(EntityCache.qualifyField(entityClass, field), nearCacheable);
    }

    private EntityCache(String name) {
        this(name, true);
    }

    private EntityCache(String name, boolean nearCacheable) {
        this.name = name;
        this.nearCacheable = nearCacheable;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isNearCacheable() {
        return this.nearCacheable;
    }

    private static String qualifyField(Class<?> entityClass, String field) {
        if (ReflectionUtils.findField(entityClass, (String)field) == null) {
            throw new IllegalStateException(entityClass.getName() + " has no  field.");
        }
        return entityClass.getName() + "." + field;
    }
}

