/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageImpl;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.query.Query;

public class HibernatePageUtils
extends PageUtils {
    private static final int MINIMUM_FETCH_SIZE = 25;

    private HibernatePageUtils() {
    }

    public static <T> ScrollableResults createScrollableFromQuery(Query<T> query, PageRequest pageRequest) {
        int start = pageRequest.getStart();
        return query.setFirstResult(start).setMaxResults(HibernatePageUtils.getScrollMaxResults(start)).setFetchSize(HibernatePageUtils.getScrollFetchSize(pageRequest)).setCacheMode(CacheMode.GET).scroll(ScrollMode.FORWARD_ONLY);
    }

    public static <T> Page<T> pageQuery(Query<T> query, PageRequest pageRequest, Predicate<? super T> predicate) {
        ScrollableResults scroll = HibernatePageUtils.createScrollableFromQuery(query, pageRequest);
        return HibernatePageUtils.fillPage(scroll, predicate, pageRequest);
    }

    public static <T> Page<T> pageQuery(Query<T> query, PageRequest pageRequest) {
        List values = query.setFirstResult(pageRequest.getStart()).setMaxResults(HibernatePageUtils.getRowLimit(pageRequest)).list();
        return HibernatePageUtils.createPage((Iterable)values, (PageRequest)pageRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Page<T> fillPage(ScrollableResults scroll, Predicate<? super T> predicate, PageRequest request) {
        int limit = request.getLimit();
        int rowIndex = request.getStart();
        boolean lastPage = true;
        ArrayList<Object> page = new ArrayList<Object>(limit);
        try {
            while (scroll.next()) {
                Object row = scroll.get(0);
                if (predicate.test(row)) {
                    if (page.size() == limit) {
                        lastPage = false;
                        break;
                    }
                    page.add(row);
                }
                ++rowIndex;
            }
        }
        finally {
            scroll.close();
        }
        return new PageImpl(request, page, lastPage, page.size(), lastPage ? -1 : rowIndex);
    }

    private static int getRowLimit(int limit) {
        return limit == Integer.MAX_VALUE ? limit : limit + 1;
    }

    private static int getRowLimit(PageRequest pageRequest) {
        return HibernatePageUtils.getRowLimit(pageRequest.getLimit());
    }

    private static int getScrollFetchSize(PageRequest pageRequest) {
        return Math.max(HibernatePageUtils.getRowLimit(pageRequest), 25);
    }

    private static int getScrollMaxResults(int start) {
        return Integer.MAX_VALUE - start - 1;
    }
}

