/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.scope.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class HookScriptConfigCriteria {
    private final Scope scope;
    private final HookScriptType type;

    private HookScriptConfigCriteria(Builder builder) {
        this.scope = builder.scope;
        this.type = builder.type;
    }

    @Nonnull
    public static HookScriptConfigCriteria forScope(@Nonnull Scope scope) {
        return new Builder(scope).build();
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Nullable
    public HookScriptType getType() {
        return this.type;
    }

    public static class Builder {
        private final Scope scope;
        private HookScriptType type;

        public Builder(@Nonnull Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        @Nonnull
        public HookScriptConfigCriteria build() {
            return new HookScriptConfigCriteria(this);
        }

        @Nonnull
        public Builder type(@Nullable HookScriptType value) {
            this.type = value;
            return this;
        }
    }
}

