/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.stash.internal.comment.AbstractDiffCommentAnchorSearchCriteria;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class PullRequestAnchorSearchCriteria
extends AbstractDiffCommentAnchorSearchCriteria {
    private final Set<CommentThreadDiffAnchorType> diffTypes;
    private final InternalPullRequest pullRequest;

    private PullRequestAnchorSearchCriteria(@Nonnull Builder builder) {
        super(builder);
        this.diffTypes = builder.diffTypes.build();
        this.pullRequest = builder.pullRequest;
    }

    @Nonnull
    public Collection<CommentThreadDiffAnchorType> getDiffTypes() {
        return this.diffTypes;
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    public static class Builder
    extends AbstractDiffCommentAnchorSearchCriteria.AbstractBuilder<Builder, PullRequestAnchorSearchCriteria> {
        private final ImmutableSet.Builder<CommentThreadDiffAnchorType> diffTypes = ImmutableSet.builder();
        private final InternalPullRequest pullRequest;

        public Builder(@Nonnull InternalPullRequest value) {
            this.pullRequest = Objects.requireNonNull(value, "pullRequest");
        }

        @Override
        @Nonnull
        public PullRequestAnchorSearchCriteria build() {
            return new PullRequestAnchorSearchCriteria(this);
        }

        @Nonnull
        public Builder diffType(@Nullable CommentThreadDiffAnchorType value) {
            Builder.addIf(Objects::nonNull, this.diffTypes, (Object)value);
            return this.self();
        }

        @Nonnull
        public Builder diffType(@Nullable Iterable<CommentThreadDiffAnchorType> values) {
            Builder.addIf(Objects::nonNull, this.diffTypes, values);
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

