/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestCommitSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class PullRequestCommitSearchCriteria {
    private final String commitId;
    private final Set<PullRequestState> states;
    private final Integer toRepositoryId;

    private PullRequestCommitSearchCriteria(Builder builder) {
        this.commitId = builder.commitId;
        this.states = builder.states.build();
        this.toRepositoryId = builder.toRepositoryId;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Set<PullRequestState> getStates() {
        return this.states;
    }

    @Nullable
    public Integer getToRepositoryId() {
        return this.toRepositoryId;
    }

    public boolean hasStates() {
        return !this.states.isEmpty();
    }

    public boolean hasToRepositoryId() {
        return this.toRepositoryId != null;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private final ImmutableSet.Builder<PullRequestState> states;
        private Integer toRepositoryId;

        public Builder(@Nonnull String commitId) {
            this.commitId = Builder.requireNonBlank((String)commitId, (String)"commitId");
            this.states = ImmutableSet.builder();
        }

        public Builder(@Nonnull PullRequestCommitSearchRequest request) {
            this(Objects.requireNonNull(request, "request").getCommitId());
            this.states.addAll((Iterable)request.getStates());
            this.toRepositoryId = request.getToRepositoryId();
        }

        @Nonnull
        public PullRequestCommitSearchCriteria build() {
            return new PullRequestCommitSearchCriteria(this);
        }

        @Nonnull
        public Builder state(@Nullable PullRequestState value) {
            Builder.addIf(Objects::nonNull, this.states, (Object)value);
            return this;
        }

        @Nonnull
        public Builder toRepositoryId(@Nullable Integer value) {
            this.toRepositoryId = value;
            return this;
        }
    }
}

