/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class PullRequestParticipantCriteria {
    private final Set<PullRequestRole> roles;
    private final Set<PullRequestParticipantStatus> statuses;
    private final ApplicationUser user;

    public PullRequestParticipantCriteria(Builder builder) {
        this.statuses = ImmutableSet.copyOf(builder.statuses);
        this.roles = builder.roles.build();
        this.user = builder.user;
    }

    @Nonnull
    public Set<PullRequestParticipantStatus> getStatuses() {
        return this.statuses;
    }

    @Nullable
    public Set<PullRequestRole> getRoles() {
        return this.roles;
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public static class Builder
    extends BuilderSupport {
        private final EnumSet<PullRequestParticipantStatus> statuses;
        private final ApplicationUser user;
        private final ImmutableSet.Builder<PullRequestRole> roles;

        public Builder(@Nonnull ApplicationUser user) {
            this.user = Objects.requireNonNull(user, "user");
            this.statuses = EnumSet.noneOf(PullRequestParticipantStatus.class);
            this.roles = new ImmutableSet.Builder();
        }

        @Nonnull
        public PullRequestParticipantCriteria build() {
            return new PullRequestParticipantCriteria(this);
        }

        @Nonnull
        public Builder role(@Nullable PullRequestRole value) {
            Builder.addIf(Objects::nonNull, this.roles, (Object)value);
            return this;
        }

        @Nonnull
        public Builder roles(@Nullable Iterable<PullRequestRole> values) {
            Builder.addIf(Objects::nonNull, this.roles, values);
            return this;
        }

        @Nonnull
        public Builder status(@Nullable PullRequestParticipantStatus value) {
            Builder.addIf(Objects::nonNull, this.statuses, (Object)value);
            return this;
        }

        @Nonnull
        public Builder statuses(@Nonnull Iterable<PullRequestParticipantStatus> values) {
            Builder.addIf(Objects::nonNull, this.statuses, values);
            return this;
        }
    }
}

