/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipantSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class PullRequestParticipantSearchCriteria {
    private final InternalRepository fromRepository;
    private final PullRequestRole role;
    private final InternalRepository toRepository;

    private PullRequestParticipantSearchCriteria(Builder builder) {
        this.fromRepository = builder.fromRepository;
        this.role = builder.role;
        this.toRepository = builder.toRepository;
    }

    @Nonnull
    public Optional<InternalRepository> getFromRepository() {
        return Optional.ofNullable(this.fromRepository);
    }

    @Nonnull
    public Optional<PullRequestRole> getRole() {
        return Optional.ofNullable(this.role);
    }

    @Nonnull
    public Optional<InternalRepository> getToRepository() {
        return Optional.ofNullable(this.toRepository);
    }

    public static class Builder {
        private InternalRepository fromRepository;
        private PullRequestRole role;
        private InternalRepository toRepository;

        public Builder() {
        }

        public Builder(@Nonnull PullRequestParticipantSearchRequest searchRequest) {
            this.fromRepository = Objects.requireNonNull(searchRequest, "searchRequest").getFromRepository().map(InternalConverter::convertToInternalRepository).orElse(null);
            this.role = searchRequest.getRole().orElse(null);
            this.toRepository = searchRequest.getToRepository().map(InternalConverter::convertToInternalRepository).orElse(null);
        }

        @Nonnull
        public PullRequestParticipantSearchCriteria build() {
            return new PullRequestParticipantSearchCriteria(this);
        }

        @Nonnull
        public Builder fromRepository(@Nullable InternalRepository value) {
            this.fromRepository = value;
            return this;
        }

        @Nonnull
        public Builder role(@Nullable PullRequestRole value) {
            this.role = value;
            return this;
        }

        @Nonnull
        public Builder toRepository(@Nullable InternalRepository value) {
            this.toRepository = value;
            return this;
        }
    }
}

