/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.pull.PullRequestParticipantCriteria;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PullRequestSearchCriteria {
    private final Date closedSince;
    private final Boolean draft;
    private final String filterText;
    private final Set<String> fromRefIds;
    private final Integer fromRepositoryId;
    private final String hierarchyId;
    private final List<PullRequestOrder> orders;
    private final Iterable<PullRequestParticipantCriteria> participants;
    private final Set<PullRequestState> states;
    private final Set<String> toRefIds;
    private final Integer toRepositoryId;
    private final Date updatedSince;
    private final boolean withDescription;

    private PullRequestSearchCriteria(Builder builder) {
        this.closedSince = builder.closedSince;
        this.draft = builder.draft;
        this.filterText = builder.filterText;
        this.fromRefIds = builder.fromRefIds.build();
        this.fromRepositoryId = builder.fromRepositoryId;
        this.hierarchyId = builder.hierarchyId;
        this.orders = builder.orders.build();
        this.participants = builder.participants.build();
        this.states = builder.states.build();
        this.toRefIds = builder.toRefIds.build();
        this.toRepositoryId = builder.toRepositoryId;
        this.updatedSince = builder.updatedSince;
        this.withDescription = builder.withDescription;
    }

    @Nullable
    public Date getClosedSince() {
        return this.closedSince;
    }

    public Collection<String> getFromRefIds() {
        return this.fromRefIds;
    }

    @Nullable
    public String getFilterText() {
        return this.filterText;
    }

    public Integer getFromRepositoryId() {
        return this.fromRepositoryId;
    }

    public String getHierarchyId() {
        return this.hierarchyId;
    }

    @Nonnull
    public List<PullRequestOrder> getOrders() {
        return this.orders;
    }

    public Iterable<PullRequestParticipantCriteria> getParticipants() {
        return this.participants;
    }

    public Set<PullRequestState> getStates() {
        return this.states;
    }

    public Collection<String> getToRefIds() {
        return this.toRefIds;
    }

    public Integer getToRepositoryId() {
        return this.toRepositoryId;
    }

    @Nullable
    public Date getUpdatedSince() {
        return this.updatedSince;
    }

    @Nullable
    public Boolean isDraft() {
        return this.draft;
    }

    public boolean isWithDescription() {
        return this.withDescription;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> fromRefIds = ImmutableSet.builder();
        private final ImmutableList.Builder<PullRequestOrder> orders = ImmutableList.builder();
        private final ImmutableList.Builder<PullRequestParticipantCriteria> participants = ImmutableList.builder();
        private final ImmutableSet.Builder<PullRequestState> states = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> toRefIds = ImmutableSet.builder();
        private Date closedSince;
        private Boolean draft;
        private String filterText;
        private Integer fromRepositoryId;
        private String hierarchyId;
        private Integer toRepositoryId;
        private Date updatedSince;
        private boolean withDescription;

        @Nonnull
        public PullRequestSearchCriteria build() {
            return new PullRequestSearchCriteria(this);
        }

        @Nonnull
        public Builder closedSince(@Nullable Date value) {
            this.closedSince = value;
            return this;
        }

        @Nonnull
        public Builder draft(@Nullable Boolean value) {
            this.draft = value;
            return this;
        }

        @Nonnull
        public Builder filterText(@Nullable String value) {
            this.filterText = StringUtils.stripToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder fromRefIds(@Nullable Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.fromRefIds, values);
            return this;
        }

        @Nonnull
        public Builder fromRepositoryId(@Nullable Integer value) {
            this.fromRepositoryId = value;
            return this;
        }

        public Builder hierarchyId(@Nullable String value) {
            this.hierarchyId = value;
            return this;
        }

        @Nonnull
        public Builder order(@Nullable PullRequestOrder value) {
            Builder.addIf(Objects::nonNull, this.orders, (Object)value);
            return this;
        }

        @Nonnull
        public Builder orders(@Nullable Iterable<PullRequestOrder> values) {
            Builder.addIf(Objects::nonNull, this.orders, values);
            return this;
        }

        @Nonnull
        public Builder participant(@Nullable PullRequestParticipantCriteria value) {
            Builder.addIf(Objects::nonNull, this.participants, (Object)value);
            return this;
        }

        @Nonnull
        public Builder participants(@Nullable Iterable<PullRequestParticipantCriteria> values) {
            Builder.addIf(Objects::nonNull, this.participants, values);
            return this;
        }

        @Nonnull
        public Builder state(@Nullable PullRequestState value) {
            Builder.addIf(Objects::nonNull, this.states, (Object)value);
            return this;
        }

        @Nonnull
        public Builder states(@Nullable Iterable<PullRequestState> values) {
            Builder.addIf(Objects::nonNull, this.states, values);
            return this;
        }

        @Nonnull
        public Builder toRefIds(@Nullable Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.toRefIds, values);
            return this;
        }

        @Nonnull
        public Builder toRepositoryId(@Nullable Integer value) {
            this.toRepositoryId = value;
            return this;
        }

        @Nonnull
        public Builder updatedSince(@Nullable Date value) {
            this.updatedSince = value;
            return this;
        }

        @Nonnull
        public Builder withDescription(boolean value) {
            this.withDescription = value;
            return this;
        }
    }
}

