/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.querybuilder;

import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class HqlQueryBuilder<E> {
    private final String entityAlias;
    private final Class<E> entityClass;
    private HqlGroupByQueryComponent groupByQueryComponent;
    private HqlJoinQueryComponent joinQueryComponent;
    private HqlOrderByQueryComponent orderByQueryComponent;
    private HqlSelectQueryComponent selectQueryFragment;
    private HqlWhereQueryComponent whereQueryComponent;

    private HqlQueryBuilder(Class<E> entityClass) {
        this.entityClass = entityClass;
        this.entityAlias = StringUtils.uncapitalize((String)entityClass.getSimpleName());
    }

    @Nonnull
    public static HqlSelectProperty distinctRowCount(@Nonnull String propertyName) {
        Objects.requireNonNull(propertyName, "propertyName");
        return HqlQueryBuilder.rowCount("DISTINCT " + propertyName);
    }

    @Nonnull
    public static HqlSelectProperty property(@Nonnull String propertyName) {
        Objects.requireNonNull(propertyName, "propertyName");
        return new HqlSelectProperty(propertyName, true);
    }

    @Nonnull
    public static HqlSelectProperty rowCount(@Nonnull String propertyName) {
        Objects.requireNonNull(propertyName, "propertyName");
        return new HqlSelectProperty("COUNT(" + propertyName + ")", false);
    }

    @Nonnull
    public static HqlSelectProperty rowCount(@Nonnull String propertyName, Class<?> explicitEntity) {
        Objects.requireNonNull(propertyName, "propertyName");
        String explicitEntityAlias = StringUtils.uncapitalize((String)explicitEntity.getSimpleName());
        return new HqlSelectProperty("COUNT(" + explicitEntityAlias + "." + propertyName + ")", false);
    }

    @Nonnull
    public static HqlSelectProperty rowCount() {
        return HqlQueryBuilder.rowCount("*");
    }

    @Nonnull
    public static <E> HqlQueryBuilder<E> selectDistinctPropertiesFrom(@Nonnull Class<E> entityClass, HqlSelectProperty ... selectProperties) {
        HqlQueryBuilder<E> queryBuilder = new HqlQueryBuilder<E>(Objects.requireNonNull(entityClass, "entityClass"));
        queryBuilder.selectQueryFragment = new HqlSelectQueryComponent(entityClass, "DISTINCT", queryBuilder.entityAlias, selectProperties);
        return queryBuilder;
    }

    @Nonnull
    public static <E> HqlQueryBuilder<E> selectFrom(@Nonnull Class<E> entityClass) {
        HqlQueryBuilder<E> queryBuilder = new HqlQueryBuilder<E>(Objects.requireNonNull(entityClass, "entityClass"));
        queryBuilder.selectQueryFragment = new HqlSelectQueryComponent(entityClass, queryBuilder.entityAlias);
        return queryBuilder;
    }

    @Nonnull
    public static <E> HqlQueryBuilder<E> selectNewClassFrom(@Nonnull Class<E> entityClass, @Nonnull Class<?> resultsClass, HqlSelectProperty ... selectProperties) {
        HqlQueryBuilder<E> queryBuilder = new HqlQueryBuilder<E>(Objects.requireNonNull(entityClass, "entityClass"));
        queryBuilder.selectQueryFragment = new HqlSelectQueryComponent(entityClass, resultsClass, queryBuilder.entityAlias, selectProperties);
        return queryBuilder;
    }

    @Nonnull
    public static <E> HqlQueryBuilder<E> selectPropertiesFrom(@Nonnull Class<E> entityClass, HqlSelectProperty ... selectProperties) {
        HqlQueryBuilder<E> queryBuilder = new HqlQueryBuilder<E>(Objects.requireNonNull(entityClass, "entityClass"));
        queryBuilder.selectQueryFragment = new HqlSelectQueryComponent(entityClass, queryBuilder.entityAlias, selectProperties);
        return queryBuilder;
    }

    @Nonnull
    public String buildHql() {
        String whereQueryFragment;
        StringBuilder query = new StringBuilder(this.selectQueryFragment.buildHqlFragment());
        if (this.joinQueryComponent != null && !StringUtils.isBlank((CharSequence)this.joinQueryComponent.buildHqlFragment())) {
            query.append(" ").append(this.joinQueryComponent.buildHqlFragment());
        }
        if (this.whereQueryComponent != null && !StringUtils.isBlank((CharSequence)(whereQueryFragment = this.whereQueryComponent.buildHqlFragment(this.entityAlias)))) {
            query.append(" WHERE ").append(whereQueryFragment);
        }
        if (this.groupByQueryComponent != null && !StringUtils.isBlank((CharSequence)this.groupByQueryComponent.buildHqlFragment())) {
            query.append(" GROUP BY ").append(this.groupByQueryComponent.buildHqlFragment());
        }
        if (this.orderByQueryComponent != null && !StringUtils.isBlank((CharSequence)this.orderByQueryComponent.buildHqlFragment())) {
            query.append(" ORDER BY ").append(this.orderByQueryComponent.buildHqlFragment());
        }
        return query.toString();
    }

    @Nonnull
    public Query<E> buildQuery(@Nonnull Session session) {
        Objects.requireNonNull(session, "session");
        Query query = session.createQuery(this.buildHql(), this.entityClass);
        this.buildParameters().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        return query;
    }

    @Nonnull
    public <R> Query<R> buildQuery(@Nonnull Session session, @Nonnull Class<R> resultClass) {
        Objects.requireNonNull(session, "session");
        Objects.requireNonNull(resultClass, "resultsClass");
        Query query = session.createQuery(this.buildHql(), resultClass);
        this.buildParameters().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        return query;
    }

    @Nonnull
    public HqlQueryBuilder<E> groupBy(String ... groupByProperties) {
        if (this.groupByQueryComponent == null) {
            this.groupByQueryComponent = new HqlGroupByQueryComponent();
        }
        this.groupByQueryComponent.addGroupProperties(this.entityAlias, groupByProperties);
        return this;
    }

    @Nonnull
    public HqlQueryBuilder<E> join(String property, JoinType joinType) {
        if (this.joinQueryComponent == null) {
            this.joinQueryComponent = new HqlJoinQueryComponent();
        }
        this.joinQueryComponent.addJoinProperty(this.entityAlias, property, joinType, false);
        return this;
    }

    @Nonnull
    public HqlQueryBuilder<E> joinFetch(String property, JoinType joinType) {
        if (this.joinQueryComponent == null) {
            this.joinQueryComponent = new HqlJoinQueryComponent();
        }
        this.joinQueryComponent.addJoinProperty(this.entityAlias, property, joinType, true);
        return this;
    }

    @Nonnull
    public HqlQueryBuilder<E> orderBy(HqlQueryOrder ... queryOrders) {
        if (this.orderByQueryComponent == null) {
            this.orderByQueryComponent = new HqlOrderByQueryComponent();
        }
        this.orderByQueryComponent.addOrders(this.entityAlias, queryOrders);
        return this;
    }

    public HqlQueryBuilder<E> orderBy(Iterable<HqlQueryOrder> queryOrders) {
        if (this.orderByQueryComponent == null) {
            this.orderByQueryComponent = new HqlOrderByQueryComponent();
        }
        queryOrders.forEach(queryOrder -> this.orderByQueryComponent.addOrders(this.entityAlias, (HqlQueryOrder)queryOrder));
        return this;
    }

    @Nonnull
    public HqlQueryBuilder<E> where(@Nonnull HqlWhereQueryComponent whereQueryComponent) {
        this.whereQueryComponent = Objects.requireNonNull(whereQueryComponent, "whereQueryComponent");
        whereQueryComponent.setPropertyAlias(1);
        return this;
    }

    private static String toLowerProperty(String property) {
        return "LOWER(" + property + ")";
    }

    private Map<String, Object> buildParameters() {
        if (this.whereQueryComponent == null) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder parameterMapBuilder = new ImmutableMap.Builder();
        this.whereQueryComponent.addQueryProperties((ImmutableMap.Builder<String, Object>)parameterMapBuilder);
        return parameterMapBuilder.build();
    }

    public static class HqlSelectProperty {
        private final boolean addEntityAlias;
        private final String selectPropertyFragment;

        private HqlSelectProperty(String selectPropertyFragment, boolean addEntityAlias) {
            this.selectPropertyFragment = selectPropertyFragment;
            this.addEntityAlias = addEntityAlias;
        }

        private String buildHqlFragment(String entityAlias) {
            if (this.addEntityAlias) {
                return entityAlias + "." + this.selectPropertyFragment;
            }
            return this.selectPropertyFragment;
        }
    }

    private static class HqlSelectQueryComponent {
        private StringBuilder selectFragment = new StringBuilder();

        public HqlSelectQueryComponent(Class<?> entityClass, String entityAlias) {
            this.addFromFragmentToBuilder(this.selectFragment, entityClass, entityAlias);
        }

        public HqlSelectQueryComponent(Class<?> entityClass, String entityAlias, HqlSelectProperty ... selectProperties) {
            this.selectFragment = new StringBuilder("SELECT ");
            this.addPropertySelectFragmentToBuilder(this.selectFragment, entityAlias, selectProperties);
            this.selectFragment.append(" ");
            this.addFromFragmentToBuilder(this.selectFragment, entityClass, entityAlias);
        }

        public HqlSelectQueryComponent(Class<?> entityClass, String selectFunctionFragment, String entityAlias, HqlSelectProperty ... selectProperties) {
            this.selectFragment = new StringBuilder("SELECT " + selectFunctionFragment + " ");
            this.addPropertySelectFragmentToBuilder(this.selectFragment, entityAlias, selectProperties);
            this.selectFragment.append(" ");
            this.addFromFragmentToBuilder(this.selectFragment, entityClass, entityAlias);
        }

        public HqlSelectQueryComponent(Class<?> entityClass, Class<?> resultClass, String entityAlias, HqlSelectProperty ... selectProperties) {
            this.selectFragment = new StringBuilder("SELECT NEW " + resultClass.getName() + "(");
            this.addPropertySelectFragmentToBuilder(this.selectFragment, entityAlias, selectProperties);
            this.selectFragment.append(") ");
            this.addFromFragmentToBuilder(this.selectFragment, entityClass, entityAlias);
        }

        public String buildHqlFragment() {
            return this.selectFragment.toString();
        }

        private void addFromFragmentToBuilder(StringBuilder stringBuilder, Class<?> entityClass, String entityAlias) {
            stringBuilder.append("FROM ").append(entityClass.getSimpleName()).append(" AS ").append(entityAlias);
        }

        private void addPropertySelectFragmentToBuilder(StringBuilder builder, String entityAlias, HqlSelectProperty ... selectProperties) {
            for (int i = 0; i < selectProperties.length; ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(selectProperties[i].buildHqlFragment(entityAlias));
            }
        }
    }

    private static class HqlJoinQueryComponent {
        private StringBuilder joinFragment;

        private HqlJoinQueryComponent() {
        }

        protected void addJoinProperty(String entityAlias, String property, JoinType joinType, boolean fetch) {
            if (!property.isBlank()) {
                Object join;
                Object object = join = fetch ? String.valueOf((Object)joinType) + " FETCH" : joinType.toString();
                if (this.joinFragment == null) {
                    this.joinFragment = new StringBuilder((String)join + " " + entityAlias + "." + property);
                } else {
                    this.joinFragment.append(" " + (String)join + " " + entityAlias + "." + property);
                }
            }
        }

        public String buildHqlFragment() {
            return this.joinFragment.toString();
        }
    }

    public static abstract class HqlWhereQueryComponent {
        @Nonnull
        public static HqlWhereConditionalQueryComponent and(@Nonnull List<HqlWhereQueryComponent> conditions) {
            Objects.requireNonNull(conditions, "conditions");
            return new HqlWhereConditionalQueryComponent("AND", conditions);
        }

        @Nonnull
        public static HqlWhereConditionalQueryComponent and(HqlWhereQueryComponent ... conditions) {
            Objects.requireNonNull(conditions, "conditions");
            return new HqlWhereConditionalQueryComponent("AND", Arrays.asList(conditions));
        }

        @Nonnull
        public static HqlWhereQueryComponent equal(@Nonnull String property, @Nonnull Object value) {
            Objects.requireNonNull(property, "property");
            Objects.requireNonNull(value, "value");
            return new HqlWhereComparatorQueryComponent(property, "=", value);
        }

        @Nonnull
        public static HqlWhereQueryComponent ilike(@Nonnull String property, @Nonnull String value) {
            Objects.requireNonNull(property, "property");
            Objects.requireNonNull(value, "value");
            return new HqlWhereComparatorQueryComponent(property, "LIKE", value).ignoreCase();
        }

        @Nonnull
        public static HqlWhereQueryComponent in(@Nonnull String property, @Nonnull Collection<?> values) {
            Objects.requireNonNull(property, "property");
            Objects.requireNonNull(values, "values");
            return new HqlWhereComparatorQueryComponent(property, "IN", values);
        }

        @Nonnull
        public static HqlWhereQueryComponent inSubQuery(@Nonnull String property, @Nonnull HqlQueryBuilder<?> subQueryBuilder) {
            Objects.requireNonNull(property, "property");
            Objects.requireNonNull(subQueryBuilder, "nestedQueryBuilder");
            return new HqlWhereNestedQueryComponent(property, "IN", subQueryBuilder);
        }

        @Nonnull
        public static HqlWhereQueryComponent isNotNull(@Nonnull String property) {
            Objects.requireNonNull(property, "property");
            return new HqlWhereIsNullQueryComponent(property, false);
        }

        @Nonnull
        public static HqlWhereQueryComponent isNull(@Nonnull String property) {
            Objects.requireNonNull(property, "property");
            return new HqlWhereIsNullQueryComponent(property, true);
        }

        @Nonnull
        public static HqlWhereQueryComponent like(@Nonnull String property, @Nonnull String value) {
            Objects.requireNonNull(property, "property");
            Objects.requireNonNull(value, "value");
            return new HqlWhereComparatorQueryComponent(property, "LIKE", value);
        }

        @Nonnull
        public static HqlWhereQueryComponent not(@Nonnull HqlWhereQueryComponent condition) {
            Objects.requireNonNull(condition, "condition");
            return new HqlWhereNotQueryComponent(condition);
        }

        @Nonnull
        public static HqlWhereConditionalQueryComponent or(@Nonnull List<HqlWhereQueryComponent> conditions) {
            Objects.requireNonNull(conditions, "conditions");
            return new HqlWhereConditionalQueryComponent("OR", conditions);
        }

        @Nonnull
        public static HqlWhereConditionalQueryComponent or(HqlWhereQueryComponent ... conditions) {
            Objects.requireNonNull(conditions, "conditions");
            return new HqlWhereConditionalQueryComponent("OR", Arrays.asList(conditions));
        }

        protected abstract void addQueryProperties(ImmutableMap.Builder<String, Object> var1);

        protected abstract String buildHqlFragment(String var1);

        protected abstract int setPropertyAlias(int var1);
    }

    private static class HqlGroupByQueryComponent {
        private StringBuilder groupByFragment;

        private HqlGroupByQueryComponent() {
        }

        public void addGroupProperties(String entityAlias, String ... groupByProperties) {
            for (String groupByProperty : groupByProperties) {
                if (this.groupByFragment == null) {
                    this.groupByFragment = new StringBuilder(entityAlias + "." + groupByProperty);
                    continue;
                }
                this.groupByFragment.append(", ").append(entityAlias).append(".").append(groupByProperty);
            }
        }

        public String buildHqlFragment() {
            return this.groupByFragment.toString();
        }
    }

    private static class HqlOrderByQueryComponent {
        private StringBuilder orderByFragment;

        private HqlOrderByQueryComponent() {
        }

        public void addOrders(String entityAlias, HqlQueryOrder ... queryOrders) {
            for (HqlQueryOrder order : queryOrders) {
                if (this.orderByFragment == null) {
                    this.orderByFragment = new StringBuilder(order.buildHqlFragment(entityAlias));
                    continue;
                }
                this.orderByFragment.append(", ").append(order.buildHqlFragment(entityAlias));
            }
        }

        public String buildHqlFragment() {
            return this.orderByFragment.toString();
        }
    }

    public static enum JoinType {
        INNER_JOIN,
        LEFT_OUTER_JOIN;


        public String toString() {
            return this.name().replace("_", " ");
        }
    }

    public static class HqlQueryOrder {
        private final boolean isAscending;
        private final String propertyName;
        private boolean ignoreCase;
        private String nullSorting;

        private HqlQueryOrder(boolean isAscending, String propertyName) {
            this.isAscending = isAscending;
            this.propertyName = propertyName;
        }

        @Nonnull
        public static HqlQueryOrder asc(@Nonnull String propertyName) {
            Objects.requireNonNull(propertyName, "propertyName");
            return new HqlQueryOrder(true, propertyName);
        }

        @Nonnull
        public static HqlQueryOrder desc(@Nonnull String propertyName) {
            Objects.requireNonNull(propertyName, "propertyName");
            return new HqlQueryOrder(false, propertyName);
        }

        public HqlQueryOrder ignoreCase() {
            this.ignoreCase = true;
            return this;
        }

        @Nonnull
        public HqlQueryOrder nullsFirst() {
            this.nullSorting = "NULLS FIRST";
            return this;
        }

        private String buildHqlFragment(String entityAlias) {
            Object columnSelector = entityAlias + "." + this.propertyName;
            if (this.ignoreCase) {
                columnSelector = HqlQueryBuilder.toLowerProperty((String)columnSelector);
            }
            return (String)columnSelector + (this.isAscending ? " ASC" : " DESC") + (String)(StringUtils.isBlank((CharSequence)this.nullSorting) ? "" : " " + this.nullSorting);
        }
    }

    private static class HqlWhereNotQueryComponent
    extends HqlWhereQueryComponent {
        HqlWhereQueryComponent comparator;

        private HqlWhereNotQueryComponent(HqlWhereQueryComponent comparator) {
            this.comparator = comparator;
        }

        @Override
        protected void addQueryProperties(ImmutableMap.Builder<String, Object> propertyMapBuilder) {
            this.comparator.addQueryProperties(propertyMapBuilder);
        }

        @Override
        protected String buildHqlFragment(String entityAlias) {
            return "NOT " + this.comparator.buildHqlFragment(entityAlias);
        }

        @Override
        protected int setPropertyAlias(int aliasId) {
            return this.comparator.setPropertyAlias(aliasId);
        }
    }

    private static class HqlWhereNestedQueryComponent
    extends HqlWhereQueryComponent {
        private final HqlQueryBuilder<?> nestedQuery;
        private final String operator;
        private final String property;

        private HqlWhereNestedQueryComponent(String property, String operator, HqlQueryBuilder<?> nestedQuery) {
            this.property = property;
            this.operator = operator;
            this.nestedQuery = nestedQuery;
        }

        @Override
        protected void addQueryProperties(ImmutableMap.Builder<String, Object> propertyMapBuilder) {
            this.nestedQuery.whereQueryComponent.addQueryProperties(propertyMapBuilder);
        }

        @Override
        protected String buildHqlFragment(String entityAlias) {
            return entityAlias + "." + this.property + " " + this.operator + " (" + this.nestedQuery.buildHql() + ")";
        }

        @Override
        protected int setPropertyAlias(int aliasId) {
            this.nestedQuery.whereQueryComponent.setPropertyAlias(aliasId);
            return ++aliasId;
        }
    }

    private static class HqlWhereIsNullQueryComponent
    extends HqlWhereQueryComponent {
        private final String operator;
        private final String property;

        private HqlWhereIsNullQueryComponent(String property, boolean isNull) {
            this.property = property;
            this.operator = isNull ? "IS NULL" : "IS NOT NULL";
        }

        @Override
        protected void addQueryProperties(ImmutableMap.Builder<String, Object> propertyMapBuilder) {
        }

        @Override
        protected String buildHqlFragment(String entityAlias) {
            return entityAlias + "." + this.property + " " + this.operator;
        }

        @Override
        protected int setPropertyAlias(int aliasId) {
            return aliasId;
        }
    }

    public static class HqlWhereConditionalQueryComponent
    extends HqlWhereQueryComponent {
        private final List<HqlWhereQueryComponent> conditions;
        private final String operator;

        private HqlWhereConditionalQueryComponent(String operator, List<HqlWhereQueryComponent> conditions) {
            this.operator = operator;
            this.conditions = new ArrayList<HqlWhereQueryComponent>(conditions);
        }

        public HqlWhereConditionalQueryComponent add(HqlWhereQueryComponent ... conditions) {
            this.conditions.addAll(Arrays.asList(conditions));
            return this;
        }

        public HqlWhereConditionalQueryComponent addAll(HqlWhereConditionalQueryComponent conditions) {
            this.conditions.addAll(conditions.conditions);
            return this;
        }

        @Override
        protected void addQueryProperties(ImmutableMap.Builder<String, Object> propertyMapBuilder) {
            this.conditions.forEach(condition -> condition.addQueryProperties(propertyMapBuilder));
        }

        @Override
        protected String buildHqlFragment(String entityAlias) {
            if (this.conditions.isEmpty()) {
                return "";
            }
            if (this.conditions.size() == 1) {
                return this.conditions.get(0).buildHqlFragment(entityAlias);
            }
            StringBuilder fragmentBuilder = new StringBuilder("(");
            Iterator<HqlWhereQueryComponent> iterator = this.conditions.iterator();
            while (iterator.hasNext()) {
                fragmentBuilder.append(iterator.next().buildHqlFragment(entityAlias));
                if (!iterator.hasNext()) continue;
                fragmentBuilder.append(" ").append(this.operator).append(" ");
            }
            return fragmentBuilder.append(")").toString();
        }

        public boolean isEmpty() {
            return this.conditions.size() == 0;
        }

        @Override
        protected int setPropertyAlias(int aliasId) {
            for (HqlWhereQueryComponent condition : this.conditions) {
                aliasId = condition.setPropertyAlias(aliasId);
            }
            return aliasId;
        }
    }

    public static class HqlWhereComparatorQueryComponent
    extends HqlWhereQueryComponent {
        private final String operator;
        private final String property;
        private final Object value;
        private boolean ignoreCase;
        private String propertyAlias;

        private HqlWhereComparatorQueryComponent(String property, String operator, Object value) {
            this.property = property;
            this.operator = operator;
            this.value = value;
        }

        @Override
        protected void addQueryProperties(ImmutableMap.Builder<String, Object> propertyMapBuilder) {
            propertyMapBuilder.put((Object)this.propertyAlias, this.value);
        }

        @Override
        protected String buildHqlFragment(String entityAlias) {
            if (this.ignoreCase) {
                return HqlQueryBuilder.toLowerProperty(entityAlias + "." + this.property) + " " + this.operator + " " + HqlQueryBuilder.toLowerProperty(":" + this.propertyAlias);
            }
            return entityAlias + "." + this.property + " " + this.operator + " :" + this.propertyAlias;
        }

        protected HqlWhereComparatorQueryComponent ignoreCase() {
            this.ignoreCase = true;
            return this;
        }

        @Override
        protected int setPropertyAlias(int aliasId) {
            this.propertyAlias = CaseUtils.toCamelCase((String)this.property, (boolean)false, (char[])new char[]{'.'}) + aliasId;
            return ++aliasId;
        }
    }
}

